/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.teleport;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.commons.selections.WorldPoint;
import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.UserIdent;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandSetSpawn
extends ForgeEssentialsCommandBase {
    public static final String PERM_SETSPAWN = "fe.perm.setspawn";

    public String func_71517_b() {
        return "setspawn";
    }

    @Override
    public void processCommandPlayer(EntityPlayerMP sender, String[] args) {
        if (args.length <= 0) {
            OutputHandler.chatConfirmation((ICommandSender)sender, "Usage: /setspawn here|bed|clear");
        } else {
            UserIdent ident = new UserIdent(sender);
            switch (args[0].toLowerCase()) {
                case "here": {
                    APIRegistry.perms.setPlayerPermissionProperty(ident, "fe.internal.spawn", new WorldPoint((Entity)sender).toString());
                    break;
                }
                case "bed": {
                    APIRegistry.perms.setPlayerPermissionProperty(ident, "fe.internal.spawn", "bed");
                    break;
                }
                case "clear": {
                    APIRegistry.perms.getServerZone().clearPlayerPermission(ident, "fe.internal.spawn");
                    break;
                }
                default: {
                    throw new CommandException("Invalid location argument", new Object[0]);
                }
            }
        }
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CommandSetSpawn.getListOfStringsMatchingLastWord(args[0], "here", "bed", "clear");
        }
        return null;
    }

    @Override
    public void processCommandConsole(ICommandSender sender, String[] args) {
        throw new CommandException("This command cannot be used from console. Use \"/feperm user <USER> spawn\" instead", new Object[0]);
    }

    @Override
    public boolean canConsoleUseCommand() {
        return false;
    }

    @Override
    public String getPermissionNode() {
        return PERM_SETSPAWN;
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.OP;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/setspawn help Set the spawn point.";
    }
}

