/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.teleport;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.commons.selections.WarpPoint;
import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.core.misc.TeleportHelper;
import com.forgeessentials.teleport.CommandBack;
import com.forgeessentials.teleport.util.PWarp;
import com.forgeessentials.teleport.util.TeleportDataManager;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.PlayerInfo;
import com.forgeessentials.util.UserIdent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.permissions.PermissionsManager;
import org.apache.commons.lang3.StringUtils;

public class CommandPersonalWarp
extends ForgeEssentialsCommandBase {
    public final String PERM_SET_LIMIT = this.getPermissionNode() + ".setLimit";
    public final String PERM_LIMIT_PROP = this.getPermissionNode() + ".max";

    public String func_71517_b() {
        return "personalwarp";
    }

    public List<String> func_71514_a() {
        ArrayList<String> aliases = new ArrayList<String>();
        aliases.add("pw");
        aliases.add("pwarp");
        return aliases;
    }

    @Override
    public void processCommandPlayer(EntityPlayerMP sender, String[] args) {
        HashMap<String, PWarp> map = TeleportDataManager.privateWarps.get(sender.getPersistentID().toString());
        if (map == null) {
            map = new HashMap();
            TeleportDataManager.privateWarps.put(sender.getPersistentID().toString(), map);
        }
        if (args.length == 0) {
            if (map.size() == 0) {
                OutputHandler.chatNotification((ICommandSender)sender, "You have no personal warps.");
            } else {
                OutputHandler.chatNotification((ICommandSender)sender, "Your personal warps:");
                OutputHandler.chatNotification((ICommandSender)sender, StringUtils.join((Object[])map.keySet().toArray(), (String)", "));
            }
        } else if (args.length == 1) {
            if (map.containsKey(args[0])) {
                PWarp warp = map.get(args[0]);
                PlayerInfo playerInfo = PlayerInfo.getPlayerInfo(sender.getPersistentID());
                playerInfo.setLastTeleportOrigin(new WarpPoint((Entity)sender));
                CommandBack.justDied.remove(sender.getPersistentID());
                TeleportHelper.teleport(sender, warp.getPoint());
            } else {
                OutputHandler.chatError((ICommandSender)sender, "That personal warp doesn't exist!");
            }
        } else if (args[0].equalsIgnoreCase("add")) {
            if (args.length == 1) {
                OutputHandler.chatError((ICommandSender)sender, "You must specify a warp name!");
                return;
            }
            if (!map.containsKey(args[1])) {
                Integer prop = APIRegistry.perms.getUserPermissionPropertyInt(new UserIdent(sender), this.PERM_LIMIT_PROP);
                if (prop == null || prop == -1) {
                    map.put(args[1], new PWarp(sender.getPersistentID().toString(), args[1], new WarpPoint((Entity)sender)));
                    OutputHandler.chatConfirmation((ICommandSender)sender, "Personal warp sucessfully added.");
                } else if (map.size() < prop) {
                    map.put(args[1], new PWarp(sender.getPersistentID().toString(), args[1], new WarpPoint((Entity)sender)));
                    OutputHandler.chatConfirmation((ICommandSender)sender, "Personal warp sucessfully added.");
                } else {
                    OutputHandler.chatError((ICommandSender)sender, "You have reached your limit.");
                }
            } else {
                OutputHandler.chatError((ICommandSender)sender, "That personal warp already exists.");
            }
        } else if (args[0].equalsIgnoreCase("remove")) {
            if (args[1] == null) {
                OutputHandler.chatError((ICommandSender)sender, "You must specify a warp name!");
                return;
            }
            if (map.containsKey(args[1])) {
                TeleportDataManager.removePWarp(map.get(args[1]));
                map.remove(args[1]);
                OutputHandler.chatConfirmation((ICommandSender)sender, "Personal warp sucessfully removed.");
            } else {
                OutputHandler.chatError((ICommandSender)sender, "That personal warp doesn't exist!");
            }
        } else if (args[0].equalsIgnoreCase("limit") && PermissionsManager.checkPermission((EntityPlayer)sender, this.PERM_SET_LIMIT)) {
            if (args.length == 1) {
                OutputHandler.chatError((ICommandSender)sender, "Specify a group or player. (-1 means no limit.)");
            } else {
                String target = APIRegistry.perms.groupExists(args[1]) ? "g:" + args[1] : (args[1].equalsIgnoreCase("me") ? "p:" + sender.func_70005_c_() : "p:" + UserIdent.getPlayerByMatchOrUsername((ICommandSender)sender, args[1]).func_70005_c_());
                if (args.length == 2) {
                    OutputHandler.chatConfirmation((ICommandSender)sender, String.format("The current limit is %s.", this.getLimit(target)));
                } else {
                    this.setLimit(target, CommandPersonalWarp.func_71528_a((ICommandSender)sender, (String)args[2], (int)-1));
                    OutputHandler.chatConfirmation((ICommandSender)sender, String.format("Limit changed to %s.", this.getLimit(target)));
                }
            }
        } else if (args[0].equalsIgnoreCase("limit")) {
            OutputHandler.chatConfirmation((ICommandSender)sender, String.format("The current limit is %s.", this.getLimit((EntityPlayer)sender)));
        }
        TeleportDataManager.privateWarps.put(sender.getPersistentID().toString(), map);
        TeleportDataManager.savePWarps(sender.getPersistentID().toString());
    }

    private String getLimit(EntityPlayer sender) {
        return APIRegistry.perms.getPermissionProperty(sender, this.PERM_LIMIT_PROP);
    }

    private String getLimit(String target) {
        if (target.startsWith("p:")) {
            return APIRegistry.perms.getUserPermissionProperty(new UserIdent(target.replaceFirst("p:", "")), this.PERM_LIMIT_PROP);
        }
        if (target.startsWith("g:")) {
            return APIRegistry.perms.getUserPermissionProperty(new UserIdent(target.replaceFirst("g:", "")), this.PERM_LIMIT_PROP);
        }
        return "";
    }

    private void setLimit(String target, int limit) {
        if (target.startsWith("p:")) {
            APIRegistry.perms.setPlayerPermissionProperty(new UserIdent(target.replaceFirst("p:", "")), this.PERM_LIMIT_PROP, Integer.toString(limit));
        } else if (target.startsWith("g:")) {
            APIRegistry.perms.setGroupPermissionProperty(target.replaceFirst("g:", ""), this.PERM_LIMIT_PROP, Integer.toString(limit));
        } else {
            return;
        }
    }

    @Override
    public boolean canConsoleUseCommand() {
        return false;
    }

    @Override
    public String getPermissionNode() {
        return "fe.teleport." + this.func_71517_b();
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CommandPersonalWarp.func_71530_a((String[])args, (String[])new String[]{"goto", "add", "remove", "limit"});
        }
        if (args.length == 2) {
            if (TeleportDataManager.privateWarps.get(sender.func_70005_c_()) == null) {
                TeleportDataManager.privateWarps.put(sender.func_70005_c_(), new HashMap());
            }
            return CommandPersonalWarp.func_71531_a((String[])args, TeleportDataManager.privateWarps.get(sender.func_70005_c_()).keySet());
        }
        return null;
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.TRUE;
    }

    public void registerExtraPermissions() {
        APIRegistry.perms.registerPermission(this.PERM_SET_LIMIT, PermissionsManager.RegisteredPermValue.OP, "Allow setting the warp limit for players");
        APIRegistry.perms.registerPermissionProperty(this.PERM_LIMIT_PROP, "10", "Maximum number of personal warps a player can create");
    }

    public String func_71518_a(ICommandSender sender) {
        return "/pwarp goto [name] OR <add|remove> <name> Teleports you to a personal warp.";
    }
}

