/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.teleport;

import com.forgeessentials.commons.selections.WarpPoint;
import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.core.misc.TeleportHelper;
import com.forgeessentials.teleport.CommandBack;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.PlayerInfo;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandHome
extends ForgeEssentialsCommandBase {
    public String func_71517_b() {
        return "home";
    }

    @Override
    public void processCommandPlayer(EntityPlayerMP sender, String[] args) {
        if (args.length == 0) {
            WarpPoint home = PlayerInfo.getPlayerInfo(sender.getPersistentID()).getHome();
            if (home == null) {
                OutputHandler.chatError((ICommandSender)sender, "No home set. Try this: [here|x, y, z]");
            } else {
                EntityPlayerMP player = sender;
                PlayerInfo playerInfo = PlayerInfo.getPlayerInfo(player.getPersistentID());
                playerInfo.setLastTeleportOrigin(new WarpPoint((Entity)player));
                CommandBack.justDied.remove(player.getPersistentID());
                TeleportHelper.teleport(player, home);
            }
        } else if (PermissionsManager.checkPermission((EntityPlayer)sender, "fe.teleport.home.set") && args.length >= 1 && (args[0].equals("here") || args[0].equals("set"))) {
            WarpPoint p = new WarpPoint((Entity)sender);
            PlayerInfo info = PlayerInfo.getPlayerInfo(sender.getPersistentID());
            info.setHome(p);
            info.save();
            OutputHandler.chatConfirmation((ICommandSender)sender, String.format("Home set to: %1.0f, %1.0f, %1.0f", p.getX(), p.getY(), p.getZ()));
        }
    }

    @Override
    public String getPermissionNode() {
        return "fe.teleport.home.set";
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CommandHome.func_71530_a((String[])args, (String[])new String[]{"here"});
        }
        return null;
    }

    @Override
    public boolean canConsoleUseCommand() {
        return false;
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.TRUE;
    }

    public String func_71518_a(ICommandSender sender) {
        if (sender instanceof EntityPlayer) {
            return "/home [here|x, y, z] Set your home location.";
        }
        return null;
    }
}

