/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.teleport;

import com.forgeessentials.commons.selections.WarpPoint;
import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.core.misc.TeleportHelper;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.PlayerInfo;
import com.forgeessentials.util.UserIdent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandBed
extends ForgeEssentialsCommandBase {
    private WarpPoint sleepPoint;

    public CommandBed() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public String func_71517_b() {
        return "bed";
    }

    @Override
    public void processCommandPlayer(EntityPlayerMP sender, String[] args) {
        if (args.length >= 1 && PermissionsManager.checkPermission((EntityPlayer)sender, "fe.teleport.bed.others")) {
            EntityPlayerMP player = UserIdent.getPlayerByMatchOrUsername((ICommandSender)sender, args[0]);
            if (player != null) {
                this.tp(player);
            } else {
                OutputHandler.chatError((ICommandSender)sender, String.format("Player %s does not exist, or is not online.", args[0]));
            }
        } else {
            this.tp(sender);
        }
    }

    private void tp(EntityPlayerMP player) {
        ChunkCoordinates spawn = player.func_70997_bJ();
        if (spawn != null) {
            if ((spawn = EntityPlayer.func_71056_a((World)player.field_70170_p, (ChunkCoordinates)spawn, (boolean)true)) != null) {
                World world = player.field_70170_p;
                if (!world.field_73011_w.func_76567_e()) {
                    world = DimensionManager.getWorld((int)0);
                }
                PlayerInfo.getPlayerInfo(player.getPersistentID()).setLastTeleportOrigin(new WarpPoint((Entity)player));
                if (this.sleepPoint != null) {
                    TeleportHelper.teleport(player, this.sleepPoint);
                } else {
                    OutputHandler.chatError((ICommandSender)player, "You haven't slept in a bed yet.");
                }
            } else {
                OutputHandler.chatError((ICommandSender)player, "Your bed is obstructed.");
            }
        } else {
            OutputHandler.chatError((ICommandSender)player, "No bed found.");
        }
    }

    @Override
    public void processCommandConsole(ICommandSender sender, String[] args) {
        if (args.length >= 1) {
            EntityPlayerMP player = UserIdent.getPlayerByMatchOrUsername(sender, args[0]);
            if (player != null) {
                this.tp(player);
            } else {
                OutputHandler.chatError(sender, String.format("Player %s does not exist, or is not online.", args[0]));
            }
        }
    }

    @Override
    public boolean canConsoleUseCommand() {
        return true;
    }

    @Override
    public String getPermissionNode() {
        return "fe.teleport.bed";
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CommandBed.func_71530_a((String[])args, (String[])FMLCommonHandler.instance().getMinecraftServerInstance().func_71213_z());
        }
        return null;
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.TRUE;
    }

    @SubscribeEvent
    public void getCoords(PlayerSleepInBedEvent e) {
        if (this.sleepPoint == null) {
            this.sleepPoint = new WarpPoint(e.entityPlayer.field_71093_bK, e.x, e.y, e.z, 0.0f, 0.0f);
        } else {
            this.sleepPoint.setX(e.x);
            this.sleepPoint.setY(e.y);
            this.sleepPoint.setZ(e.z);
        }
        e.setResult(null);
        e.entityPlayer.field_71081_bT = new ChunkCoordinates(e.x, e.y, e.z);
    }

    public String func_71518_a(ICommandSender sender) {
        return "/bed [player] Teleport you or another player to the bed last used.";
    }
}

