/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.teleport;

import com.forgeessentials.commons.selections.WarpPoint;
import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.core.misc.TeleportHelper;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.PlayerInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandBack
extends ForgeEssentialsCommandBase {
    public static List<UUID> justDied = new ArrayList<UUID>();

    public String func_71517_b() {
        return "back";
    }

    @Override
    public void processCommandPlayer(EntityPlayerMP sender, String[] args) {
        if (justDied.contains(sender.getPersistentID())) {
            if (PermissionsManager.checkPermission((EntityPlayer)sender, "fe.teleport.back.ondeath")) {
                PlayerInfo info = PlayerInfo.getPlayerInfo(sender.getPersistentID());
                if (info.getLastTeleportOrigin() != null) {
                    WarpPoint death = info.getLastTeleportOrigin();
                    info.setLastTeleportOrigin(new WarpPoint((Entity)sender));
                    TeleportHelper.teleport(sender, death);
                } else {
                    OutputHandler.chatError((ICommandSender)sender, "You have nowhere to get back to");
                }
                justDied.remove(sender.getPersistentID());
                return;
            }
            OutputHandler.chatError((ICommandSender)sender, "You have nowhere to get back to");
        } else if (PermissionsManager.checkPermission((EntityPlayer)sender, "fe.teleport.back.ontp")) {
            PlayerInfo info = PlayerInfo.getPlayerInfo(sender.getPersistentID());
            if (info.getLastTeleportOrigin() != null) {
                WarpPoint back = info.getLastTeleportOrigin();
                info.setLastTeleportOrigin(new WarpPoint((Entity)sender));
                EntityPlayerMP player = sender;
                TeleportHelper.teleport(player, back);
            } else {
                OutputHandler.chatError((ICommandSender)sender, "You have nowhere to get back to");
            }
            return;
        }
    }

    @Override
    public boolean canConsoleUseCommand() {
        return false;
    }

    @Override
    public String getPermissionNode() {
        return "fe.teleport.back";
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.TRUE;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/back Teleport you to your last death or teleport location.";
    }
}

