/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.signtools;

import com.forgeessentials.core.ForgeEssentials;
import com.forgeessentials.core.moduleLauncher.FEModule;
import com.forgeessentials.core.moduleLauncher.config.IConfigLoader;
import com.forgeessentials.util.FunctionHelper;
import com.forgeessentials.util.events.FEModuleEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fe.event.world.SignEditEvent;
import net.minecraftforge.permissions.PermissionsManager;

@FEModule(name="SignTools", parentMod=ForgeEssentials.class)
public class SignToolsModule
extends IConfigLoader.ConfigLoaderBase {
    public static final String COLOURIZE_PERM = "fe.signs.colourize";
    private static boolean allowSignCommands;

    @SubscribeEvent
    public void onLoad(FEModuleEvent.FEModuleInitEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void registerPerms(FEModuleEvent.FEModuleServerInitEvent e) {
        PermissionsManager.registerPermission(COLOURIZE_PERM, PermissionsManager.RegisteredPermValue.TRUE);
    }

    @SubscribeEvent
    public void onSignEdit(SignEditEvent e) {
        if (!PermissionsManager.checkPermission((EntityPlayer)e.editor, COLOURIZE_PERM)) {
            return;
        }
        for (int i = 0; i < e.text.length; ++i) {
            if (!e.text[i].contains("&")) continue;
            e.text[i] = FunctionHelper.formatColors(e.text[i]);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent e) {
        if (!allowSignCommands || !e.action.equals((Object)PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        TileEntity te = e.entityPlayer.field_70170_p.func_147438_o(e.x, e.y, e.z);
        if (te != null && te instanceof TileEntitySign) {
            String[] signText = ((TileEntitySign)te).field_145915_a;
            if (!signText[0].equals("[command]")) {
                return;
            }
            String send = signText[1] + " " + signText[2] + " " + signText[3];
            MinecraftServer.func_71276_C().func_71187_D().func_71556_a((ICommandSender)e.entityPlayer, send);
            e.setCanceled(true);
        }
    }

    @Override
    public void load(Configuration config, boolean isReload) {
        allowSignCommands = config.getBoolean("allowSignCommands", "Signs", true, "Allow commands to be run when right clicking signs.");
    }
}

