/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.servervote.Votifier;

import com.forgeessentials.servervote.ConfigServerVote;
import com.forgeessentials.servervote.ModuleServerVote;
import com.forgeessentials.servervote.VoteEvent;
import com.forgeessentials.util.OutputHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.Event;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;

public class VoteReceiver
extends Thread {
    private final String host;
    private final int port;
    private ServerSocket server;
    private boolean running = true;

    public VoteReceiver(String host, int port) throws Exception {
        if (0 == host.length()) {
            host = "0.0.0.0";
            try {
                InetAddress var2 = InetAddress.getLocalHost();
                host = var2.getHostAddress();
            }
            catch (UnknownHostException var3) {
                FMLLog.severe((String)("Unable to determine local host IP, please set server-ip/hostname in the snooper config : " + var3.getMessage()), (Object[])new Object[0]);
            }
        }
        this.host = host;
        this.port = port;
        this.initialize();
    }

    private void initialize() throws Exception {
        try {
            this.server = new ServerSocket();
            this.server.bind(new InetSocketAddress(this.host, this.port));
            OutputHandler.felog.info("Votifier connection handler initialized!");
        }
        catch (Exception ex) {
            FMLLog.severe((String)"Error initializing vote receiver. Please verify that the configured", (Object[])new Object[0]);
            FMLLog.severe((String)"IP address and port are not already in use. This is a common problem", (Object[])new Object[0]);
            FMLLog.severe((String)("with hosting services and, if so, you should check with your hosting provider." + ex), (Object[])new Object[0]);
            throw new Exception(ex);
        }
    }

    public void shutdown() {
        this.running = false;
        if (this.server == null) {
            return;
        }
        try {
            this.server.close();
        }
        catch (Exception ex) {
            FMLLog.severe((String)"Unable to shut down vote receiver cleanly.", (Object[])new Object[0]);
        }
        System.gc();
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                Socket socket = this.server.accept();
                socket.setSoTimeout(5000);
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
                InputStream in = socket.getInputStream();
                writer.write("VOTIFIER FECOMPAT");
                writer.newLine();
                writer.flush();
                byte[] block = new byte[256];
                in.read(block, 0, block.length);
                Cipher cipher = Cipher.getInstance("RSA");
                cipher.init(2, ConfigServerVote.privateKey);
                block = cipher.doFinal(block);
                int position = 0;
                String opcode = VoteReceiver.readString(block, position);
                position += opcode.length() + 1;
                if (!opcode.equals("VOTE")) {
                    throw new GeneralSecurityException();
                }
                String serviceName = VoteReceiver.readString(block, position);
                String username = VoteReceiver.readString(block, position += serviceName.length() + 1);
                String address = VoteReceiver.readString(block, position += username.length() + 1);
                String timeStamp = VoteReceiver.readString(block, position += address.length() + 1);
                position += timeStamp.length() + 1;
                VoteEvent vote = new VoteEvent(username, serviceName, address, timeStamp);
                ModuleServerVote.log(vote);
                EntityPlayerMP player = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(vote.player);
                if (player == null) {
                    if (!ConfigServerVote.allowOfflineVotes) {
                        OutputHandler.felog.finer("Player for vote not online, vote canceled.");
                        vote.setFeedback("notOnline");
                        vote.setCanceled(true);
                        return;
                    }
                    MinecraftForge.EVENT_BUS.post((Event)vote);
                }
                writer.close();
                in.close();
                socket.close();
            }
            catch (SocketException ex) {
                FMLLog.severe((String)"Protocol error. Ignoring packet", (Object[])new Object[0]);
            }
            catch (BadPaddingException ex) {
                FMLLog.severe((String)"Unable to decrypt vote record. Make sure that that your public key matches the one you gave the server list.", (Object[])new Object[0]);
            }
            catch (IOException ex) {
                FMLLog.severe((String)"Exception caught while receiving a vote notification", (Object[])new Object[0]);
            }
            catch (GeneralSecurityException e) {
                FMLLog.severe((String)"Unable to decode vote", (Object[])new Object[0]);
            }
        }
        System.gc();
    }

    private static String readString(byte[] data, int offset) {
        StringBuilder builder = new StringBuilder();
        for (int i = offset; i < data.length && data[i] != 10; ++i) {
            builder.append((char)data[i]);
        }
        return builder.toString();
    }
}

