/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.servervote;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import cpw.mods.fml.common.eventhandler.Cancelable;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.List;

@Cancelable
public class VoteEvent
extends Event {
    public String player;
    public String serviceName;
    public String ip;
    public String timeStamp;
    List<String> feedback = new ArrayList<String>();
    private boolean sane = false;

    public VoteEvent(String player, String serviceName, String ip, String timeStamp) {
        this.player = player;
        this.serviceName = serviceName;
        this.ip = ip;
        this.timeStamp = timeStamp;
        this.sane = true;
    }

    public VoteEvent(String decoded) {
        try {
            Gson gson = new Gson();
            JsonElement element = (JsonElement)gson.fromJson(decoded, JsonElement.class);
            JsonObject json = element.getAsJsonObject();
            this.player = json.get("player").getAsString();
            this.serviceName = json.get("serviceName").getAsString();
            this.ip = json.get("ip").getAsString();
            this.timeStamp = json.get("timeStamp").getAsJsonObject().get("date").getAsString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        try {
            JsonObject json = new JsonObject();
            json.add("player", (JsonElement)new JsonPrimitive(this.player));
            json.add("serviceName", (JsonElement)new JsonPrimitive(this.serviceName));
            json.add("ip", (JsonElement)new JsonPrimitive(this.ip));
            JsonObject time = new JsonObject();
            time.add("date", (JsonElement)new JsonPrimitive(this.timeStamp));
            json.add("timeStamp", (JsonElement)time);
            return json.toString();
        }
        catch (JsonParseException e) {
            e.printStackTrace();
            return "";
        }
    }

    public boolean isSane() {
        return this.sane;
    }

    public List<String> getFeedback() {
        return this.feedback;
    }

    public void setFeedback(String text) {
        this.feedback.add(text);
    }
}

