/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.servervote;

import com.forgeessentials.core.ForgeEssentials;
import com.forgeessentials.core.moduleLauncher.FEModule;
import com.forgeessentials.servervote.ConfigServerVote;
import com.forgeessentials.servervote.VoteEvent;
import com.forgeessentials.servervote.Votifier.VoteReceiver;
import com.forgeessentials.util.FunctionHelper;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.events.FEModuleEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.HashMap;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S02PacketChat;
import net.minecraftforge.common.MinecraftForge;

@FEModule(name="ServerVote", parentMod=ForgeEssentials.class)
public class ModuleServerVote {
    @FEModule.ModuleDir
    public static File moduleDir;
    public static VoteReceiver votifier;
    public static PrintWriter log;
    private HashMap<String, VoteEvent> offlineList = new HashMap();

    public ModuleServerVote() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void log(VoteEvent vote) {
        OutputHandler.felog.finer("Got Vote from player " + vote.player + " by service " + vote.serviceName + " time " + vote.timeStamp);
    }

    @SubscribeEvent
    public void init(FEModuleEvent.FEModuleInitEvent e) {
        FMLCommonHandler.instance().bus().register((Object)this);
        ForgeEssentials.getConfigManager().registerLoader("ServerVote", new ConfigServerVote());
    }

    @SubscribeEvent
    public void serverStarting(FEModuleEvent.FEModuleServerInitEvent e) {
        try {
            votifier = new VoteReceiver(ConfigServerVote.hostname, ConfigServerVote.port);
            votifier.start();
        }
        catch (Exception e1) {
            FMLLog.severe((String)"Error initializing Votifier compat.", (Object[])new Object[0]);
            FMLLog.severe((String)((Object)((Object)e)).toString(), (Object[])new Object[0]);
            e1.printStackTrace();
        }
        try {
            File logFile = new File(moduleDir, "vote.log");
            if (!logFile.exists()) {
                logFile.createNewFile();
            }
            log = new PrintWriter(logFile);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        try {
            File file = new File(moduleDir, "offlineVoteList.txt");
            if (file.exists()) {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(file));
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("#") || line.isEmpty()) continue;
                    VoteEvent vote = new VoteEvent(line.trim());
                    this.offlineList.put(vote.player, vote);
                }
                br.close();
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    @SubscribeEvent
    public void serverStopping(FEModuleEvent.FEModuleServerStopEvent e) {
        try {
            votifier.shutdown();
        }
        catch (Exception e1) {
            FMLLog.severe((String)"Error closing Votifier compat thread.", (Object[])new Object[0]);
            FMLLog.severe((String)((Object)((Object)e)).toString(), (Object[])new Object[0]);
            e1.printStackTrace();
        }
        try {
            log.close();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        try {
            File file = new File(moduleDir, "offlineVoteList.txt");
            if (!file.exists()) {
                file.createNewFile();
            }
            PrintWriter pw = new PrintWriter(file);
            for (VoteEvent vote : this.offlineList.values()) {
                pw.println(vote.toString());
            }
            pw.close();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void defVoteResponces(VoteEvent vote) {
        EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_152612_a(vote.player);
        if (player != null) {
            ModuleServerVote.doPlayer(player, vote);
        } else {
            this.offlineList.put(vote.player, vote);
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        if (this.offlineList.containsKey(e.player.func_70005_c_())) {
            ModuleServerVote.doPlayer((EntityPlayerMP)e.player, this.offlineList.remove(e.player.func_70005_c_()));
        }
    }

    private static void doPlayer(EntityPlayerMP player, VoteEvent vote) {
        if (!ConfigServerVote.msgAll.equals("")) {
            player.field_71135_a.func_147359_a((Packet)new S02PacketChat(OutputHandler.createFromText(FunctionHelper.formatColors(ConfigServerVote.msgAll.replaceAll("%service", vote.serviceName).replaceAll("%player", vote.player)))));
        }
        if (!ConfigServerVote.msgVoter.equals("")) {
            OutputHandler.sendMessage((ICommandSender)player, FunctionHelper.formatColors(ConfigServerVote.msgAll.replaceAll("%service", vote.serviceName).replaceAll("%player", vote.player)));
        }
        if (!ConfigServerVote.freeStuff.isEmpty()) {
            for (ItemStack stack : ConfigServerVote.freeStuff) {
                OutputHandler.felog.finer(stack.toString());
                player.field_71071_by.func_70441_a(stack.func_77946_l());
            }
        }
    }
}

