/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.servervote;

import com.forgeessentials.core.moduleLauncher.config.IConfigLoader;
import com.forgeessentials.servervote.ModuleServerVote;
import com.forgeessentials.util.OutputHandler;
import cpw.mods.fml.common.registry.GameData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import javax.xml.bind.DatatypeConverter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;

public class ConfigServerVote
extends IConfigLoader.ConfigLoaderBase {
    private static final String category = "ServerVote";
    public static boolean allowOfflineVotes;
    public static String msgAll;
    public static String msgVoter;
    public static ArrayList<ItemStack> freeStuff;
    public File keyFolder;
    public KeyPair keyPair;
    public static PrivateKey privateKey;
    public PublicKey publicKey;
    public static String hostname;
    public static Integer port;
    public boolean flatfileLog;

    @Override
    public void load(Configuration config, boolean isReload) {
        String subcat = "ServerVote.Votifier";
        config.addCustomCategoryComment(subcat, "This is for votifier compatibility only.");
        hostname = config.get(subcat, "hostname", "").getString();
        port = config.get(subcat, "port", "8192").getInt();
        allowOfflineVotes = config.get(category, "allowOfflineVotes", true, "If false, votes of offline players will be canceled.").getBoolean(true);
        msgAll = config.get(category, "msgAll", "%player has voted for this server on %service.", "You can use color codes (&), %player and %service").getString();
        msgVoter = config.get(category, "msgVoter", "Thanks for voting for our server!", "You can use color codes (&), %player and %service").getString();
        this.flatfileLog = config.get(category, "flatFileLog", true, "Log the votes in \"votes.log\"").getBoolean(true);
        String[] tempArray = config.get(category, "rewards", new String[0], "Format is like this: [amount]x<id>[:meta]").getStringList();
        freeStuff.clear();
        for (String temp : tempArray) {
            String[] temp2;
            int amount = 1;
            int meta = 0;
            if (temp.contains("x")) {
                temp2 = temp.split("x");
                amount = Integer.parseInt(temp2[0]);
                temp = temp2[1];
            }
            if (temp.contains(":")) {
                temp2 = temp.split(":");
                meta = Integer.parseInt(temp2[2]);
                temp = temp2[0] + ":" + temp2[1];
            }
            Item item = (Item)GameData.getItemRegistry().func_82594_a(temp);
            ItemStack stack = new ItemStack(item, amount, meta);
            OutputHandler.felog.finer(stack.toString());
            freeStuff.add(stack);
        }
        this.loadKeys();
    }

    private void loadKeys() {
        this.keyFolder = new File(ModuleServerVote.moduleDir, "RSA");
        File publicFile = new File(this.keyFolder, "public.key");
        File privateFile = new File(this.keyFolder, "private.key");
        if (!(this.keyFolder.exists() && publicFile.exists() && privateFile.exists())) {
            try {
                OutputHandler.felog.info("Generating RSA key pair...");
                this.keyFolder.mkdirs();
                KeyPairGenerator keygen = KeyPairGenerator.getInstance("RSA");
                RSAKeyGenParameterSpec spec = new RSAKeyGenParameterSpec(2048, RSAKeyGenParameterSpec.F4);
                keygen.initialize(spec);
                this.keyPair = keygen.generateKeyPair();
                privateKey = this.keyPair.getPrivate();
                this.publicKey = this.keyPair.getPublic();
                X509EncodedKeySpec publicSpec = new X509EncodedKeySpec(this.publicKey.getEncoded());
                FileOutputStream out = new FileOutputStream(publicFile);
                out.write(DatatypeConverter.printBase64Binary((byte[])publicSpec.getEncoded()).getBytes());
                out.close();
                PKCS8EncodedKeySpec privateSpec = new PKCS8EncodedKeySpec(privateKey.getEncoded());
                out = new FileOutputStream(privateFile);
                out.write(DatatypeConverter.printBase64Binary((byte[])privateSpec.getEncoded()).getBytes());
                out.close();
                OutputHandler.felog.info("RSA key pair made!");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                OutputHandler.felog.info("Loading RSA key pair...");
                FileInputStream in = new FileInputStream(publicFile);
                byte[] encodedPublicKey = new byte[(int)publicFile.length()];
                in.read(encodedPublicKey);
                encodedPublicKey = DatatypeConverter.parseBase64Binary((String)new String(encodedPublicKey));
                in.close();
                in = new FileInputStream(privateFile);
                byte[] encodedPrivateKey = new byte[(int)privateFile.length()];
                in.read(encodedPrivateKey);
                encodedPrivateKey = DatatypeConverter.parseBase64Binary((String)new String(encodedPrivateKey));
                in.close();
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(encodedPublicKey);
                this.publicKey = keyFactory.generatePublic(publicKeySpec);
                PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(encodedPrivateKey);
                privateKey = keyFactory.generatePrivate(privateKeySpec);
                this.keyPair = new KeyPair(this.publicKey, privateKey);
                OutputHandler.felog.info("RSA key pair loaded!");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static {
        msgAll = "";
        msgVoter = "";
        freeStuff = new ArrayList();
    }
}

