/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.scripting.commands;

import com.forgeessentials.scripting.commands.CommandWrapper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.config.Configuration;

public class ShortcutCommands {
    private static final String ARGS_COMMENT = "The argumtens to be send to the command. Use double quotes.\nUsable variables:\n$sender => senders username\n$arg => the next argument provided to the shortcut. If the argument is not provided, the proper syntax will be shown. Don't use these after using $oArg\n$oArg => the next argument, but optional. If there is no argument, doesn't do anything.";
    static ArrayList<CommandWrapper> list = new ArrayList();
    static HashMap<String, CommandWrapper> cmdMap = new HashMap();
    static Configuration config;

    public static void load() {
        CommandHandler ch = (CommandHandler)MinecraftServer.func_71276_C().func_71187_D();
        for (CommandWrapper cmd : list) {
            ch.func_71560_a((ICommand)cmd);
        }
    }

    public static void loadConfig(File folder) {
        File confFile = new File(folder, "CommandShortcuts.cfg");
        config = new Configuration(confFile);
        ShortcutCommands.parseConfig();
    }

    public static void parseConfig() {
        if (config == null) {
            return;
        }
        config.load();
        ArrayList<String> names = new ArrayList<String>();
        String main = "shortcuts";
        String general = main + ".general";
        config.addCustomCategoryComment(general, "Add a name to the 'list' list and use 'fereload' to genarate a new config category.  Separate by new line without commas.");
        names.addAll(Arrays.asList(config.get(general, "list", new String[]{"fly"}, "Add names here and reload to add templates you can edit.").getStringList()));
        ArrayList cats = new ArrayList(config.getCategoryNames());
        cats.remove(main);
        cats.remove(general);
        for (String name : names) {
            String category = main + "." + name;
            cats.remove(category);
            String command = config.get(category, "command", "capabilities", "Basic command you want to forward to. No syntax here.").getString();
            String[] args = config.get(category, "args", new String[]{"\"$sender\"", "\"allowflying\"", "\"$arg\""}, ARGS_COMMENT).getStringList();
            String syntax = config.get(category, "syntax", "\"<true|false>\"", "The syntax for this shortcut. Use double quotes.").getString();
            list.add(new CommandWrapper(command, name, args, syntax));
        }
        for (String cat : cats) {
            config.removeCategory(config.getCategory(cat));
        }
        config.save();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] parseArgs(ICommandSender sender, String[] wrapperArgs, String[] sendArgs) throws CommandException {
        ArrayList<String> output = new ArrayList<String>();
        int i = 0;
        for (String arg : wrapperArgs) {
            if (arg.startsWith("\"") && arg.endsWith("\"")) {
                arg = arg.substring(1, arg.length() - 1);
            }
            if (arg.equalsIgnoreCase("$sender")) {
                arg = sender.func_70005_c_();
            } else if (arg.equalsIgnoreCase("$arg")) {
                if (sendArgs.length <= i) throw new CommandException("commands.generic.syntax", new Object[0]);
                arg = sendArgs[i];
                ++i;
            } else if (arg.equalsIgnoreCase("$oArg") && sendArgs.length > i) {
                arg = sendArgs[i];
                ++i;
            }
            output.add(arg);
        }
        if (sendArgs.length > i) return output.toArray(new String[output.size()]);
        int i2 = i;
        while (i < sendArgs.length) {
            output.add(sendArgs[i2]);
            ++i2;
        }
        return output.toArray(new String[output.size()]);
    }
}

