/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.scripting;

import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.data.v2.DataManager;
import com.forgeessentials.scripting.TimedTask;
import com.forgeessentials.util.OutputHandler;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.command.ICommandSender;
import net.minecraftforge.permissions.PermissionsManager;

public class TimedTaskManager
extends ForgeEssentialsCommandBase {
    private static Map<String, TimedTask> taskList = new HashMap<String, TimedTask>();
    private static final String syntax = "/timedtask [add|remove|list] <interval> <name> <command> Regularily run a command as the console. Not to be abused.";

    public TimedTaskManager() {
        taskList = DataManager.getInstance().loadAll(TimedTask.class);
    }

    public String func_71517_b() {
        return "timedtask";
    }

    public String func_71518_a(ICommandSender sender) {
        return syntax;
    }

    @Override
    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length == 0) {
            OutputHandler.chatNotification(sender, syntax);
        } else if (args[0].equalsIgnoreCase("create")) {
            String command = "";
            for (int i = 3; i < args.length; ++i) {
                command = command + args[i] + " ";
            }
            TimedTask task = new TimedTask(args[2], (Object)command, (Object)args[1]);
            taskList.put(args[1], task);
            DataManager.getInstance().save(task, task.getName());
            OutputHandler.chatConfirmation(sender, "Added timed task " + args[1]);
        } else if (args[0].equalsIgnoreCase("remove")) {
            taskList.remove(args[1]);
            DataManager.getInstance().delete(TimedTask.class, args[1]);
            OutputHandler.chatConfirmation(sender, "Removed timed task " + args[1]);
        } else if (args[0].equalsIgnoreCase("list")) {
            OutputHandler.chatNotification(sender, "Listing all registered timed tasks");
            for (Map.Entry<String, TimedTask> pairs : taskList.entrySet()) {
                OutputHandler.chatNotification(sender, String.format("%s1 - %s2", pairs.getKey(), pairs.getValue().getCommand()));
            }
        }
    }

    @Override
    public boolean canConsoleUseCommand() {
        return true;
    }

    @Override
    public String getPermissionNode() {
        return "fe.script.timedtask";
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.OP;
    }
}

