/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.scripting;

import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.scripting.ModuleScripting;
import com.forgeessentials.scripting.ScriptParser;
import com.forgeessentials.util.FunctionHelper;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraftforge.permissions.PermissionsManager;

public class MacroCommand
extends ForgeEssentialsCommandBase {
    private File macroDir = new File(ModuleScripting.moduleDir, "macros/");
    public static Map<String, String> argMap = new HashMap<String, String>();

    @Override
    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length < 1) {
            MacroCommand.runArgRetriever(sender, this.macroDir);
        }
        File scriptFile = new File(this.macroDir, args[0] + ".txt");
        try {
            ScriptParser.run(scriptFile, sender, FunctionHelper.dropFirstString(args));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CommandException("Error running macro!", new Object[0]);
        }
    }

    @Override
    public boolean canConsoleUseCommand() {
        return true;
    }

    @Override
    public String getPermissionNode() {
        return "fe.script.macro";
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.OP;
    }

    public String func_71517_b() {
        return "macro";
    }

    public String func_71518_a(ICommandSender p_71518_1_) {
        return "/macro <name> [args] Run a macro.";
    }

    public static void runArgRetriever(ICommandSender sender, File baseDir) {
        for (File macroFile : baseDir.listFiles()) {
            try {
                ArrayList<String> scriptargs = new ArrayList<String>();
                FileInputStream stream = new FileInputStream(macroFile);
                InputStreamReader streamReader = new InputStreamReader(stream);
                BufferedReader reader = new BufferedReader(streamReader);
                String read = reader.readLine();
                while (read != null) {
                    if (read.startsWith("#")) {
                        read = reader.readLine();
                        continue;
                    }
                    if (read.startsWith("$")) {
                        String[] argCode = FunctionHelper.dropFirstString(read.split(" "));
                        int order = Integer.parseInt(argCode[0]);
                        scriptargs.add(order, argCode[1]);
                    }
                    reader.close();
                    streamReader.close();
                    stream.close();
                }
                boolean first = true;
                String put = "";
                for (String argCode : scriptargs) {
                    put = put + (first ? "<" + argCode + ">" : " <" + argCode + ">");
                    first = false;
                }
                argMap.put(Files.getNameWithoutExtension((String)macroFile.getName()), put);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

