/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.scripting;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.scripting.ModuleScripting;
import com.forgeessentials.scripting.ScriptParser;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.UserIdent;
import java.io.File;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;

public enum EventType {
    LOGIN("login"),
    RESPAWN("respawn"),
    ZONECHANGE("zonechange");

    protected File group;
    protected File player;

    private EventType(String name) {
        this.group = new File(ModuleScripting.moduleDir, name + "/group");
        this.player = new File(ModuleScripting.moduleDir, name + "/player");
    }

    protected void mkdirs() throws Exception {
        this.group.mkdirs();
        this.player.mkdirs();
    }

    public static void run(EntityPlayer player, EventType event) {
        OutputHandler.felog.info("Running command scripts for player " + player.func_70005_c_());
        try {
            File pscript = new File(event.player, player.func_70005_c_() + ".txt");
            ScriptParser.run(pscript, (ICommandSender)player, new String[0]);
        }
        catch (Exception e) {
            OutputHandler.felog.warning("Could not find command script for player " + player.func_70005_c_() + ", ignoring!");
        }
        try {
            File gscript = new File(event.group, APIRegistry.perms.getPrimaryGroup(new UserIdent(player)) + ".txt");
            ScriptParser.run(gscript, (ICommandSender)player, new String[0]);
        }
        catch (Exception e) {
            OutputHandler.felog.warning("Could not find command script for group " + APIRegistry.perms.getPrimaryGroup(new UserIdent(player)).toString() + ", ignoring!");
        }
    }
}

