/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.remote.handler;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.api.remote.GenericRemoteHandler;
import com.forgeessentials.api.remote.RemoteRequest;
import com.forgeessentials.api.remote.RemoteResponse;
import com.forgeessentials.api.remote.RemoteSession;
import com.forgeessentials.api.remote.data.DataFloatLocation;
import com.forgeessentials.util.UserIdent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.permissions.PermissionsManager;

public class QueryPlayerHandler
extends GenericRemoteHandler<Request> {
    public static final String ID = "query_player";
    public static final String PERM = "fe.remote.query.player";
    public static final String PERM_LOCATION = "fe.remote.query.player.location";
    public static final String PERM_DETAIL = "fe.remote.query.player.detail";

    public QueryPlayerHandler() {
        super(ID, PERM, Request.class);
        APIRegistry.perms.registerPermission(PERM, PermissionsManager.RegisteredPermValue.OP, "Allows querying player data");
    }

    @Override
    protected RemoteResponse handleData(RemoteSession session, RemoteRequest<Request> request) {
        Iterator<String> i$ = ((Request)request.data).flags.iterator();
        while (i$.hasNext()) {
            String flag;
            switch (flag = i$.next()) {
                case "location": {
                    QueryPlayerHandler.checkPermission(session, PERM_LOCATION);
                    break;
                }
                case "detail": {
                    QueryPlayerHandler.checkPermission(session, PERM_DETAIL);
                }
            }
        }
        Response response = new Response();
        if (((Request)request.data).name == null) {
            for (EntityPlayerMP player : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
                response.players.add(this.getPlayerInfoResponse(session, new UserIdent(player), ((Request)request.data).flags));
            }
        } else {
            UserIdent ident = new UserIdent(((Request)request.data).name);
            if (!ident.hasPlayer()) {
                QueryPlayerHandler.error("player not found");
            }
            response.players.add(this.getPlayerInfoResponse(session, ident, ((Request)request.data).flags));
        }
        return new RemoteResponse<Response>(request, response);
    }

    public PlayerInfoResponse getPlayerInfoResponse(RemoteSession session, UserIdent ident, Set<String> flags) {
        PlayerInfoResponse pi = new PlayerInfoResponse(ident.getUuid().toString(), ident.getUsername());
        Iterator<String> i$ = flags.iterator();
        while (i$.hasNext()) {
            String flag;
            switch (flag = i$.next()) {
                case "location": {
                    pi.data.put(flag, new DataFloatLocation((Entity)ident.getPlayer()));
                    break;
                }
                case "detail": {
                    pi.data.put("health", Float.valueOf(ident.getPlayer().func_110143_aJ()));
                    pi.data.put("armor", ident.getPlayer().func_70658_aO());
                    pi.data.put("hunger", ident.getPlayer().func_71024_bL().func_75116_a());
                    pi.data.put("saturation", Float.valueOf(ident.getPlayer().func_71024_bL().func_75115_e()));
                }
            }
        }
        return pi;
    }

    public static class PlayerInfoResponse {
        public String uuid;
        public String name;
        public Map<String, Object> data = new HashMap<String, Object>();

        public PlayerInfoResponse(String uuid, String name) {
            this.uuid = uuid;
            this.name = name;
        }
    }

    public static class Response {
        public List<PlayerInfoResponse> players = new ArrayList<PlayerInfoResponse>();
    }

    public static class Request {
        public String name;
        public Set<String> flags;

        public Request(String name, String ... flags) {
            this.name = name;
            int i = flags.length;
            for (int j = 0; j < i; ++j) {
                this.flags.add(flags[i]);
            }
        }
    }
}

