/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.remote.handler;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.api.remote.GenericRemoteHandler;
import com.forgeessentials.api.remote.RemoteRequest;
import com.forgeessentials.api.remote.RemoteResponse;
import com.forgeessentials.api.remote.RemoteSession;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.permissions.PermissionsManager;

public class PushChatHandler
extends GenericRemoteHandler<RemoteRequest.PushRequestData> {
    public static final String ID = "push_chat";
    public static final String PERM = "fe.remote.push.chat";

    public PushChatHandler() {
        super(ID, PERM, RemoteRequest.PushRequestData.class);
        APIRegistry.perms.registerPermission(PERM, PermissionsManager.RegisteredPermValue.TRUE, "Allows requesting chat push-messages");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public synchronized RemoteResponse handleData(RemoteSession session, RemoteRequest<RemoteRequest.PushRequestData> request) {
        if (this.hasPushSession(session) ^ !((RemoteRequest.PushRequestData)request.data).enable) {
            PushChatHandler.error("chat push already " + (((RemoteRequest.PushRequestData)request.data).enable ? "enabled" : "disabled"));
        }
        if (((RemoteRequest.PushRequestData)request.data).enable) {
            this.addPushSession(session);
        } else {
            this.removePushSession(session);
        }
        return RemoteResponse.ok(request);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public synchronized void chatEvent(ServerChatEvent event) {
        this.push(new RemoteResponse<Response>(this.getID(), new Response(event.username, event.message)));
    }

    public static class Response {
        public String username;
        public String message;

        public Response(String username, String message2) {
            this.username = username;
            this.message = message2;
        }
    }
}

