/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.remote.command;

import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.remote.ModuleRemote;
import com.forgeessentials.remote.Session;
import com.forgeessentials.util.CommandParserArgs;
import com.forgeessentials.util.UserIdent;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandRemote
extends ForgeEssentialsCommandBase {
    private static final String[] parseMainArgs = new String[]{"regen", "kick", "start", "stop", "block"};

    public String func_71517_b() {
        return "remote";
    }

    @Override
    public void func_71515_b(ICommandSender sender, String[] vargs) {
        CommandParserArgs args = new CommandParserArgs(this.func_71517_b(), vargs, sender);
        this.parse(args);
    }

    public void parse(CommandParserArgs args) {
        if (args.isTabCompletion && args.size() == 1) {
            args.tabCompletion = ForgeEssentialsCommandBase.getListOfStringsMatchingLastWord(args.peek(), parseMainArgs);
            return;
        }
        if (args.isEmpty()) {
            if (!args.hasPlayer()) {
                throw new CommandException("This command cannot be used from console", new Object[0]);
            }
        } else {
            String arg;
            switch (arg = args.remove()) {
                case "regen": {
                    UserIdent ident = args.parsePlayer();
                    if (ident == null) {
                        return;
                    }
                    if (!ident.hasUUID()) {
                        throw new CommandException(String.format("Player %s not found", ident.getUsernameOrUUID()), new Object[0]);
                    }
                    if (!ident.equals(args.userIdent)) {
                        args.checkPermission("fe.remote.control");
                    }
                    if (args.isTabCompletion) {
                        return;
                    }
                    ModuleRemote.getInstance().setPasskey(ident, ModuleRemote.getInstance().generatePasskey());
                    args.info("Generated new passkey");
                    this.showPasskey(args, ident);
                    return;
                }
                case "block": {
                    UserIdent ident = args.parsePlayer();
                    if (ident == null) {
                        return;
                    }
                    if (!ident.hasUUID()) {
                        throw new CommandException(String.format("Player %s not found", ident.getUsernameOrUUID()), new Object[0]);
                    }
                    args.checkPermission("fe.remote.control");
                    if (args.isTabCompletion) {
                        return;
                    }
                    ModuleRemote.getInstance().setPasskey(ident, null);
                    args.info(String.format("User %s has been blocked from remote until he generates a new passkey", ident.getUsernameOrUUID()));
                    return;
                }
                case "kick": {
                    UserIdent ident = args.parsePlayer();
                    if (ident == null) {
                        return;
                    }
                    if (!ident.hasUUID()) {
                        throw new CommandException(String.format("Player %s not found", ident.getUsernameOrUUID()), new Object[0]);
                    }
                    args.checkPermission("fe.remote.control");
                    if (args.isTabCompletion) {
                        return;
                    }
                    Session session = ModuleRemote.getInstance().getServer().getSession(ident);
                    if (session == null) {
                        args.info(String.format("User %s is not logged in on remote", ident.getUsernameOrUUID()));
                        return;
                    }
                    session.close("kick", 0);
                    args.info(String.format("User %s has been kicked from remote", ident.getUsernameOrUUID()));
                    return;
                }
                case "start": {
                    args.checkPermission("fe.remote.control");
                    if (args.isTabCompletion) {
                        return;
                    }
                    if (ModuleRemote.getInstance().getServer() != null) {
                        throw new CommandException("Server already running on port " + ModuleRemote.getInstance().getPort(), new Object[0]);
                    }
                    ModuleRemote.getInstance().startServer();
                    if (ModuleRemote.getInstance().getServer() == null) {
                        args.info("Error starting remote server");
                    } else {
                        args.info("Server started");
                    }
                    return;
                }
                case "stop": {
                    args.checkPermission("fe.remote.control");
                    if (args.isTabCompletion) {
                        return;
                    }
                    if (ModuleRemote.getInstance().getServer() == null) {
                        throw new CommandException("Server not running", new Object[0]);
                    }
                    ModuleRemote.getInstance().stopServer();
                    args.info("Server stopped");
                    return;
                }
            }
            throw new CommandException("Unknown subcommand " + arg, new Object[0]);
        }
        this.showPasskey(args, args.userIdent);
    }

    public void showPasskey(CommandParserArgs args, UserIdent ident) {
        String connectString = ModuleRemote.getInstance().getConnectString(ident);
        String url = ("https://chart.googleapis.com/chart?cht=qr&chld=M|4&chs=547x547&chl=" + connectString).replaceAll("\\|", "%7C");
        args.sender.func_145747_a(IChatComponent.Serializer.func_150699_a((String)("{text:\"Remote passkey = " + ModuleRemote.getInstance().getPasskey(ident) + " \"," + "extra:[" + " {" + "  text:\"[QR code]\"," + "  color:red," + "  underlined:true," + "  clickEvent:{" + "   action:open_url," + "   value:\"" + url + "\"" + "  }" + " }" + "]}")));
        args.sender.func_145747_a((IChatComponent)new ChatComponentText("Port = " + ModuleRemote.getInstance().getPort()));
    }

    public List<String> func_71516_a(ICommandSender sender, String[] vargs) {
        try {
            CommandParserArgs args = new CommandParserArgs(this.func_71517_b(), vargs, sender, true);
            this.parse(args);
            return args.tabCompletion;
        }
        catch (CommandException e) {
            return null;
        }
    }

    @Override
    public String getPermissionNode() {
        return "fe.remote";
    }

    @Override
    public boolean canConsoleUseCommand() {
        return true;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/remoteqr: Prints a link remote access QR code";
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.TRUE;
    }
}

