/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.remote;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class SocketStreamSplitter {
    private final InputStream is;
    private final InputStreamReader reader;
    private final String separator;
    private final StringBuilder buffer = new StringBuilder();

    public SocketStreamSplitter(InputStream is, String separator) {
        this.is = is;
        this.reader = new InputStreamReader(is);
        this.separator = separator;
    }

    public String readNext() throws IOException {
        int separatorPos = this.buffer.toString().indexOf(this.separator);
        while (separatorPos < 0) {
            int available = this.is.available();
            int count = available > 0 ? available : 1;
            char[] buf = new char[count];
            int read = this.reader.read(buf, 0, count);
            this.buffer.append(buf);
            separatorPos = this.buffer.toString().indexOf(this.separator);
            if (separatorPos >= 0 || read >= 0) continue;
            return null;
        }
        String data = this.buffer.substring(0, separatorPos);
        this.buffer.delete(0, separatorPos + this.separator.length());
        return data;
    }
}

