/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.remote;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.api.remote.RemoteHandler;
import com.forgeessentials.api.remote.RemoteRequest;
import com.forgeessentials.api.remote.RemoteResponse;
import com.forgeessentials.api.remote.RemoteSession;
import com.forgeessentials.remote.ModuleRemote;
import com.forgeessentials.remote.SocketStreamSplitter;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.UserIdent;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import net.minecraft.server.MinecraftServer;

public class Session
implements Runnable,
RemoteSession {
    private static final String SEPARATOR = "\n\n\n";
    private final Socket socket;
    private final Thread thread;
    private UserIdent ident;

    public Session(Socket socket) {
        this.socket = socket;
        this.thread = new Thread(this);
        this.thread.start();
    }

    @Override
    public void run() {
        try {
            SocketStreamSplitter sss = new SocketStreamSplitter(this.socket.getInputStream(), SEPARATOR);
            try {
                while (true) {
                    String msg;
                    if ((msg = sss.readNext()) == null) {
                        OutputHandler.felog.warning("[remote] Connection closed: " + this.getRemoteHostname());
                        break;
                    }
                    this.processMessage(msg);
                }
            }
            catch (IOException e) {
                OutputHandler.felog.warning("[remote] Socket error: " + e.getMessage());
            }
        }
        catch (IOException e) {
            OutputHandler.felog.warning("[remote] Error opening input stream.");
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMessage(String message2) throws IOException {
        try {
            RemoteRequest.JsonRemoteRequest request = (RemoteRequest.JsonRemoteRequest)this.getGson().fromJson(message2, RemoteRequest.JsonRemoteRequest.class);
            OutputHandler.felog.info(String.format("[remote] Request [%s]: %s", request.id, request.data == null ? "null" : ((JsonElement)request.data).toString()));
            if (request.auth != null) {
                Session session = this;
                synchronized (session) {
                    this.ident = new UserIdent(request.auth.username);
                }
                if (!this.ident.hasUUID()) {
                    this.ident = null;
                    this.sendMessage(RemoteResponse.error(request, "unknown username"));
                    return;
                }
                if (!request.auth.password.equals(ModuleRemote.getInstance().getPasskey(this.ident))) {
                    this.close("authentication failed", request);
                    return;
                }
            }
            if (this.ident != null && MinecraftServer.func_71276_C().func_71203_ab().func_152608_h().func_152702_a(this.ident.getGameProfile())) {
                this.close("banned", request);
                return;
            }
            if (!APIRegistry.perms.checkUserPermission(this.ident, "fe.remote")) {
                this.close(this.ident == null ? "need authentication" : "access denied", request);
                return;
            }
            RemoteHandler handler = ModuleRemote.getInstance().getHandler(request.id);
            if (handler == null) {
                this.sendMessage(RemoteResponse.error(request, "unknown message identifier"));
                return;
            }
            String p = handler.getPermission();
            if (p != null && !APIRegistry.perms.checkUserPermission(this.ident, p)) {
                this.sendMessage(RemoteResponse.error(request, "no permission"));
                return;
            }
            try {
                RemoteResponse response = handler.handle(this, request);
                if (response != null) {
                    response.rid = request.rid;
                    this.sendMessage(response);
                }
            }
            catch (RemoteHandler.PermissionException e) {
                this.sendMessage(RemoteResponse.error(request, "no permission"));
                return;
            }
            catch (Exception e) {
                this.sendMessage(RemoteResponse.error(request, "exception"));
                return;
            }
        }
        catch (IllegalArgumentException e) {
            OutputHandler.felog.warning("[remote] Message error: " + e.getMessage());
        }
        catch (JsonSyntaxException e) {
            OutputHandler.felog.warning("[remote] Message error: " + e.getMessage());
        }
    }

    @Override
    public synchronized void sendMessage(RemoteResponse response) throws IOException {
        OutputStreamWriter ow = new OutputStreamWriter(this.socket.getOutputStream());
        ow.write(this.getGson().toJson((Object)response) + SEPARATOR);
        ow.flush();
    }

    @Override
    public boolean trySendMessage(RemoteResponse response) {
        if (this.isClosed()) {
            return false;
        }
        try {
            this.sendMessage(response);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public <T> RemoteRequest<T> transformRemoteRequest(RemoteRequest.JsonRemoteRequest request, Class<T> clazz) {
        return RemoteRequest.transform(request, this.getGson().fromJson((JsonElement)request.data, clazz));
    }

    @Override
    public String getRemoteHostname() {
        return ((InetSocketAddress)this.socket.getRemoteSocketAddress()).getHostName();
    }

    @Override
    public String getRemoteAddress() {
        return ((InetSocketAddress)this.socket.getRemoteSocketAddress()).getAddress().getHostAddress();
    }

    @Override
    public synchronized UserIdent getUserIdent() {
        return this.ident;
    }

    @Override
    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void close(String reason, int rid) {
        this.trySendMessage(RemoteResponse.error("close", rid, reason));
        this.close();
    }

    public void close(String error, RemoteRequest<?> request) {
        OutputHandler.felog.warning(String.format("[remote] Error: %s. Terminating session to %s", error, this.getRemoteAddress()));
        this.trySendMessage(RemoteResponse.error("close", request.rid, error));
        this.close();
    }

    @Override
    public boolean isClosed() {
        return this.socket.isClosed();
    }

    public Gson getGson() {
        return ModuleRemote.getInstance().getGson();
    }
}

