/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.remote;

import com.forgeessentials.api.remote.RemoteResponse;
import com.forgeessentials.remote.Session;
import com.forgeessentials.util.UserIdent;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.GeneralSecurityException;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLContext;

public class Server
implements Runnable {
    private final ServerSocket serverSocket;
    private Thread serverThread;
    private Set<Session> sessions = new HashSet<Session>();

    public Server(ServerSocket socket) {
        this.serverSocket = socket;
        this.serverThread = new Thread(this);
        this.serverThread.start();
    }

    public Server(int port, String hostname) throws IOException {
        this(new ServerSocket(port, 0, InetAddress.getByName(hostname)));
    }

    public Server(int port, String hostname, SSLContext sslCtx) throws IOException, GeneralSecurityException {
        this(sslCtx.getServerSocketFactory().createServerSocket(port, 0, InetAddress.getByName(hostname)));
    }

    public void close() {
        try {
            RemoteResponse<Object> shutdownMessage = RemoteResponse.ok("shutdown", 0, "Server shutting down");
            for (Session session : this.sessions) {
                session.trySendMessage(shutdownMessage);
                session.close();
            }
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        do {
            try {
                Socket s = this.serverSocket.accept();
                Session session = new Session(s);
                this.sessions.add(session);
            }
            catch (SocketException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        } while (!this.serverSocket.isClosed() && this.serverSocket.isBound());
    }

    public Set<Session> getSessions() {
        return this.sessions;
    }

    public Session getSession(UserIdent ident) {
        for (Session session : this.sessions) {
            if (!session.getUserIdent().equals(ident)) continue;
            return session;
        }
        return null;
    }
}

