/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.remote;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.api.remote.RemoteHandler;
import com.forgeessentials.api.remote.RemoteManager;
import com.forgeessentials.core.ForgeEssentials;
import com.forgeessentials.core.moduleLauncher.FEModule;
import com.forgeessentials.core.moduleLauncher.config.IConfigLoader;
import com.forgeessentials.data.v2.DataManager;
import com.forgeessentials.remote.SSLContextHelper;
import com.forgeessentials.remote.Server;
import com.forgeessentials.remote.command.CommandRemote;
import com.forgeessentials.remote.handler.PushChatHandler;
import com.forgeessentials.remote.handler.QueryPlayerHandler;
import com.forgeessentials.remote.handler.QueryRemoteCapabilitiesHandler;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.UserIdent;
import com.forgeessentials.util.events.FEModuleEvent;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.permissions.PermissionsManager;

@FEModule(name="Remote", parentMod=ForgeEssentials.class, canDisable=true)
public class ModuleRemote
extends IConfigLoader.ConfigLoaderBase
implements RemoteManager {
    private static final String CONFIG_CAT = "Remote";
    private static String certificateFilename;
    private static String certificatePassword;
    public static final char[] PASSKEY_CHARS;
    public static final String PERM = "fe.remote";
    public static final String PERM_CONTROL = "fe.remote.control";
    public static int passkeyLength;
    @FEModule.Instance
    protected static ModuleRemote instance;
    protected int port;
    protected String hostname;
    protected boolean useSSL;
    protected Server server;
    protected Map<String, RemoteHandler> handlers = new HashMap<String, RemoteHandler>();
    protected PasskeyMap passkeys = new PasskeyMap();
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    @SubscribeEvent
    public void load(FEModuleEvent.FEModuleInitEvent e) {
        APIRegistry.remoteManager = this;
        APIRegistry.perms.registerPermission(PERM, PermissionsManager.RegisteredPermValue.OP, "Allows login to remote module");
        APIRegistry.perms.registerPermission(PERM_CONTROL, PermissionsManager.RegisteredPermValue.OP, "Allows to start / stop remote server and control users (regen passkeys, kick, block)");
        new QueryPlayerHandler().register();
        new PushChatHandler().register();
        new QueryRemoteCapabilitiesHandler().register();
    }

    @SubscribeEvent
    public void serverStarting(FEModuleEvent.FEModuleServerInitEvent e) {
        this.loadPasskeys();
        this.startServer();
        new CommandRemote().register();
    }

    @SubscribeEvent
    public void serverStopping(FEModuleEvent.FEModuleServerStopEvent e) {
        this.stopServer();
    }

    @Override
    public void load(Configuration config, boolean isReload) {
        this.hostname = config.get(CONFIG_CAT, "hostname", "localhost", "Hostname of the minecraft server").getString();
        this.port = config.get(CONFIG_CAT, "port", 27020, "Port to connect remotes to").getInt();
        this.useSSL = config.get(CONFIG_CAT, "use_ssl", false, "Protect the communication against network sniffing by encrypting traffic with SSL (You don't really need it - believe me)").getBoolean();
        passkeyLength = config.get(CONFIG_CAT, "passkey_length", 6, "Length of the randomly generated passkeys").getInt();
    }

    public Server getServer() {
        return this.server;
    }

    public void startServer() {
        block8: {
            if (this.server != null) {
                return;
            }
            try {
                if (this.hostname.equals("*")) {
                    this.hostname = "0.0.0.0";
                }
                if (this.useSSL) {
                    try {
                        InputStream is = ClassLoader.getSystemResourceAsStream(certificateFilename);
                        if (is != null) {
                            SSLContextHelper sslCtxHelper = new SSLContextHelper();
                            sslCtxHelper.loadSSLCertificate(is, certificatePassword, certificatePassword);
                            this.server = new Server(this.port, this.hostname, sslCtxHelper.getSSLCtx());
                            break block8;
                        }
                        OutputHandler.felog.severe("[remote] Unable to load SSL certificate: File not found");
                    }
                    catch (IOException | GeneralSecurityException e1) {
                        OutputHandler.felog.severe("[remote] Unable to load SSL certificate: " + e1.getMessage());
                    }
                    break block8;
                }
                this.server = new Server(this.port, this.hostname);
            }
            catch (IOException e1) {
                OutputHandler.felog.severe("[remote] Unable to start remote-server: " + e1.getMessage());
            }
        }
    }

    public void stopServer() {
        if (this.server != null) {
            this.server.close();
            this.server = null;
        }
    }

    @Override
    public void registerHandler(RemoteHandler handler) {
        String id = handler.getID();
        if (this.handlers.containsKey(id)) {
            throw new IllegalArgumentException(String.format("Handler with ID \"%s\" already registerd", id));
        }
        this.handlers.put(id, handler);
        String perm = handler.getPermission();
        if (perm != null && APIRegistry.perms.getServerZone().getRootZone().getGroupPermission("_ALL_", perm) == null) {
            APIRegistry.perms.registerPermission(perm, PermissionsManager.RegisteredPermValue.OP);
        }
    }

    @Override
    public RemoteHandler getHandler(String id) {
        return this.handlers.get(id);
    }

    public Map<String, RemoteHandler> getHandlers() {
        return this.handlers;
    }

    public int getPort() {
        return this.port;
    }

    public String generatePasskey() {
        StringBuilder passkey = new StringBuilder();
        Random rnd = new Random();
        for (int i = 0; i < passkeyLength; ++i) {
            passkey.append(PASSKEY_CHARS[rnd.nextInt(PASSKEY_CHARS.length)]);
        }
        return passkey.toString();
    }

    public String getPasskey(UserIdent userIdent) {
        if (!userIdent.hasUUID()) {
            return null;
        }
        if (this.passkeys.containsKey(userIdent)) {
            return (String)this.passkeys.get(userIdent);
        }
        String passkey = this.generatePasskey();
        this.setPasskey(userIdent, passkey);
        return passkey;
    }

    public void setPasskey(UserIdent userIdent, String passkey) {
        if (!userIdent.hasUUID()) {
            return;
        }
        if (passkey == null) {
            this.passkeys.remove(userIdent);
        } else {
            this.passkeys.put(userIdent, passkey);
        }
        DataManager.getInstance().save(this.passkeys, "passkeys");
    }

    public void loadPasskeys() {
        this.passkeys = DataManager.getInstance().load(PasskeyMap.class, "passkeys");
        if (this.passkeys == null) {
            this.passkeys = new PasskeyMap();
        }
    }

    @Override
    public Gson getGson() {
        return this.gson;
    }

    public String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    public String getConnectString(UserIdent userIdent) {
        if (!userIdent.hasUUID()) {
            return null;
        }
        return userIdent.getUuid().toString() + "@" + (this.useSSL ? "ssl:" : "") + this.getHostName() + ":" + this.port + "|" + this.getPasskey(userIdent);
    }

    public static ModuleRemote getInstance() {
        return instance;
    }

    static {
        char c;
        certificateFilename = "FeRemote.jks";
        certificatePassword = "feremote";
        passkeyLength = 6;
        ArrayList<Character> chars = new ArrayList<Character>();
        for (c = 'a'; c <= 'z'; c = (char)(c + 1)) {
            chars.add(Character.valueOf(c));
        }
        for (c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            chars.add(Character.valueOf(c));
        }
        for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
            chars.add(Character.valueOf(c));
        }
        PASSKEY_CHARS = new char[chars.size()];
        for (int i = 0; i < chars.size(); ++i) {
            ModuleRemote.PASSKEY_CHARS[i] = ((Character)chars.get(i)).charValue();
        }
    }

    public static class PasskeyMap
    extends HashMap<UserIdent, String> {
    }
}

