/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.protection.effect;

import net.minecraft.entity.player.EntityPlayerMP;

public abstract class ZoneEffect {
    protected EntityPlayerMP player;
    protected int interval;
    protected long lastEffect;
    protected boolean lethal;

    public ZoneEffect(EntityPlayerMP player, int interval, boolean lethal) {
        this.player = player;
        this.interval = interval;
        this.lethal = lethal;
    }

    public void update() {
        if (this.interval >= 0 && System.currentTimeMillis() - this.lastEffect >= (long)this.interval) {
            this.lastEffect = System.currentTimeMillis();
            if (this.interval == 0) {
                this.interval = -1;
            }
            this.execute();
        }
    }

    public abstract void execute();

    public EntityPlayerMP getPlayer() {
        return this.player;
    }

    public int getInterval() {
        return this.interval;
    }

    public long getLastEffect() {
        return this.lastEffect;
    }

    public boolean isLethal() {
        return this.lethal;
    }
}

