/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.protection;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.api.permissions.AreaZone;
import com.forgeessentials.commons.selections.Point;
import com.forgeessentials.commons.selections.WarpPoint;
import com.forgeessentials.commons.selections.WorldArea;
import com.forgeessentials.commons.selections.WorldPoint;
import com.forgeessentials.protection.ModuleProtection;
import com.forgeessentials.protection.effect.CommandEffect;
import com.forgeessentials.protection.effect.DamageEffect;
import com.forgeessentials.protection.effect.PotionEffect;
import com.forgeessentials.protection.effect.ZoneEffect;
import com.forgeessentials.util.FunctionHelper;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.PlayerInfo;
import com.forgeessentials.util.TimeoutHandler;
import com.forgeessentials.util.UserIdent;
import com.forgeessentials.util.events.PlayerChangedZone;
import com.forgeessentials.util.events.ServerEventHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerOpenContainerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;

public class ProtectionEventHandler
extends ServerEventHandler {
    private HashMap<UUID, List<ZoneEffect>> zoneEffects = new HashMap();
    private HashMap<UUID, ZoneDeniedMessageHandler> zoneDeniedMh = new HashMap();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void attackEntityEvent(AttackEntityEvent e) {
        Entity target;
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        if (e.target == null) {
            return;
        }
        EntityPlayer source = e.entityPlayer;
        UserIdent sourceIdent = new UserIdent(source);
        if (!(!(e.target instanceof EntityPlayer) || APIRegistry.perms.checkUserPermission(new UserIdent((EntityPlayer)(target = (EntityPlayer)e.target)), "fe.protection.pvp") && APIRegistry.perms.checkUserPermission(sourceIdent, "fe.protection.pvp") && APIRegistry.perms.checkUserPermission(sourceIdent, new WorldPoint(target), "fe.protection.pvp"))) {
            e.setCanceled(true);
        }
        target = e.target;
        WorldPoint targetPos = new WorldPoint(e.target);
        String permission = "fe.protection.damageto." + target.getClass().getSimpleName();
        if (ModuleProtection.isDebugMode(source)) {
            OutputHandler.chatNotification((ICommandSender)source, permission);
        }
        if (!APIRegistry.perms.checkUserPermission(sourceIdent, targetPos, permission)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void livingHurtEvent(LivingHurtEvent e) {
        String permission;
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        if (e.entityLiving == null) {
            return;
        }
        if (e.entityLiving instanceof EntityPlayer) {
            EntityPlayer target = (EntityPlayer)e.entityLiving;
            String permission2 = "fe.protection.damageby." + e.source.field_76373_n;
            if (ModuleProtection.isDebugMode(target)) {
                OutputHandler.chatNotification((ICommandSender)target, permission2);
            }
            if (!APIRegistry.perms.checkUserPermission(new UserIdent(target), permission2)) {
                e.setCanceled(true);
                return;
            }
            if (e.source.func_76346_g() != null) {
                Entity source = e.source.func_76346_g();
                permission = "fe.protection.damageby." + source.getClass().getSimpleName();
                if (ModuleProtection.isDebugMode(target)) {
                    OutputHandler.chatNotification((ICommandSender)target, permission);
                }
                if (!APIRegistry.perms.checkUserPermission(new UserIdent(target), permission)) {
                    e.setCanceled(true);
                    return;
                }
            }
        }
        if (e.source.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer source = (EntityPlayer)e.source.func_76346_g();
            WorldPoint point = new WorldPoint((Entity)e.entityLiving);
            permission = "fe.protection.damageto." + e.entityLiving.getClass().getSimpleName();
            if (ModuleProtection.isDebugMode(source)) {
                OutputHandler.chatNotification((ICommandSender)source, permission);
            }
            if (!APIRegistry.perms.checkUserPermission(new UserIdent(source), point, permission)) {
                e.setCanceled(true);
                return;
            }
            if (!(!(e.entityLiving instanceof EntityPlayer) || APIRegistry.perms.checkUserPermission(new UserIdent((EntityPlayer)e.entityLiving), "fe.protection.pvp") && APIRegistry.perms.checkUserPermission(new UserIdent(source), "fe.protection.pvp") && APIRegistry.perms.checkUserPermission(new UserIdent(source), point, "fe.protection.pvp"))) {
                e.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void breakEvent(BlockEvent.BreakEvent e) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        Block block = e.world.func_147439_a(e.x, e.y, e.z);
        String permission = "fe.protection.break." + block.func_149739_a() + "." + block.func_149643_k(e.world, e.x, e.y, e.z);
        if (ModuleProtection.isDebugMode(e.getPlayer())) {
            OutputHandler.chatNotification((ICommandSender)e.getPlayer(), permission);
        }
        WorldPoint point = new WorldPoint(e.getPlayer().field_71093_bK, e.x, e.y, e.z);
        if (!APIRegistry.perms.checkUserPermission(new UserIdent(e.getPlayer()), point, permission)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void explosionEvent(ExplosionEvent.Start e) {
        int cz;
        int cy;
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        int cx = (int)Math.floor(e.explosion.field_77284_b);
        WorldArea area = new WorldArea(e.world, new Point((float)cx - e.explosion.field_77280_f, (float)(cy = (int)Math.floor(e.explosion.field_77285_c)) - e.explosion.field_77280_f, (float)(cz = (int)Math.floor(e.explosion.field_77282_d)) - e.explosion.field_77280_f), new Point((float)cx + e.explosion.field_77280_f, (float)cy + e.explosion.field_77280_f, (float)cz + e.explosion.field_77280_f));
        if (!APIRegistry.perms.checkUserPermission(null, area, "fe.protection.explosion")) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void placeEvent(BlockEvent.PlaceEvent e) {
        WorldPoint point;
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        UserIdent ident = new UserIdent(e.player);
        Block block = e.world.func_147439_a(e.x, e.y, e.z);
        String permission = "fe.protection.place." + block.func_149739_a() + "." + block.func_149643_k(e.world, e.x, e.y, e.z);
        if (ModuleProtection.isDebugMode(e.player)) {
            OutputHandler.chatNotification((ICommandSender)e.player, permission);
        }
        if (!APIRegistry.perms.checkUserPermission(ident, point = new WorldPoint(e.player.field_71093_bK, e.x, e.y, e.z), permission)) {
            e.setCanceled(true);
        }
        if (ProtectionEventHandler.stringToGameType(APIRegistry.perms.getUserPermissionProperty(ident, "fe.protection.gamemode")) == WorldSettings.GameType.CREATIVE && ProtectionEventHandler.stringToGameType(APIRegistry.perms.getUserPermissionProperty(ident, point, "fe.protection.gamemode")) != WorldSettings.GameType.CREATIVE) {
            OutputHandler.chatError((ICommandSender)e.player, "Cannot place block outside creative area");
            e.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void multiPlaceEvent(BlockEvent.MultiPlaceEvent e) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        for (BlockSnapshot b : e.getReplacedBlockSnapshots()) {
            WorldPoint point;
            Block block = e.world.func_147439_a(b.x, b.y, b.z);
            String permission = "fe.protection.place." + block.func_149739_a() + "." + block.func_149643_k(e.world, e.x, e.y, e.z);
            if (ModuleProtection.isDebugMode(e.player)) {
                OutputHandler.chatNotification((ICommandSender)e.player, permission);
            }
            if (APIRegistry.perms.checkUserPermission(new UserIdent(e.player), point = new WorldPoint(e.player.field_71093_bK, b.x, b.y, b.z), permission)) continue;
            e.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void playerInteractEvent(PlayerInteractEvent e) {
        ItemStack stack;
        boolean allow;
        String permission;
        MovingObjectPosition mop;
        e.useItem = Event.Result.ALLOW;
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        UserIdent ident = new UserIdent(e.entityPlayer);
        WorldPoint point = e.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR ? ((mop = FunctionHelper.getPlayerLookingSpot(e.entityPlayer)) == null ? new WorldPoint(e.entityPlayer.field_71093_bK, e.x, e.y, e.z) : new WorldPoint(e.entityPlayer.field_71093_bK, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d)) : new WorldPoint(e.entityPlayer.field_71093_bK, e.x, e.y, e.z);
        if (e.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK || e.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK) {
            Block block = e.world.func_147439_a(e.x, e.y, e.z);
            permission = "fe.protection.interact." + block.func_149739_a() + "." + block.func_149643_k(e.world, e.x, e.y, e.z);
            if (ModuleProtection.isDebugMode(e.entityPlayer)) {
                OutputHandler.chatNotification((ICommandSender)e.entityPlayer, permission);
            }
            Event.Result result = e.useBlock = (allow = APIRegistry.perms.checkUserPermission(ident, point, permission)) ? Event.Result.ALLOW : Event.Result.DENY;
        }
        if ((stack = e.entityPlayer.func_71045_bC()) != null && !(stack.func_77973_b() instanceof ItemBlock)) {
            permission = "fe.protection.use." + stack.func_77977_a() + "." + stack.func_77960_j();
            if (ModuleProtection.isDebugMode(e.entityPlayer)) {
                OutputHandler.chatNotification((ICommandSender)e.entityPlayer, permission);
            }
            Event.Result result = e.useItem = (allow = APIRegistry.perms.checkUserPermission(ident, point, permission)) ? Event.Result.ALLOW : Event.Result.DENY;
        }
        if (ProtectionEventHandler.anyCreativeModeAtPoint(e.entityPlayer, point) && ProtectionEventHandler.stringToGameType(APIRegistry.perms.getUserPermissionProperty(ident, "fe.protection.gamemode")) != WorldSettings.GameType.CREATIVE) {
            e.useBlock = Event.Result.DENY;
            if (e.action != PlayerInteractEvent.Action.LEFT_CLICK_BLOCK) {
                OutputHandler.chatError((ICommandSender)e.entityPlayer, "Cannot interact with creative area if not in creative mode.");
            }
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void entityInteractEvent(EntityInteractEvent e) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        UserIdent ident = new UserIdent(e.entityPlayer);
        WorldPoint point = new WorldPoint(e.entityPlayer.field_71093_bK, (int)e.target.field_70165_t, (int)e.target.field_70163_u, (int)e.target.field_70161_v);
        String permission = "fe.protection.interact.entity." + e.target.getClass().getSimpleName();
        if (ModuleProtection.isDebugMode(e.entityPlayer)) {
            OutputHandler.chatNotification((ICommandSender)e.entityPlayer, permission);
        }
        if (!APIRegistry.perms.checkUserPermission(ident, point, "fe.protection.interact.entity")) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void checkSpawnEvent(LivingSpawnEvent.CheckSpawn e) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        if (e.entityLiving instanceof EntityPlayer) {
            return;
        }
        WorldPoint point = new WorldPoint((Entity)e.entityLiving);
        String mobID = EntityList.func_75621_b((Entity)e.entity);
        if (!APIRegistry.perms.checkUserPermission(null, point, "fe.protection.mobspawn.natural." + mobID)) {
            e.setResult(Event.Result.DENY);
            OutputHandler.debug(mobID + " : DENIED");
        } else {
            OutputHandler.debug(mobID + " : ALLOWED");
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void specialSpawnEvent(LivingSpawnEvent.SpecialSpawn e) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        if (e.entityLiving instanceof EntityPlayer) {
            return;
        }
        WorldPoint point = new WorldPoint((Entity)e.entityLiving);
        String mobID = EntityList.func_75621_b((Entity)e.entity);
        if (!APIRegistry.perms.checkUserPermission(null, point, "fe.protection.mobspawn.forced." + mobID)) {
            e.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void itemPickupEvent(EntityItemPickupEvent e) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        ProtectionEventHandler.handleBannedInventoryItemEvent((PlayerEvent)e, e.item.func_92059_d());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void dropItemEvent(PlayerEvent.StartTracking e) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        if (e.target instanceof EntityItem && (ProtectionEventHandler.getGamemode(e.entityPlayer) == WorldSettings.GameType.CREATIVE || ProtectionEventHandler.anyCreativeModeAtPoint(e.entityPlayer, new WorldPoint(e.target)))) {
            e.target.field_70170_p.func_72900_e(e.target);
            return;
        }
    }

    @SubscribeEvent
    public void playerOpenContainerEvent(PlayerOpenContainerEvent e) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        if (e.entityPlayer.field_71070_bA == e.entityPlayer.field_71069_bz) {
            return;
        }
        ProtectionEventHandler.checkPlayerInventory(e.entityPlayer);
    }

    @SubscribeEvent
    public void playerLoginEvent(PlayerEvent.PlayerLoggedInEvent e) {
        ProtectionEventHandler.checkPlayerInventory(e.player);
    }

    @SubscribeEvent
    public void playerChangedZoneEvent(PlayerChangedZone e) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)e.entityPlayer;
        UserIdent ident = new UserIdent(player);
        String inventoryGroup = APIRegistry.perms.getUserPermissionProperty(ident, e.afterPoint.toWorldPoint(), "fe.protection.inventorygroup");
        WorldSettings.GameType lastGm = ProtectionEventHandler.stringToGameType(APIRegistry.perms.getUserPermissionProperty(ident, e.beforePoint.toWorldPoint(), "fe.protection.gamemode"));
        WorldSettings.GameType gm = ProtectionEventHandler.stringToGameType(APIRegistry.perms.getUserPermissionProperty(ident, e.afterPoint.toWorldPoint(), "fe.protection.gamemode"));
        if (gm != WorldSettings.GameType.NOT_SET || lastGm != WorldSettings.GameType.NOT_SET) {
            WorldSettings.GameType playerGm;
            if (lastGm != WorldSettings.GameType.NOT_SET && gm == WorldSettings.GameType.NOT_SET) {
                gm = WorldSettings.GameType.SURVIVAL;
            }
            if ((playerGm = player.field_71134_c.func_73081_b()) != gm) {
                if (gm != WorldSettings.GameType.CREATIVE) {
                    // empty if block
                }
                player.func_71033_a(gm);
            }
            if (gm == WorldSettings.GameType.CREATIVE) {
                inventoryGroup = "creative";
            }
        }
        PlayerInfo pi = PlayerInfo.getPlayerInfo((EntityPlayer)player);
        pi.setInventoryGroup(inventoryGroup);
        ProtectionEventHandler.checkPlayerInventory((EntityPlayer)player);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void playerChangedZoneEventHigh(PlayerChangedZone event) {
        String potion2;
        int damage2;
        UserIdent ident = new UserIdent(event.entityPlayer);
        List<ZoneEffect> effects = this.getZoneEffects(ident);
        effects.clear();
        if (!APIRegistry.perms.getUserPermissionProperty(ident, event.afterZone, "fe.protection.zone.knockback").equals("false")) {
            this.getZoneDeniedMessageHandler(event.entityPlayer).run();
            Vec3 center = event.afterPoint.toVec3();
            if (event.afterZone instanceof AreaZone) {
                center = ((AreaZone)event.afterZone).getArea().getCenter().toVec3();
                center.field_72448_b = event.beforePoint.getY();
            }
            Vec3 delta = event.beforePoint.toVec3().func_72444_a(center).func_72432_b();
            WarpPoint target = new WarpPoint(event.beforePoint.getDimension(), event.beforePoint.getX() - delta.field_72450_a, event.beforePoint.getY() - delta.field_72448_b, event.beforePoint.getZ() - delta.field_72449_c, event.afterPoint.getPitch(), event.afterPoint.getYaw());
            FunctionHelper.teleportPlayer((EntityPlayerMP)event.entityPlayer, target);
            event.setCanceled(true);
            return;
        }
        String command = APIRegistry.perms.getUserPermissionProperty(ident, event.afterZone, "fe.protection.zone.command");
        if (command != null && !command.isEmpty()) {
            int interval = FunctionHelper.parseIntDefault(APIRegistry.perms.getUserPermissionProperty(ident, event.afterZone, "fe.protection.zone.command.interval"), 0);
            effects.add(new CommandEffect(ident.getPlayer(), interval, command));
        }
        if ((damage2 = FunctionHelper.parseIntDefault(APIRegistry.perms.getUserPermissionProperty(ident, event.afterZone, "fe.protection.zone.damage"), 0)) > 0) {
            int interval = FunctionHelper.parseIntDefault(APIRegistry.perms.getUserPermissionProperty(ident, event.afterZone, "fe.protection.zone.damage.interval"), 0);
            effects.add(new DamageEffect(ident.getPlayer(), interval, damage2));
        }
        if ((potion2 = APIRegistry.perms.getUserPermissionProperty(ident, event.afterZone, "fe.protection.zone.potion")) != null && !potion2.isEmpty()) {
            int interval = FunctionHelper.parseIntDefault(APIRegistry.perms.getUserPermissionProperty(ident, event.afterZone, "fe.protection.zone.potion.interval"), 0);
            effects.add(new PotionEffect(ident.getPlayer(), interval, potion2));
        }
        if (effects.isEmpty()) {
            this.zoneEffects.remove(ident.getUuid());
        } else {
            this.zoneEffects.put(ident.getUuid(), effects);
        }
    }

    @SubscribeEvent
    public void serverTickEvent(TickEvent.ServerTickEvent e) {
        if (e.side != Side.SERVER || e.phase == TickEvent.Phase.END) {
            return;
        }
        for (List<ZoneEffect> effects : this.zoneEffects.values()) {
            for (ZoneEffect effect : effects) {
                effect.update();
                if (!effect.isLethal()) continue;
                this.getZoneDeniedMessageHandler((EntityPlayer)effect.getPlayer()).run();
            }
        }
    }

    @SubscribeEvent
    public void playerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent e) {
        this.zoneEffects.remove(e.player.getPersistentID());
        this.zoneDeniedMh.remove(e.player.getPersistentID());
    }

    public static WorldSettings.GameType stringToGameType(String gm) {
        if (gm == null) {
            return WorldSettings.GameType.NOT_SET;
        }
        switch (gm.toLowerCase()) {
            case "0": 
            case "s": 
            case "survival": {
                return WorldSettings.GameType.SURVIVAL;
            }
            case "1": 
            case "c": 
            case "creative": {
                return WorldSettings.GameType.CREATIVE;
            }
            case "2": 
            case "a": 
            case "adventure": {
                return WorldSettings.GameType.ADVENTURE;
            }
        }
        return WorldSettings.GameType.NOT_SET;
    }

    public static WorldSettings.GameType getGamemode(EntityPlayer player) {
        return ProtectionEventHandler.stringToGameType(APIRegistry.perms.getUserPermissionProperty(new UserIdent(player), "fe.protection.gamemode"));
    }

    public static boolean anyCreativeModeAtPoint(EntityPlayer player, WorldPoint point) {
        if (ProtectionEventHandler.stringToGameType(APIRegistry.perms.getUserPermissionProperty(new UserIdent(player), point, "fe.protection.gamemode")) == WorldSettings.GameType.CREATIVE) {
            return true;
        }
        for (String group : APIRegistry.perms.getServerZone().getGroups()) {
            if (ProtectionEventHandler.stringToGameType(APIRegistry.perms.getGroupPermissionProperty(group, point, "fe.protection.gamemode")) != WorldSettings.GameType.CREATIVE) continue;
            return true;
        }
        return false;
    }

    public static boolean isInventoryItemBanned(EntityPlayer player, ItemStack stack) {
        String permission = "fe.protection.inventory." + stack.func_77977_a() + "." + stack.func_77960_j();
        return !APIRegistry.perms.checkUserPermission(new UserIdent(player), permission);
    }

    public static void handleBannedInventoryItemEvent(PlayerEvent e, ItemStack stack) {
        if (ProtectionEventHandler.isInventoryItemBanned(e.entityPlayer, stack)) {
            e.setCanceled(true);
        }
    }

    public static void checkPlayerInventory(EntityPlayer player) {
        for (int slotIdx = 0; slotIdx < player.field_71071_by.func_70302_i_(); ++slotIdx) {
            ItemStack stack = player.field_71071_by.func_70301_a(slotIdx);
            if (stack == null || !ProtectionEventHandler.isInventoryItemBanned(player, stack)) continue;
            EntityItem droppedItem = player.func_146097_a(stack, true, false);
            droppedItem.field_70159_w = 0.0;
            droppedItem.field_70181_x = 0.0;
            droppedItem.field_70179_y = 0.0;
            player.field_71071_by.func_70299_a(slotIdx, null);
        }
    }

    private ZoneDeniedMessageHandler getZoneDeniedMessageHandler(EntityPlayer entityPlayer) {
        ZoneDeniedMessageHandler mh = this.zoneDeniedMh.get(entityPlayer.getPersistentID());
        if (mh == null) {
            mh = new ZoneDeniedMessageHandler(entityPlayer);
            this.zoneDeniedMh.put(entityPlayer.getPersistentID(), mh);
        }
        return mh;
    }

    private List<ZoneEffect> getZoneEffects(UserIdent ident) {
        List<ZoneEffect> effects = this.zoneEffects.get(ident.getUuid());
        if (effects == null) {
            effects = new ArrayList<ZoneEffect>();
        }
        return effects;
    }

    static class ZoneDeniedMessageHandler
    extends TimeoutHandler {
        private final EntityPlayer player;

        public ZoneDeniedMessageHandler(EntityPlayer entityPlayer) {
            super(4000);
            this.player = entityPlayer;
        }

        @Override
        protected void doRun() {
            OutputHandler.chatError((ICommandSender)this.player, "You are not allowed to enter this area!");
        }
    }
}

