/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.protection;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.core.ForgeEssentials;
import com.forgeessentials.core.moduleLauncher.FEModule;
import com.forgeessentials.protection.ProtectCommand;
import com.forgeessentials.protection.ProtectionEventHandler;
import com.forgeessentials.protection.commands.CommandItemPermission;
import com.forgeessentials.protection.commands.CommandProtectionDebug;
import com.forgeessentials.util.FunctionHelper;
import com.forgeessentials.util.events.FEModuleEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameData;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGiantZombie;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.permissions.PermissionsManager;

@FEModule(name="Protection", parentMod=ForgeEssentials.class, isCore=true, canDisable=false)
public class ModuleProtection {
    public static final String BASE_PERM = "fe.protection";
    public static final String PERM_PVP = "fe.protection.pvp";
    public static final String PERM_GAMEMODE = "fe.protection.gamemode";
    public static final String PERM_INVENTORY_GROUP = "fe.protection.inventorygroup";
    public static final String PERM_USE = "fe.protection.use";
    public static final String PERM_BREAK = "fe.protection.break";
    public static final String PERM_PLACE = "fe.protection.place";
    public static final String PERM_INTERACT = "fe.protection.interact";
    public static final String PERM_INTERACT_ENTITY = "fe.protection.interact.entity";
    public static final String PERM_DAMAGE_TO = "fe.protection.damageto";
    public static final String PERM_DAMAGE_BY = "fe.protection.damageby";
    public static final String PERM_INVENTORY = "fe.protection.inventory";
    public static final String PERM_EXPLOSION = "fe.protection.explosion";
    public static final String PERM_MOBSPAWN = "fe.protection.mobspawn";
    public static final String PERM_MOBSPAWN_NATURAL = "fe.protection.mobspawn.natural";
    public static final String PERM_MOBSPAWN_FORCED = "fe.protection.mobspawn.forced";
    public static final String ZONE = "fe.protection.zone";
    public static final String ZONE_KNOCKBACK = "fe.protection.zone.knockback";
    public static final String ZONE_DAMAGE = "fe.protection.zone.damage";
    public static final String ZONE_DAMAGE_INTERVAL = "fe.protection.zone.damage.interval";
    public static final String ZONE_COMMAND = "fe.protection.zone.command";
    public static final String ZONE_COMMAND_INTERVAL = "fe.protection.zone.command.interval";
    public static final String ZONE_POTION = "fe.protection.zone.potion";
    public static final String ZONE_POTION_INTERVAL = "fe.protection.zone.potion.interval";
    public static final String MSG_ZONE_DENIED = "You are not allowed to enter this area!";
    private static final Class<?>[] damageEntityClasses = new Class[]{EntityVillager.class, EntityChicken.class, EntityCow.class, EntityMooshroom.class, EntityHorse.class, EntityPig.class, EntityOcelot.class, EntityWolf.class, EntityBlaze.class, EntityCreeper.class, EntityEnderman.class, EntityGiantZombie.class, EntitySilverfish.class, EntitySkeleton.class, EntitySpider.class, EntityWitch.class, EntityWither.class, EntityZombie.class, EntityPigZombie.class, EntityIronGolem.class, EntitySnowman.class, EntitySquid.class};
    private static final DamageSource[] damageByTypes = new DamageSource[]{DamageSource.field_82728_o, DamageSource.field_76367_g, DamageSource.field_76369_e, DamageSource.field_76379_h, DamageSource.field_82729_p, DamageSource.field_76377_j, DamageSource.field_76372_a, DamageSource.field_76368_d, DamageSource.field_76371_c, DamageSource.field_76376_m, DamageSource.field_76370_b, DamageSource.field_76380_i, DamageSource.field_76366_f, DamageSource.field_82727_n};
    public static Set<String> debugModePlayers = new HashSet<String>();
    private ProtectionEventHandler protectionHandler;

    @SubscribeEvent
    public void load(FEModuleEvent.FEModuleInitEvent e) {
        this.protectionHandler = new ProtectionEventHandler();
    }

    public static String getItemName(Item item) {
        try {
            return item.func_77653_i(new ItemStack(item));
        }
        catch (Exception e) {
            return item.func_77658_a();
        }
    }

    @SubscribeEvent
    public void registerPermissions(FEModuleEvent.FEModuleServerInitEvent ev) {
        FunctionHelper.registerServerCommand(new CommandItemPermission());
        FunctionHelper.registerServerCommand(new CommandProtectionDebug());
        FunctionHelper.registerServerCommand(new ProtectCommand());
        APIRegistry.perms.registerPermission(PERM_PVP, PermissionsManager.RegisteredPermValue.TRUE, "Allow PvP");
        APIRegistry.perms.registerPermissionProperty(PERM_GAMEMODE, "-1", "Force gamemode (-1 = none, 0 = survival, 1 = creative, 2 = adventure)");
        APIRegistry.perms.registerPermissionProperty(PERM_INVENTORY_GROUP, "default", "Inventory group property - can be set to any identifier to separate inventories for certain regions");
        APIRegistry.perms.registerPermission(PERM_INTERACT_ENTITY, PermissionsManager.RegisteredPermValue.TRUE, "Allow interacting with entities (villagers, dogs, horses)");
        APIRegistry.perms.registerPermission(PERM_EXPLOSION, PermissionsManager.RegisteredPermValue.TRUE, "(global) Allows explosions.");
        APIRegistry.perms.registerPermission(PERM_DAMAGE_TO, PermissionsManager.RegisteredPermValue.TRUE, "Allow damaging entities");
        APIRegistry.perms.registerPermission(PERM_DAMAGE_BY, PermissionsManager.RegisteredPermValue.TRUE, "Allow getting hurt by entities");
        for (Class<?> clazz : damageEntityClasses) {
            APIRegistry.perms.registerPermission("fe.protection.damageto." + clazz.getSimpleName(), PermissionsManager.RegisteredPermValue.TRUE);
            APIRegistry.perms.registerPermission("fe.protection.damageby." + clazz.getSimpleName(), PermissionsManager.RegisteredPermValue.TRUE);
        }
        for (Class<?> clazz : damageByTypes) {
            APIRegistry.perms.registerPermission("fe.protection.damageby." + clazz.func_76355_l(), PermissionsManager.RegisteredPermValue.TRUE);
        }
        APIRegistry.perms.registerPermission("fe.protection.mobspawn*", PermissionsManager.RegisteredPermValue.TRUE, "(global) Allow spawning of mobs");
        APIRegistry.perms.registerPermission("fe.protection.mobspawn.natural.*", PermissionsManager.RegisteredPermValue.TRUE, "(global) Allow natural spawning of mobs (random spawn in the dark)");
        APIRegistry.perms.registerPermission("fe.protection.mobspawn.forced.*", PermissionsManager.RegisteredPermValue.TRUE, "(global) Allow forced spawning of mobs (spawners, spawn-eggs)");
        for (Map.Entry e : EntityList.field_75625_b.entrySet()) {
            if (!EntityLiving.class.isAssignableFrom((Class)e.getValue())) continue;
            APIRegistry.perms.registerPermission("fe.protection.mobspawn.natural." + (String)e.getKey(), PermissionsManager.RegisteredPermValue.TRUE);
            APIRegistry.perms.registerPermission("fe.protection.mobspawn.forced." + (String)e.getKey(), PermissionsManager.RegisteredPermValue.TRUE);
        }
        APIRegistry.perms.registerPermission("fe.protection.use.*", PermissionsManager.RegisteredPermValue.TRUE, "Allow using items");
        APIRegistry.perms.registerPermission("fe.protection.inventory.*", PermissionsManager.RegisteredPermValue.TRUE, "Allow having item in inventory. Item will be dropped if not allowed.");
        for (Item item : GameData.getItemRegistry().typeSafeIterable()) {
            if (item instanceof ItemBlock) continue;
            String itemPerm = "." + item.func_77658_a() + ".*";
            APIRegistry.perms.registerPermission(PERM_USE + itemPerm, PermissionsManager.RegisteredPermValue.TRUE, "USE " + ModuleProtection.getItemName(item));
            APIRegistry.perms.registerPermission(PERM_INVENTORY + itemPerm, PermissionsManager.RegisteredPermValue.TRUE, "INVENTORY " + ModuleProtection.getItemName(item));
        }
        APIRegistry.perms.registerPermission("fe.protection.break.*", PermissionsManager.RegisteredPermValue.TRUE, "Allow breaking blocks");
        APIRegistry.perms.registerPermission("fe.protection.place.*", PermissionsManager.RegisteredPermValue.TRUE, "Allow placing blocks");
        APIRegistry.perms.registerPermission("fe.protection.interact.*", PermissionsManager.RegisteredPermValue.TRUE, "Allow interacting with blocks (button, chest, workbench)");
        for (Block block : GameData.getBlockRegistry().typeSafeIterable()) {
            String blockPerm = "." + block.func_149739_a() + ".*";
            APIRegistry.perms.registerPermission(PERM_BREAK + blockPerm, PermissionsManager.RegisteredPermValue.TRUE, "BREAK " + block.func_149732_F());
            APIRegistry.perms.registerPermission(PERM_PLACE + blockPerm, PermissionsManager.RegisteredPermValue.TRUE, "PLACE " + block.func_149732_F());
            APIRegistry.perms.registerPermission(PERM_INTERACT + blockPerm, PermissionsManager.RegisteredPermValue.TRUE, "INTERACT " + block.func_149732_F());
        }
        APIRegistry.perms.registerPermissionDescription(ZONE, "Worldborder permissions");
        APIRegistry.perms.registerPermission(ZONE_KNOCKBACK, PermissionsManager.RegisteredPermValue.FALSE, "Deny players from entering this area");
        APIRegistry.perms.registerPermissionProperty(ZONE_DAMAGE, null, "Apply this amount of damage to players, if they are in this area");
        APIRegistry.perms.registerPermissionProperty(ZONE_DAMAGE_INTERVAL, "1000", "Time interval in milliseconds for applying damage-effect. Zero = once only.");
        APIRegistry.perms.registerPermissionProperty(ZONE_COMMAND, null, "Execute this command if a player enters the area");
        APIRegistry.perms.registerPermissionProperty(ZONE_COMMAND_INTERVAL, "0", "Time interval in milliseconds for executing command. Zero = once only.");
        APIRegistry.perms.registerPermissionProperty(ZONE_POTION, null, "Apply potion effects to players who enter this area. Comma separated list of \"ID:duration:amplifier\" pairs. See http://www.minecraftwiki.net/wiki/Potion_effects#Parameters");
        APIRegistry.perms.registerPermissionProperty(ZONE_POTION_INTERVAL, "2000", "Time interval in milliseconds for applying potion-effects. Zero = once only.");
    }

    public static void enableDebugMode(EntityPlayer player) {
        debugModePlayers.add(player.func_70005_c_());
    }

    public static void disableDebugMode(EntityPlayer player) {
        debugModePlayers.remove(player.func_70005_c_());
    }

    public static boolean isDebugMode(EntityPlayer player) {
        return debugModePlayers.contains(player.func_70005_c_());
    }
}

