/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.playerlogger.types;

import com.forgeessentials.playerlogger.ModulePlayerLogger;
import com.forgeessentials.playerlogger.types.LogType;
import com.forgeessentials.util.OutputHandler;
import com.google.common.base.Charsets;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialBlob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class BlockChangeType
extends LogType {
    public BlockChangeType(blockChangeLogCategory cat, EntityPlayer player, String block, int X, int Y, int Z, TileEntity te) {
        SerialBlob teBlob = null;
        if (te != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            te.func_145841_b(nbt);
            nbt.func_74778_a("TE_CLASS", te.getClass().getCanonicalName());
            try {
                teBlob = new SerialBlob(nbt.toString().getBytes(Charsets.UTF_8));
            }
            catch (Exception e) {
                OutputHandler.felog.severe(e.toString());
                e.printStackTrace();
            }
        }
        try {
            PreparedStatement ps = ModulePlayerLogger.getConnection().prepareStatement(this.getprepareStatementSQL());
            ps.setString(1, player.getPersistentID().toString());
            ps.setString(2, cat.toString());
            ps.setString(3, block);
            ps.setInt(4, player.field_71093_bK);
            ps.setInt(5, X);
            ps.setInt(6, Y);
            ps.setInt(7, Z);
            ps.setTimestamp(8, this.time);
            ps.setBlob(9, teBlob);
            ps.execute();
            ps.clearParameters();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public BlockChangeType() {
    }

    @Override
    public String getName() {
        return "blockChange";
    }

    @Override
    public String getTableCreateSQL() {
        return "CREATE TABLE IF NOT EXISTS " + this.getName() + "(id INT UNSIGNED NOT NULL AUTO_INCREMENT,PRIMARY KEY (id), player VARCHAR(32), category VARCHAR(32), block VARCHAR(32), Dim INT, X INT, Y INT, Z INT, time DATETIME, te LONGBLOB)";
    }

    @Override
    public String getprepareStatementSQL() {
        return "INSERT INTO " + this.getName() + " (player, category, block, Dim, X, Y, Z, time, te) VALUES (?,?,?,?,?,?,?,?,?);";
    }

    public static enum blockChangeLogCategory {
        broke,
        placed,
        interact;

    }
}

