/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.playerlogger.rollback;

import com.forgeessentials.playerlogger.BlockChange;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.tasks.ITickTask;
import com.google.common.base.Charsets;
import cpw.mods.fml.common.registry.GameData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class TickTaskRollback
implements ITickTask {
    private boolean isComplete = false;
    private ICommandSender sender;
    private int changed = 0;
    private boolean undo;
    private WorldServer world;
    private Iterator<BlockChange> i;

    public TickTaskRollback(ICommandSender sender, boolean undo, ArrayList<BlockChange> changes) throws SQLException {
        this.sender = sender;
        this.undo = undo;
        this.i = changes.iterator();
    }

    @Override
    public void tick() {
        int currentTickChanged = 0;
        boolean continueFlag = true;
        while (continueFlag) {
            try {
                if (this.i.hasNext()) {
                    BlockChange bc = this.i.next();
                    this.world = DimensionManager.getWorld((int)bc.getDimension());
                    if (bc.getType() == 0) {
                        if (!this.undo) {
                            this.place(bc);
                        } else {
                            this.remove(bc);
                        }
                    } else if (bc.getType() == 1) {
                        if (this.undo) {
                            this.place(bc);
                        } else {
                            this.remove(bc);
                        }
                    }
                    ++currentTickChanged;
                    this.world.func_147471_g(bc.getX(), bc.getY(), bc.getZ());
                } else {
                    this.isComplete = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!this.isComplete && currentTickChanged < 20) continue;
            this.changed += currentTickChanged;
            continueFlag = false;
        }
    }

    public void place(BlockChange bc) {
        String[] block = bc.getBlock().split(":");
        Block blockPlace = (Block)GameData.getBlockRegistry().func_82594_a(block[0]);
        this.world.func_147465_d(bc.getX(), bc.getY(), bc.getZ(), blockPlace, Integer.parseInt(block[1]), 2);
        if (bc.getData() != null) {
            try {
                byte[] bdata = bc.getData().getBytes(1L, (int)bc.getData().length());
                System.out.println(new String(bdata));
                NBTTagCompound compound = (NBTTagCompound)JsonToNBT.func_150315_a((String)new String(bdata, Charsets.UTF_8));
                TileEntity te = (TileEntity)Class.forName(compound.func_74779_i("TE_CLASS")).newInstance();
                te.func_145839_a(compound);
                this.world.func_147455_a(bc.getX(), bc.getY(), bc.getZ(), te);
            }
            catch (Exception e) {
                OutputHandler.chatError(this.sender, "Could not restore TE data.");
                e.printStackTrace();
            }
        }
    }

    public void remove(BlockChange bc) {
        this.world.func_147475_p(bc.getX(), bc.getY(), bc.getZ());
        this.world.func_147449_b(bc.getX(), bc.getY(), bc.getZ(), Blocks.field_150350_a);
    }

    @Override
    public void onComplete() {
        OutputHandler.chatConfirmation(this.sender, "Rollback done! Changed " + this.changed + " blocks.");
    }

    @Override
    public boolean isComplete() {
        return this.isComplete;
    }

    @Override
    public boolean editsBlocks() {
        return true;
    }
}

