/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.playerlogger.rollback;

import com.forgeessentials.commons.selections.WorldPoint;
import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.playerlogger.ModulePlayerLogger;
import com.forgeessentials.playerlogger.network.S3PacketRollback;
import com.forgeessentials.playerlogger.rollback.TickTaskRollback;
import com.forgeessentials.util.FunctionHelper;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.UserIdent;
import com.forgeessentials.util.tasks.TaskRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandRollback
extends ForgeEssentialsCommandBase {
    HashMap<ICommandSender, String> que = new HashMap();

    public String func_71517_b() {
        return "rollback";
    }

    public List<String> func_71514_a() {
        return Arrays.asList("rb");
    }

    @Override
    public void func_71515_b(ICommandSender sender, String[] args) {
        ArrayList<String> userlist = new ArrayList<String>();
        userlist.addAll(Arrays.asList(MinecraftServer.func_71276_C().func_71203_ab().func_72373_m()));
        if (args.length == 0) {
            OutputHandler.chatNotification(sender, "--- Rollback usage ---");
            OutputHandler.chatNotification(sender, "All actions must be confirmed with '/rb ok'.");
            OutputHandler.chatNotification(sender, "All actions can be canceld with '/rb abort'.");
            OutputHandler.chatNotification(sender, "'/rb clear <username>' => Removes a players data.");
            OutputHandler.chatNotification(sender, "'/rb undo <username>' => Undo a rollback. You can specify time and radius");
            OutputHandler.chatNotification(sender, "'/rb <undo|rollback> <username>' => Rolls back a players. All the way!");
            OutputHandler.chatNotification(sender, "'/rb <undo|rollback> <username> <rad>' => Format like this: 10r");
            OutputHandler.chatNotification(sender, "'/rb <undo|rollback> <username> <time>' => Format time like this: 10d = 10 days, 10h = 10 hours.");
            OutputHandler.chatNotification(sender, "A combo of the above is possible too.");
            return;
        }
        if (args[0].equalsIgnoreCase("ok")) {
            if (this.que.containsKey(sender)) {
                this.execute(sender, this.que.get(sender).split(" "));
                this.que.remove(sender);
            } else {
                OutputHandler.chatError(sender, "No pending commands.");
            }
            return;
        }
        if (args[0].equalsIgnoreCase("abort")) {
            if (this.que.containsKey(sender)) {
                this.que.remove(sender);
                FunctionHelper.netHandler.sendTo((IMessage)new S3PacketRollback(((EntityPlayer)sender).field_71093_bK, null), (EntityPlayerMP)sender);
                OutputHandler.chatConfirmation(sender, "Command aborted");
            } else {
                OutputHandler.chatError(sender, "No pending commands.");
            }
            return;
        }
        if (args.length > 2) {
            OutputHandler.chatError(sender, "You have to provide a username!");
            return;
        }
        if (userlist.contains(UserIdent.getUuidByUsername(args[1]))) {
            OutputHandler.chatError(sender, "That player is not in the database.");
            return;
        }
        if (args[0].equalsIgnoreCase("clear")) {
            OutputHandler.chatWarning(sender, "Confirm the clearing of all blockchanges for player " + args[1]);
            this.que.put(sender, "clear " + args[1]);
        } else if (args[0].equalsIgnoreCase("undo")) {
            this.parse(sender, args, true, false);
        } else if (args[0].equalsIgnoreCase("rollback") || args[0].equalsIgnoreCase("rb")) {
            this.parse(sender, args, false, false);
        }
    }

    private void execute(ICommandSender sender, String[] args) {
        if (args[0].equalsIgnoreCase("clear")) {
            try {
                Statement st = ModulePlayerLogger.getConnection().createStatement();
                st.execute("DELETE FROM `blockchange` WHERE `player` LIKE '" + args[1] + "'");
                OutputHandler.chatConfirmation(sender, "Removed all records of " + args[1]);
                st.close();
            }
            catch (Exception e) {
                OutputHandler.chatError(sender, "Error. " + e.getLocalizedMessage());
                e.printStackTrace();
            }
        } else if (args[0].equalsIgnoreCase("undo")) {
            this.parse(sender, args, true, true);
        } else if (args[0].equalsIgnoreCase("rollback") || args[0].equalsIgnoreCase("rb")) {
            this.parse(sender, args, false, true);
        }
    }

    public void parse(ICommandSender sender, String[] args, boolean undo, boolean execute) {
        int time = 0;
        WorldPoint point = sender instanceof EntityPlayer ? new WorldPoint((Entity)((EntityPlayer)sender)) : null;
        int rad = 0;
        for (int i = 1; i < args.length; ++i) {
            String arg = args[i];
            if (arg.endsWith("d")) {
                time = 24 * CommandRollback.func_71526_a((ICommandSender)sender, (String)arg.replaceAll("d", ""));
                continue;
            }
            if (arg.endsWith("h")) {
                time = CommandRollback.func_71526_a((ICommandSender)sender, (String)arg.replaceAll("h", ""));
                continue;
            }
            if (!arg.endsWith("r")) continue;
            rad = CommandRollback.func_71528_a((ICommandSender)sender, (String)arg.replaceAll("r", ""), (int)0);
        }
        if (execute) {
            try {
                TaskRegistry.registerTask(new TickTaskRollback(sender, undo, ModulePlayerLogger.getBlockChangesWithinParameters(args[1], undo, time, point, rad)));
            }
            catch (SQLException e) {
                OutputHandler.chatError(sender, "Error. " + e.getLocalizedMessage());
                e.printStackTrace();
            }
        } else {
            StringBuilder sb = new StringBuilder();
            for (String arg : args) {
                sb.append(arg + " ");
            }
            this.que.put(sender, sb.toString().trim());
            if (sender instanceof EntityPlayer) {
                FunctionHelper.netHandler.sendTo((IMessage)new S3PacketRollback(((EntityPlayer)sender).field_71093_bK, ModulePlayerLogger.getBlockChangesWithinParameters(args[1], undo, time, point, rad)), (EntityPlayerMP)sender);
            }
        }
    }

    @Override
    public boolean canConsoleUseCommand() {
        return true;
    }

    @Override
    public String getPermissionNode() {
        return "fe.pl.rollback";
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CommandRollback.func_71530_a((String[])args, (String[])new String[]{"ok", "abort", "clear", "undo", "rollback"});
        }
        if (args.length == 2) {
            return CommandRollback.func_71530_a((String[])args, (String[])FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_72373_m());
        }
        if (args.length == 2) {
            return CommandRollback.func_71530_a((String[])args, (String[])new String[]{"clear", "undo"});
        }
        return null;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/rollback <username> [undo|clear] Configure rollbacks.";
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.OP;
    }
}

