/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.playerlogger;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.commons.selections.WorldPoint;
import com.forgeessentials.core.ForgeEssentials;
import com.forgeessentials.core.moduleLauncher.FEModule;
import com.forgeessentials.core.moduleLauncher.ModuleLauncher;
import com.forgeessentials.playerlogger.BlockChange;
import com.forgeessentials.playerlogger.ConfigPlayerLogger;
import com.forgeessentials.playerlogger.EventLogger;
import com.forgeessentials.playerlogger.network.S2PacketPlayerLogger;
import com.forgeessentials.playerlogger.network.S3PacketRollback;
import com.forgeessentials.playerlogger.rollback.CommandPl;
import com.forgeessentials.playerlogger.rollback.CommandRollback;
import com.forgeessentials.playerlogger.rollback.EventHandler;
import com.forgeessentials.playerlogger.types.BlockChangeType;
import com.forgeessentials.playerlogger.types.CommandType;
import com.forgeessentials.playerlogger.types.LogType;
import com.forgeessentials.playerlogger.types.PlayerTrackerType;
import com.forgeessentials.util.FunctionHelper;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.events.FEModuleEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;

@FEModule(name="PlayerLogger", parentMod=ForgeEssentials.class)
public class ModulePlayerLogger {
    public static String url;
    public static String username;
    public static String password;
    public static boolean ragequitOn;
    public static EventLogger eLogger;
    public static HashSet<LogType> logTypes;
    public static final String DEFAULT_URL = "jdbc:mysql://localhost:3306/testdb";
    public static final String DEFAULT_USER = "root";
    public static final String DEFAULT_PASS = "root";
    private static Connection connection;

    @FEModule.Preconditions
    public boolean checkSQLCredentials() {
        ForgeEssentials.getConfigManager().registerLoader("PlayerLogger", new ConfigPlayerLogger());
        return !url.equals(DEFAULT_URL) || !password.equals("root") || !username.equals("root");
    }

    public static Connection getConnection() {
        try {
            if (connection.isClosed()) {
                connection = DriverManager.getConnection(url, username, password);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return connection;
    }

    public static void error(Exception e) {
        if (ragequitOn) {
            MinecraftServer.func_71276_C().func_71260_j();
        } else {
            OutputHandler.felog.severe("PlayerLogger error: " + e.getLocalizedMessage());
        }
    }

    public static ArrayList<BlockChange> getBlockChangesWithinParameters(String playername, boolean undo, int timeBack, WorldPoint p, int rad) {
        ArrayList<BlockChange> data = new ArrayList<BlockChange>();
        try {
            Connection connection = DriverManager.getConnection(url, username, password);
            Statement st = connection.createStatement();
            String sql = "SELECT * FROM  `blockChange` WHERE  `player` LIKE  '" + playername + "'";
            if (timeBack != 0) {
                Date date = new Date();
                Timestamp time = new Timestamp(date.getTime());
                time.setNanos(time.getNanos() - timeBack * 60 * 60 * 1000 * 1000);
                sql = sql + " AND `time` = '" + time.toString() + "'";
            }
            if (p != null && rad != 0) {
                sql = sql + " AND `Dim` = " + p.getDimension();
                sql = sql + " AND `X` BETWEEN " + (p.getX() - rad) + " AND " + (p.getX() + rad);
                sql = sql + " AND `Z` BETWEEN " + (p.getZ() - rad) + " AND " + (p.getZ() + rad);
            }
            sql = undo ? sql + " ORDER BY time ASC" : sql + " ORDER BY time DESC";
            st.execute(sql);
            ResultSet rs = st.getResultSet();
            while (rs.next()) {
                data.add(new BlockChange(rs.getInt("X"), rs.getInt("Y"), rs.getInt("Z"), rs.getInt("dim"), BlockChangeType.blockChangeLogCategory.valueOf(rs.getString("category")).ordinal(), rs.getString("block"), rs.getBlob("te")));
            }
            rs.close();
            st.close();
            connection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return data;
    }

    @SubscribeEvent
    public void preLoad(FEModuleEvent.FEModulePreInitEvent e) {
        OutputHandler.felog.info("PlayerLogger module is enabled. Loading...");
        FunctionHelper.netHandler.registerMessage(S2PacketPlayerLogger.class, S2PacketPlayerLogger.class, 2, Side.CLIENT);
        FunctionHelper.netHandler.registerMessage(S3PacketRollback.class, S3PacketRollback.class, 3, Side.CLIENT);
    }

    @SubscribeEvent
    public void load(FEModuleEvent.FEModuleInitEvent e) {
        for (String name : EventLogger.exempt_groups) {
            if (APIRegistry.perms.groupExists(name)) continue;
            throw new RuntimeException("Group '" + name + "' doesn't exist.");
        }
        try {
            Class.forName("com.mysql.jdbc.Driver");
        }
        catch (ClassNotFoundException error) {
            throw new RuntimeException("Could not find MySQL JDBC Driver.");
        }
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
    }

    @SubscribeEvent
    public void serverStarting(FEModuleEvent.FEModuleServerInitEvent e) {
        FunctionHelper.registerServerCommand(new CommandPl());
        FunctionHelper.registerServerCommand(new CommandRollback());
        try {
            connection = DriverManager.getConnection(url, username, password);
            Statement s = connection.createStatement();
            for (LogType type : logTypes) {
                s.execute(type.getTableCreateSQL());
            }
            s.close();
            eLogger = new EventLogger();
        }
        catch (SQLException e1) {
            OutputHandler.felog.info("Could not connect to database! Wrong credentials or no credentials!");
            OutputHandler.felog.info(e1.getMessage());
            e1.printStackTrace();
            ModuleLauncher.instance.unregister("PlayerLogger");
        }
    }

    @SubscribeEvent
    public void serverStopping(FEModuleEvent.FEModuleServerStopEvent e) {
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
        catch (Exception ex) {
            OutputHandler.felog.warning("WARNING! MySQLConnector for playerLogger failed!");
            ex.printStackTrace();
        }
    }

    static {
        logTypes = new HashSet();
        logTypes.add(new PlayerTrackerType());
        logTypes.add(new CommandType());
        logTypes.add(new BlockChangeType());
    }
}

