/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.playerlogger;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.api.permissions.GroupEntry;
import com.forgeessentials.playerlogger.types.BlockChangeType;
import com.forgeessentials.playerlogger.types.CommandType;
import com.forgeessentials.playerlogger.types.PlayerTrackerType;
import com.forgeessentials.util.UserIdent;
import com.forgeessentials.util.events.ServerEventHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;

public class EventLogger
extends ServerEventHandler {
    public static boolean logPlayerChangedDimension = true;
    public static boolean logPlayerRespawn = true;
    public static boolean logItemUsage = true;
    public static boolean logBlockChanges = true;
    public static boolean logPlayerLoginLogout = true;
    public static boolean logCommands_Player = true;
    public static boolean logCommands_Block = true;
    public static boolean logCommands_rest = true;
    public static boolean logDeathDrops = true;
    public static boolean BlockChange_WhiteList_Use = false;
    public static ArrayList<Integer> BlockChange_WhiteList = new ArrayList();
    public static ArrayList<Integer> BlockChange_BlackList = new ArrayList();
    public static List<String> exempt_players = new ArrayList<String>();
    public static List<String> exempt_groups = new ArrayList<String>();
    public Side side = FMLCommonHandler.instance().getEffectiveSide();

    public EventLogger() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static boolean exempt(EntityPlayer player) {
        for (String un : exempt_players) {
            if (!un.replaceAll("\"", "").equalsIgnoreCase(player.getPersistentID().toString())) continue;
            return true;
        }
        for (GroupEntry group : APIRegistry.perms.getPlayerGroups(new UserIdent(player))) {
            if (!exempt_groups.contains(group.getGroup())) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        if (logPlayerLoginLogout && this.side.isServer()) {
            if (EventLogger.exempt(e.player)) {
                return;
            }
            new PlayerTrackerType(PlayerTrackerType.Types.Login, e.player, "");
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent e) {
        if (logPlayerLoginLogout && this.side.isServer()) {
            if (EventLogger.exempt(e.player)) {
                return;
            }
            new PlayerTrackerType(PlayerTrackerType.Types.Logout, e.player, "");
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent e) {
        if (logPlayerChangedDimension && this.side.isServer()) {
            if (EventLogger.exempt(e.player)) {
                return;
            }
            new PlayerTrackerType(PlayerTrackerType.Types.ChangedDim, e.player, "");
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent e) {
        if (logPlayerRespawn && this.side.isServer()) {
            if (EventLogger.exempt(e.player)) {
                return;
            }
            new PlayerTrackerType(PlayerTrackerType.Types.Respawn, e.player, "");
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void command(CommandEvent e) {
        if (logCommands_Player && !e.isCanceled() && e.sender instanceof EntityPlayer && this.side.isServer()) {
            if (EventLogger.exempt((EntityPlayer)e.sender)) {
                return;
            }
            new CommandType(e.sender.func_70005_c_(), this.getCommand(e));
            return;
        }
        if (logCommands_Block && !e.isCanceled() && e.sender instanceof TileEntityCommandBlock && this.side.isServer()) {
            new CommandType(e.sender.func_70005_c_(), this.getCommand(e));
            return;
        }
        if (logCommands_rest && !e.isCanceled() && this.side.isServer()) {
            new CommandType(e.sender.func_70005_c_(), this.getCommand(e));
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void playerBlockBreak(BlockEvent.BreakEvent e) {
        if (logBlockChanges && !e.isCanceled() && this.side.isServer()) {
            if (EventLogger.exempt(e.getPlayer())) {
                return;
            }
            new BlockChangeType(BlockChangeType.blockChangeLogCategory.broke, e.getPlayer(), e.block.func_149739_a() + ":" + e.blockMetadata, e.x, e.y, e.z, e.world.func_147438_o(e.x, e.y, e.z));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void playerBlockPlace(BlockEvent.PlaceEvent e) {
        if (logBlockChanges && !e.isCanceled() && this.side.isServer()) {
            if (EventLogger.exempt(e.player)) {
                return;
            }
            if (BlockChange_WhiteList_Use && !BlockChange_WhiteList.contains(e.player.field_71093_bK)) {
                return;
            }
            if (BlockChange_BlackList.contains(e.player.field_71093_bK) && !BlockChange_WhiteList.contains(e.player.field_71093_bK)) {
                return;
            }
            String block = "";
            if (e.player.field_71071_by.func_70448_g() != null) {
                block = e.player.field_71071_by.func_70448_g().func_77977_a() + ":" + e.player.field_71071_by.func_70448_g().func_77960_j();
            }
            new BlockChangeType(BlockChangeType.blockChangeLogCategory.placed, e.player, block, e.x, e.y, e.z, null);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void playerBlockPlace(BlockEvent.MultiPlaceEvent e) {
        if (logBlockChanges && !e.isCanceled() && this.side.isServer()) {
            if (EventLogger.exempt(e.player)) {
                return;
            }
            if (BlockChange_WhiteList_Use && !BlockChange_WhiteList.contains(e.player.field_71093_bK)) {
                return;
            }
            if (BlockChange_BlackList.contains(e.player.field_71093_bK) && !BlockChange_WhiteList.contains(e.player.field_71093_bK)) {
                return;
            }
            String block = "";
            if (e.player.field_71071_by.func_70448_g() != null) {
                block = e.player.field_71071_by.func_70448_g().func_77977_a() + ":" + e.player.field_71071_by.func_70448_g().func_77960_j();
            }
            for (BlockSnapshot b : e.getReplacedBlockSnapshots()) {
                new BlockChangeType(BlockChangeType.blockChangeLogCategory.placed, e.player, block, b.x, b.y, b.z, null);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void playerInteractEvent(PlayerInteractEvent e) {
        if (e.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            if (EventLogger.exempt(e.entityPlayer)) {
                return;
            }
            if (BlockChange_WhiteList_Use && !BlockChange_WhiteList.contains(e.entityPlayer.field_71093_bK)) {
                return;
            }
            if (BlockChange_BlackList.contains(e.entityPlayer.field_71093_bK) && !BlockChange_WhiteList.contains(e.entityPlayer.field_71093_bK)) {
                return;
            }
            new BlockChangeType(BlockChangeType.blockChangeLogCategory.interact, e.entityPlayer, e.entity.field_70170_p.func_147439_a(e.x, e.y, e.z).func_149739_a() + ":" + e.entity.field_70170_p.func_72805_g(e.x, e.y, e.z), e.x, e.y, e.z, e.entity.field_70170_p.func_147438_o(e.x, e.y, e.z));
        }
    }

    public String getCommand(CommandEvent e) {
        String command = "/" + e.command.func_71517_b();
        for (String str : e.parameters) {
            command = command + " " + str;
        }
        return command;
    }
}

