/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.playerlogger;

import com.forgeessentials.core.moduleLauncher.config.IConfigLoader;
import com.forgeessentials.playerlogger.EventLogger;
import com.forgeessentials.playerlogger.ModulePlayerLogger;
import java.util.Arrays;
import net.minecraftforge.common.config.Configuration;

public class ConfigPlayerLogger
extends IConfigLoader.ConfigLoaderBase {
    public static final String[] exemptDefPlayers = new String[]{"\"[Forestry]\"", "\"[Buildcraft]\""};
    private static final String cat = "playerLogger";

    @Override
    public void load(Configuration config, boolean isReload) {
        int[] intArray2;
        int[] intArray1;
        String subcat = "playerLogger.DB";
        config.addCustomCategoryComment(subcat, "Database settings. Look here if something broke. This MUST be changed to load the PlayerLogger module.");
        ModulePlayerLogger.url = config.get(subcat, "url", "jdbc:mysql://localhost:3306/testdb", "jdbc url").getString();
        ModulePlayerLogger.username = config.get(subcat, "username", "root").getString();
        ModulePlayerLogger.password = config.get(subcat, "password", "root").getString();
        ModulePlayerLogger.ragequitOn = config.get(subcat, "ragequit", false, "Stop the server when the logging fails").getBoolean(false);
        subcat = "playerLogger.exempt";
        config.addCustomCategoryComment(subcat, "Don't log stuff from these players/group.\nCase sensitive.\nMods should not be using fake players. But if they do, you can add them here if you don't logs from them.");
        EventLogger.exempt_players = Arrays.asList(config.get(subcat, "players", exemptDefPlayers).getStringList());
        EventLogger.exempt_groups = Arrays.asList(config.get(subcat, "groups", new String[0]).getStringList());
        subcat = "playerLogger.events";
        config.addCustomCategoryComment(subcat, "Toggle events to log here.");
        EventLogger.logPlayerLoginLogout = config.get(subcat, "playerLoginLogout", true).getBoolean(true);
        EventLogger.logPlayerChangedDimension = config.get(subcat, "playerChangeDimension", true).getBoolean(true);
        EventLogger.logPlayerRespawn = config.get(subcat, "playerRespawn", true).getBoolean(true);
        String subcat2 = subcat + ".commands";
        EventLogger.logCommands_Player = config.get(subcat2, "Enable_Player", true).getBoolean(true);
        EventLogger.logCommands_Block = config.get(subcat2, "Enable_CmdBlock", true).getBoolean(true);
        EventLogger.logCommands_rest = config.get(subcat2, "Enable_Rest", true).getBoolean(true);
        subcat2 = subcat + ".blockChanges";
        EventLogger.logBlockChanges = config.get(subcat2, "Enable", true).getBoolean(true);
        EventLogger.BlockChange_WhiteList_Use = config.get(subcat2, "UseWhitelist", false, "If true, only log in dimensions that are in the whitelist.").getBoolean(false);
        for (int i : intArray1 = config.get(subcat2, "WhiteList", new int[]{0, 1, -1}, "WhiteList overrides blacklist!").getIntList()) {
            EventLogger.BlockChange_WhiteList.add(i);
        }
        for (int i : intArray2 = config.get(subcat2, "BlackList", new int[0], "Don't make logs in these dimensions.").getIntList()) {
            EventLogger.BlockChange_BlackList.add(i);
        }
    }
}

