/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.permissions.persistence;

import com.forgeessentials.api.permissions.AreaZone;
import com.forgeessentials.api.permissions.ServerZone;
import com.forgeessentials.api.permissions.WorldZone;
import com.forgeessentials.api.permissions.Zone;
import com.forgeessentials.commons.selections.AreaBase;
import com.forgeessentials.commons.selections.AreaShape;
import com.forgeessentials.permissions.core.ZonePersistenceProvider;
import com.forgeessentials.util.EnumDBType;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.UserIdent;
import com.google.common.base.Throwables;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class SQLProvider
extends ZonePersistenceProvider {
    private static final String TABLE_PREFIX = "fepermissions_";
    private static final String TABLE_INFO = "INFO";
    private static final String TABLE_ZONE = "ZONE";
    private static final String TABLE_GROUP_PERMISSIONS = "GROUP_PERMISSION";
    private static final String TABLE_USER_PERMISSIONS = "USER_PERMISSION";
    private static final String TABLE_USER = "USER";
    private static final String INFO_MAX_ZONE_ID = "max_zone_id";
    private static final String VERSION = "1.2";
    private final Map<String, TableInfo> TABLES = this.setupTableData();
    protected Connection db;
    protected EnumDBType dbType;

    private Map<String, TableInfo> setupTableData() {
        HashMap<String, TableInfo> result = new HashMap<String, TableInfo>();
        TableInfo tbl = new TableInfo("fepermissions_info");
        tbl.columns.put("key", "VARCHAR(64)");
        tbl.columns.put("value", "VARCHAR(64)");
        tbl.primaryKeys.add("key");
        result.put(TABLE_INFO, tbl);
        tbl = new TableInfo("fepermissions_user");
        tbl.columns.put("uuid", "VARCHAR(36)");
        tbl.columns.put("name", "VARCHAR(128)");
        tbl.primaryKeys.add("uuid");
        tbl.nullableKeys.add("name");
        result.put(TABLE_USER, tbl);
        tbl = new TableInfo("fepermissions_zone");
        tbl.columns.put("id", "INT");
        tbl.columns.put("type", "INT");
        tbl.columns.put("parent_id", "INT");
        tbl.columns.put("name", "VARCHAR(64)");
        tbl.columns.put("dimension", "INT");
        tbl.columns.put("area", "VARCHAR(64)");
        tbl.columns.put("shape", "VARCHAR(16)");
        tbl.primaryKeys.add("id");
        tbl.nullableKeys.add("parent_id");
        tbl.nullableKeys.add("name");
        tbl.nullableKeys.add("dimension");
        tbl.nullableKeys.add("area");
        tbl.nullableKeys.add("shape");
        result.put(TABLE_ZONE, tbl);
        tbl = new TableInfo("fepermissions_group_permission");
        tbl.columns.put("group", "VARCHAR(64)");
        tbl.columns.put("zone_id", "INT");
        tbl.columns.put("permission", "VARCHAR(255)");
        tbl.columns.put("value", "VARCHAR(1023)");
        tbl.primaryKeys.add("group");
        tbl.primaryKeys.add("zone_id");
        tbl.primaryKeys.add("permission");
        result.put(TABLE_GROUP_PERMISSIONS, tbl);
        tbl = new TableInfo("fepermissions_user_permission");
        tbl.columns.put("user", "VARCHAR(36)");
        tbl.columns.put("zone_id", "INT");
        tbl.columns.put("permission", "VARCHAR(255)");
        tbl.columns.put("value", "VARCHAR(1023)");
        tbl.primaryKeys.add("user");
        tbl.primaryKeys.add("zone_id");
        tbl.primaryKeys.add("permission");
        result.put(TABLE_USER_PERMISSIONS, tbl);
        return result;
    }

    public SQLProvider(Connection connection, EnumDBType dbType) {
        this.db = connection;
        this.dbType = dbType;
        this.checkAndCreateTables();
        String version = this.getVersion();
        if (version == null) {
            this.setVersion(VERSION);
        } else {
            if (!VERSION.equals(version)) {
                OutputHandler.felog.info("Version of permission database incorrect. May not load permissions correctly!");
            }
            if (version.equals("1.0")) {
                TableInfo tbl = this.TABLES.get(TABLE_ZONE);
                this.executeUpdate("ALTER TABLE `" + tbl.name + "` ADD COLUMN `shape` " + tbl.columns.get("shape"));
                this.setVersion(VERSION);
            }
        }
    }

    private Set<String> getExistingTables() throws SQLException {
        ResultSet resultSet = this.db.getMetaData().getTables(null, null, "fepermissions_%", null);
        HashSet<String> result = new HashSet<String>();
        while (resultSet.next()) {
            result.add(resultSet.getString(3));
        }
        return result;
    }

    private boolean checkAndCreateTables() {
        boolean checkOk = true;
        try {
            Set<String> existingTables = this.getExistingTables();
            Statement statement = this.db.createStatement();
            for (TableInfo tbl : this.TABLES.values()) {
                if (existingTables.contains(tbl.name)) continue;
                checkOk = false;
                statement.executeUpdate(tbl.getCreateStatement());
                existingTables.add(tbl.name);
            }
        }
        catch (SQLException e) {
            Throwables.propagate((Throwable)e);
        }
        return checkOk;
    }

    private void executeUpdate(String stmt) {
        try {
            this.db.createStatement().executeUpdate(stmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private String getVersion() {
        try {
            ResultSet result = this.db.createStatement().executeQuery(this.TABLES.get(TABLE_INFO).createSelectStatement(new String[]{"value"}) + " WHERE `key` = 'version'");
            if (result.next()) {
                return result.getString(1);
            }
            return null;
        }
        catch (SQLException e) {
            return null;
        }
    }

    private void setVersion(String version) {
        HashMap<String, Object> fieldsAndValues = new HashMap<String, Object>();
        fieldsAndValues.put("key", "version");
        fieldsAndValues.put("value", version);
        this.executeUpdate(this.TABLES.get(TABLE_INFO).createInsertOrReplace(fieldsAndValues));
    }

    @Override
    public void save(ServerZone serverZone) {
        try {
            SQLProvider.writeUserGroupPermissions(serverZone);
            this.db.createStatement().executeUpdate(this.TABLES.get(TABLE_ZONE).createTruncate());
            this.db.createStatement().executeUpdate(this.TABLES.get(TABLE_GROUP_PERMISSIONS).createTruncate());
            this.db.createStatement().executeUpdate(this.TABLES.get(TABLE_USER_PERMISSIONS).createTruncate());
            for (UserIdent ident : serverZone.getKnownPlayers()) {
                if (!ident.hasUUID()) continue;
                HashMap<String, Object> fieldsAndValues = new HashMap<String, Object>();
                fieldsAndValues.put("uuid", ident.getUuid().toString());
                if (ident.hasUsername()) {
                    fieldsAndValues.put("name", ident.getUsername());
                }
                this.db.createStatement().executeUpdate(this.TABLES.get(TABLE_USER).createInsertOrReplace(fieldsAndValues));
            }
            this.saveServerZone(serverZone);
            this.saveZonePermissions(serverZone);
            for (WorldZone worldZone : serverZone.getWorldZones().values()) {
                this.saveWorldZone(worldZone);
                this.saveZonePermissions(worldZone);
                for (AreaZone areaZone : worldZone.getAreaZones()) {
                    this.saveAreaZone(areaZone);
                    this.saveZonePermissions(areaZone);
                }
            }
        }
        catch (SQLException se) {
            try {
                this.db.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            Throwables.propagate((Throwable)se);
        }
    }

    private void saveZonePermissions(Zone zone) {
        try {
            HashMap<String, Object> fieldsAndValues;
            for (Map.Entry<String, Zone.PermissionList> entry : zone.getGroupPermissions().entrySet()) {
                for (Map.Entry perm : entry.getValue().entrySet()) {
                    fieldsAndValues = new HashMap<String, Object>();
                    fieldsAndValues.put("group", entry.getKey());
                    fieldsAndValues.put("zone_id", zone.getId());
                    fieldsAndValues.put("permission", perm.getKey());
                    fieldsAndValues.put("value", perm.getValue());
                    this.db.createStatement().executeUpdate(this.TABLES.get(TABLE_GROUP_PERMISSIONS).createInsertOrReplace(fieldsAndValues));
                }
            }
            for (Map.Entry<Object, Zone.PermissionList> entry : zone.getPlayerPermissions().entrySet()) {
                for (Map.Entry perm : entry.getValue().entrySet()) {
                    fieldsAndValues = new HashMap();
                    fieldsAndValues.put("user", ((UserIdent)entry.getKey()).getUuid().toString());
                    fieldsAndValues.put("zone_id", zone.getId());
                    fieldsAndValues.put("permission", perm.getKey());
                    fieldsAndValues.put("value", perm.getValue());
                    this.db.createStatement().executeUpdate(this.TABLES.get(TABLE_USER_PERMISSIONS).createInsertOrReplace(fieldsAndValues));
                }
            }
        }
        catch (SQLException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public void saveServerZone(ServerZone zone) throws SQLException {
        HashMap<String, Object> fieldsAndValues = new HashMap<String, Object>();
        fieldsAndValues.put("id", zone.getId());
        fieldsAndValues.put("type", 0);
        fieldsAndValues.put("parent_id", 0);
        this.db.createStatement().executeUpdate(this.TABLES.get(TABLE_ZONE).createInsertOrReplace(fieldsAndValues));
        fieldsAndValues = new HashMap();
        fieldsAndValues.put("key", INFO_MAX_ZONE_ID);
        fieldsAndValues.put("value", zone.getMaxZoneID());
        this.db.createStatement().executeUpdate(this.TABLES.get(TABLE_INFO).createInsertOrReplace(fieldsAndValues));
    }

    private void saveWorldZone(WorldZone zone) throws SQLException {
        HashMap<String, Object> fieldsAndValues = new HashMap<String, Object>();
        fieldsAndValues.put("id", zone.getId());
        fieldsAndValues.put("type", 1);
        fieldsAndValues.put("parent_id", zone.getParent().getId());
        fieldsAndValues.put("dimension", zone.getDimensionID());
        this.db.createStatement().executeUpdate(this.TABLES.get(TABLE_ZONE).createInsertOrReplace(fieldsAndValues));
    }

    private void saveAreaZone(AreaZone zone) throws SQLException {
        HashMap<String, Object> fieldsAndValues = new HashMap<String, Object>();
        fieldsAndValues.put("id", zone.getId());
        fieldsAndValues.put("type", 2);
        fieldsAndValues.put("parent_id", zone.getParent().getId());
        fieldsAndValues.put("name", zone.getShortName());
        fieldsAndValues.put("dimension", zone.getWorldZone().getDimensionID());
        fieldsAndValues.put("area", zone.getArea().toString());
        fieldsAndValues.put("shape", zone.getShape().toString());
        this.db.createStatement().executeUpdate(this.TABLES.get(TABLE_ZONE).createInsertOrReplace(fieldsAndValues));
    }

    @Override
    public ServerZone load() {
        try {
            Zone zone;
            HashMap<Integer, Zone> zones = new HashMap<Integer, Zone>();
            Map<String, String> infoData = this.TABLES.get(TABLE_INFO).loadMap("key", "value");
            List<Map<String, Object>> zonesData = this.TABLES.get(TABLE_ZONE).loadList();
            List<Map<String, Object>> groupPermissions = this.TABLES.get(TABLE_GROUP_PERMISSIONS).loadList();
            List<Map<String, Object>> userPermissions = this.TABLES.get(TABLE_USER_PERMISSIONS).loadList();
            ServerZone serverZone = null;
            for (Map<String, Object> zoneData : zonesData) {
                if (!zoneData.get("type").equals(0)) continue;
                serverZone = new ServerZone();
                zones.put(serverZone.getId(), serverZone);
                break;
            }
            if (serverZone == null) {
                OutputHandler.felog.severe("Error loading permissions: Missing server-zone");
                this.db.createStatement().executeUpdate(this.TABLES.get(TABLE_ZONE).createTruncate());
                return null;
            }
            for (Map<String, Object> zoneData : zonesData) {
                if (!zoneData.get("type").equals(1)) continue;
                zone = new WorldZone(serverZone, (Integer)zoneData.get("dimension"), (Integer)zoneData.get("id"));
                zones.put(zone.getId(), zone);
            }
            for (Map<String, Object> zoneData : zonesData) {
                AreaBase area;
                WorldZone parentZone;
                if (!zoneData.get("type").equals(2) || (parentZone = (WorldZone)zones.get(zoneData.get("parent_id"))) == null || (area = AreaBase.fromString((String)zoneData.get("area"))) == null) continue;
                AreaZone zone2 = new AreaZone(parentZone, (String)zoneData.get("name"), area, (Integer)zoneData.get("id"));
                AreaShape shape = AreaShape.getByName((String)zoneData.get("shape"));
                if (shape != null) {
                    zone2.setShape(shape);
                }
                zones.put(zone2.getId(), zone2);
            }
            for (Map<String, Object> permData : groupPermissions) {
                zone = (Zone)zones.get(permData.get("zone_id"));
                if (zone == null) continue;
                zone.setGroupPermissionProperty((String)permData.get("group"), (String)permData.get("permission"), (String)permData.get("value"));
            }
            for (Map<String, Object> permData : userPermissions) {
                zone = (Zone)zones.get(permData.get("zone_id"));
                if (zone == null) continue;
                zone.setPlayerPermissionProperty(new UserIdent((String)permData.get("user")), (String)permData.get("permission"), (String)permData.get("value"));
            }
            try {
                serverZone.setMaxZoneId(Integer.parseInt(infoData.get(INFO_MAX_ZONE_ID)));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            for (Zone zone3 : zones.values()) {
                if (zone3.getId() <= serverZone.getMaxZoneID()) continue;
                serverZone.setMaxZoneId(zone3.getId());
            }
            for (UserIdent ident : serverZone.getPlayerPermissions().keySet()) {
                String[] groups;
                String groupList = serverZone.getPlayerPermission(ident, "fe.internal.player.groups");
                serverZone.clearPlayerPermission(ident, "fe.internal.player.groups");
                if (groupList == null) continue;
                for (String group : groups = groupList.split(",")) {
                    serverZone.addPlayerToGroup(ident, group);
                }
            }
            return serverZone;
        }
        catch (Exception e) {
            OutputHandler.felog.severe("Error loading permissions");
            e.printStackTrace();
            return null;
        }
    }

    private class TableInfo {
        public String name;
        public Map<String, String> columns = new HashMap<String, String>();
        public Set<String> primaryKeys = new HashSet<String>();
        public Set<String> nullableKeys = new HashSet<String>();

        public TableInfo(String name) {
            this.name = name;
        }

        public String getCreateStatement() {
            StringBuilder sb = new StringBuilder("CREATE TABLE IF NOT EXISTS `");
            sb.append(this.name);
            sb.append("` (");
            for (Map.Entry<String, String> col : this.columns.entrySet()) {
                sb.append("`");
                sb.append(col.getKey());
                sb.append("` ");
                sb.append(col.getValue());
                if (this.nullableKeys.contains(col.getKey())) {
                    sb.append(", ");
                    continue;
                }
                sb.append(" NOT NULL, ");
            }
            sb.append("PRIMARY KEY (`");
            sb.append(StringUtils.join(this.primaryKeys, (String)"`, `"));
            sb.append("`))");
            return sb.toString();
        }

        public String createSelectStatement(Collection fields) {
            for (Object f : fields) {
                if (this.columns.containsKey(f)) continue;
                throw new RuntimeException("Error in select statement.");
            }
            StringBuilder sb = new StringBuilder("SELECT `");
            sb.append(StringUtils.join((Iterable)fields, (String)"`, `"));
            sb.append("` FROM `");
            sb.append(this.name);
            sb.append("`");
            return sb.toString();
        }

        public String createSelectStatement(String[] fields) {
            return this.createSelectStatement(Arrays.asList(fields));
        }

        public String createSelectStatement() {
            StringBuilder sb = new StringBuilder("SELECT * FROM `");
            sb.append(this.name);
            sb.append("`");
            return sb.toString();
        }

        public String createInsertOrReplace(Map<String, Object> fieldsAndValues) {
            for (String f : fieldsAndValues.keySet()) {
                if (this.columns.containsKey(f)) continue;
                throw new RuntimeException("Error in select statement.");
            }
            StringBuilder sb = new StringBuilder();
            if (SQLProvider.this.dbType == EnumDBType.H2_FILE) {
                sb.append("MERGE INTO `");
            } else {
                sb.append("REPLACE INTO `");
            }
            sb.append(this.name);
            sb.append("` (`");
            sb.append(StringUtils.join(fieldsAndValues.keySet(), (String)"`, `"));
            sb.append("`) VALUES ('");
            sb.append(StringUtils.join(fieldsAndValues.values(), (String)"', '"));
            sb.append("')");
            return sb.toString();
        }

        public String createTruncate() {
            return "TRUNCATE TABLE `" + this.name + "`";
        }

        public List<Map<String, Object>> loadList() throws SQLException {
            ResultSet resultSet = SQLProvider.this.db.createStatement().executeQuery(this.createSelectStatement());
            ResultSetMetaData meta = resultSet.getMetaData();
            int columnsCount = meta.getColumnCount();
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            while (resultSet.next()) {
                HashMap<String, Object> row = new HashMap<String, Object>(columnsCount);
                for (int columnIndex = 1; columnIndex <= columnsCount; ++columnIndex) {
                    row.put(meta.getColumnName(columnIndex).toLowerCase(), resultSet.getObject(columnIndex));
                }
                list.add(row);
            }
            return list;
        }

        public Map<Integer, Map<String, Object>> loadIntMap(String key) throws SQLException {
            ResultSet resultSet = SQLProvider.this.db.createStatement().executeQuery(this.createSelectStatement());
            ResultSetMetaData meta = resultSet.getMetaData();
            int columnsCount = meta.getColumnCount();
            HashMap<Integer, Map<String, Object>> list = new HashMap<Integer, Map<String, Object>>();
            while (resultSet.next()) {
                HashMap<String, Object> row = new HashMap<String, Object>(columnsCount);
                for (int columnIndex = 1; columnIndex <= columnsCount; ++columnIndex) {
                    row.put(meta.getColumnName(columnIndex).toLowerCase(), resultSet.getObject(columnIndex));
                }
                list.put(resultSet.getInt(key), row);
            }
            return list;
        }

        public Map<String, String> loadMap(String key, String value) throws SQLException {
            ArrayList<String> fields = new ArrayList<String>();
            fields.add(key);
            fields.add(value);
            ResultSet resultSet = SQLProvider.this.db.createStatement().executeQuery(this.createSelectStatement(fields));
            HashMap<String, String> result = new HashMap<String, String>();
            while (resultSet.next()) {
                result.put(resultSet.getString(key), resultSet.getString(value));
            }
            return result;
        }
    }
}

