/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.permissions.persistence;

import com.forgeessentials.api.permissions.AreaZone;
import com.forgeessentials.api.permissions.GroupEntry;
import com.forgeessentials.api.permissions.ServerZone;
import com.forgeessentials.api.permissions.WorldZone;
import com.forgeessentials.api.permissions.Zone;
import com.forgeessentials.commons.selections.AreaBase;
import com.forgeessentials.commons.selections.AreaShape;
import com.forgeessentials.permissions.core.ZonePersistenceProvider;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.UserIdent;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JsonProvider
extends ZonePersistenceProvider {
    private File path;
    private Gson gson;

    public JsonProvider(File path) {
        this.path = new File(path, "/Permissions");
        this.gson = new GsonBuilder().disableHtmlEscaping().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();
    }

    @Override
    public ServerZone load() {
        ServerZone serverZone = new ServerZone();
        this.loadGroups(serverZone);
        this.loadUsers(serverZone);
        this.loadWorlds(serverZone);
        return serverZone;
    }

    private void loadGroups(ServerZone serverZone) {
        GroupsData groupsData = null;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.path + "/groups.json"));
            groupsData = (GroupsData)this.gson.fromJson((Reader)reader, GroupsData.class);
        }
        catch (IOException e) {
            OutputHandler.felog.severe("Could not load groups data: " + e.getMessage());
            return;
        }
        for (String group : groupsData.groups.keySet()) {
            GroupData groupData = groupsData.groups.get(group);
            Zone.PermissionList list = Zone.PermissionList.fromList(groupData.permissions);
            list.put("fe.internal.prefix", groupData.prefix);
            list.put("fe.internal.suffix", groupData.suffix);
            list.put("fe.internal.group.priority", Integer.toString(groupData.priority));
            list.put("fe.internal.group", "true");
            if (groupData.Default.booleanValue()) {
                list.put("fe.internal.group.default", "true");
            }
            serverZone.getOrCreateGroupPermissions(group).putAll(list);
        }
    }

    private void loadUsers(ServerZone serverZone) {
        UsersData usersData = null;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.path + "/users.json"));
            usersData = (UsersData)this.gson.fromJson((Reader)reader, UsersData.class);
        }
        catch (IOException e) {
            OutputHandler.felog.severe("Could not load groups data: " + e.getMessage());
            return;
        }
        for (String uuid : usersData.users.keySet()) {
            UserData userData = usersData.users.get(uuid);
            UserIdent ident = new UserIdent(uuid, userData.username);
            Zone.PermissionList list = Zone.PermissionList.fromList(userData.permissions);
            list.put("fe.internal.prefix", userData.prefix);
            list.put("fe.internal.suffix", userData.suffix);
            serverZone.getOrCreatePlayerPermissions(ident).putAll(list);
            for (String group : userData.groups) {
                serverZone.addPlayerToGroup(ident, group);
            }
        }
    }

    private void loadWorlds(ServerZone serverZone) {
        ArrayList<File> files = new ArrayList<File>();
        Path p = FileSystems.getDefault().getPath(this.path.getAbsolutePath(), new String[0]);
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(p, "world_*.json");){
            for (Path p2 : ds) {
                files.add(p2.toFile());
            }
        }
        catch (IOException e) {
            OutputHandler.felog.severe("Failed to get list of world files: " + e.getMessage());
        }
        for (File file : files) {
            WorldZoneData wzd = null;
            try {
                BufferedReader reader = new BufferedReader(new FileReader(file));
                wzd = (WorldZoneData)this.gson.fromJson((Reader)reader, WorldZoneData.class);
            }
            catch (IOException e) {
                OutputHandler.felog.severe(String.format("Failed to load world file &s: &s", file.getName(), e.getMessage()));
                return;
            }
            WorldZone wz = new WorldZone(serverZone, wzd.dimId, wzd.id);
            for (String group : wzd.groups.keySet()) {
                wz.getGroupPermissions().put(group, Zone.PermissionList.fromList(wzd.groups.get((Object)group).permissions));
            }
            for (String uuid : wzd.players.keySet()) {
                wz.getPlayerPermissions().put(new UserIdent(uuid, wzd.players.get((Object)uuid).username), Zone.PermissionList.fromList(wzd.players.get((Object)uuid).permissions));
            }
            for (AreaZoneData azd : wzd.zones) {
                AreaZone az = new AreaZone(wz, azd.name, azd.area, azd.id);
                az.setHidden(azd.hidden);
                az.setShape(azd.shape);
                az.setPriority(azd.priority);
                for (String group : azd.groups.keySet()) {
                    az.getGroupPermissions().put(group, Zone.PermissionList.fromList(azd.groups.get((Object)group).permissions));
                }
                for (String uuid : azd.players.keySet()) {
                    az.getPlayerPermissions().put(new UserIdent(uuid, azd.players.get((Object)uuid).username), Zone.PermissionList.fromList(azd.players.get((Object)uuid).permissions));
                }
            }
        }
    }

    @Override
    public void save(ServerZone serverZone) {
        this.path.mkdirs();
        this.saveGroups(serverZone);
        this.saveUsers(serverZone);
        this.saveWorlds(serverZone);
    }

    public void saveGroups(ServerZone zone) {
        GroupsData groupsData = new GroupsData();
        groupsData.groups.putAll(this.getGroupDataMap(zone, zone.getGroups()));
        String json = this.gson.toJson((Object)groupsData);
        try {
            FileWriter globalGroups = new FileWriter(new File(this.path + "/groups.json"));
            globalGroups.write(json);
            globalGroups.close();
        }
        catch (IOException e) {
            OutputHandler.felog.severe("Failed to save groups.json: " + e.getMessage());
        }
    }

    public void saveUsers(ServerZone serverZone) {
        File newPath = new File(this.path + "/users.json");
        UsersData usersData = new UsersData();
        usersData.users.putAll(this.getUserDataMap(serverZone, serverZone.getPlayerGroups().keySet()));
        String json = this.gson.toJson((Object)usersData);
        try {
            FileWriter writer = new FileWriter(newPath);
            writer.write(json);
            writer.close();
        }
        catch (IOException e) {
            OutputHandler.felog.severe("Failed to save users.json: " + e.getMessage());
        }
    }

    public void saveWorlds(ServerZone serverZone) {
        for (Map.Entry<Integer, WorldZone> wzEntry : serverZone.getWorldZones().entrySet()) {
            Integer wzDimId = wzEntry.getKey();
            WorldZone wz = wzEntry.getValue();
            String pathName = String.format("/world_%d.json", wzDimId);
            File newPath = new File(this.path + pathName);
            WorldZoneData worldZoneData = new WorldZoneData(wz.getId(), wzDimId);
            worldZoneData.groups.putAll(this.getGroupDataMap(wz, wz.getGroupPermissions().keySet()));
            worldZoneData.players.putAll(this.getUserDataMap(wz, wz.getPlayerPermissions().keySet()));
            for (AreaZone az : wz.getAreaZones()) {
                AreaZoneData areaZoneData = new AreaZoneData(az.getId(), az.getPriority(), az.isHidden(), az.getName(), az.getArea(), az.getShape());
                areaZoneData.groups.putAll(this.getGroupDataMap(az, az.getGroupPermissions().keySet()));
                areaZoneData.players.putAll(this.getUserDataMap(az, az.getPlayerPermissions().keySet()));
                worldZoneData.zones.add(areaZoneData);
            }
            String json = this.gson.toJson((Object)worldZoneData);
            try {
                FileWriter writer = new FileWriter(newPath);
                writer.write(json);
                writer.close();
            }
            catch (IOException e) {
                OutputHandler.felog.severe(String.format("Failed to save world_%d.json: %s", wzDimId, e.getMessage()));
            }
        }
    }

    private Map<String, GroupData> getGroupDataMap(Zone zone, Set<String> groups) {
        boolean global = zone instanceof ServerZone;
        HashMap<String, GroupData> groupDataMap = new HashMap<String, GroupData>();
        for (String group : groups) {
            String suffix;
            Zone.PermissionList groupList = new Zone.PermissionList(zone.getGroupPermissions(group));
            String prefix = (String)groupList.remove("fe.internal.prefix");
            if (prefix == null) {
                prefix = "";
            }
            if ((suffix = (String)groupList.remove("fe.internal.suffix")) == null) {
                suffix = "";
            }
            Boolean Default = Boolean.getBoolean((String)groupList.remove("fe.internal.group.default"));
            Integer priority = null;
            String prioNode = (String)groupList.remove("fe.internal.group.priority");
            if (prioNode != null) {
                priority = Integer.parseInt((String)groupList.remove("fe.internal.group.priority"));
            }
            groupList.remove("fe.internal.group");
            if (!global) {
                prefix = null;
                suffix = null;
                priority = null;
                Default = null;
            }
            List<String> list = groupList.toList();
            GroupData groupData = new GroupData(prefix, suffix, Default, priority);
            groupData.permissions.addAll(list);
            groupDataMap.put(group, groupData);
        }
        return groupDataMap;
    }

    private Map<String, UserData> getUserDataMap(Zone zone, Set<UserIdent> users) {
        boolean global = zone instanceof ServerZone;
        HashMap<String, UserData> userDataMap = new HashMap<String, UserData>();
        for (UserIdent user : users) {
            String suffix;
            String uuid = user.getUuid() == null ? null : user.getUuid().toString();
            String username = user.getUsername();
            Zone.PermissionList permList = new Zone.PermissionList(zone.getPlayerPermissions(user));
            String prefix = (String)permList.remove("fe.internal.prefix");
            if (prefix == null) {
                prefix = "";
            }
            if ((suffix = (String)permList.remove("fe.internal.suffix")) == null) {
                suffix = "";
            }
            if (uuid == null) {
                uuid = user.getUsername();
                username = null;
            }
            if (!global) {
                prefix = null;
                suffix = null;
            }
            List<String> list = permList.toList();
            UserData userData = new UserData(username, prefix, suffix);
            userData.permissions.addAll(list);
            if (global) {
                userData.groups.addAll(GroupEntry.toList(((ServerZone)zone).getPlayerGroups(user)));
            } else {
                userData.groups = null;
            }
            userDataMap.put(uuid, userData);
        }
        return userDataMap;
    }

    public static class UserData {
        public String username;
        public String prefix;
        public String suffix;
        public List<String> groups;
        public List<String> permissions;

        public UserData(String username, String prefix, String suffix) {
            this.username = username;
            this.prefix = prefix;
            this.suffix = suffix;
            this.groups = new ArrayList<String>();
            this.permissions = new ArrayList<String>();
        }
    }

    public static class UsersData {
        public Map<String, UserData> users = new HashMap<String, UserData>();
    }

    public static class AreaZoneData {
        public int id;
        public String name;
        public boolean hidden;
        public int priority;
        public Map<String, GroupData> groups;
        public Map<String, UserData> players;
        public AreaBase area;
        public AreaShape shape;

        public AreaZoneData(int id, int priority, boolean hidden, String name, AreaBase area, AreaShape shape) {
            this.id = id;
            this.priority = priority;
            this.hidden = hidden;
            this.name = name;
            this.area = area;
            this.shape = shape;
            this.groups = new HashMap<String, GroupData>();
            this.players = new HashMap<String, UserData>();
        }
    }

    public static class WorldZoneData {
        public int id;
        public int dimId;
        public List<AreaZoneData> zones;
        public Map<String, GroupData> groups;
        public Map<String, UserData> players;

        public WorldZoneData(int id, int dimId) {
            this.id = id;
            this.groups = new HashMap<String, GroupData>();
            this.players = new HashMap<String, UserData>();
            this.zones = new ArrayList<AreaZoneData>();
        }
    }

    public static class GroupMembers {
        public String name;
        public List<String> members;

        public GroupMembers(String name) {
            this.name = name;
            this.members = new ArrayList<String>();
        }
    }

    public static class GroupData {
        public String prefix;
        public String suffix;
        public Boolean Default;
        public Integer priority;
        public List<String> permissions;

        public GroupData(String prefix, String suffix, Boolean Default, Integer priority) {
            this.prefix = prefix;
            this.suffix = suffix;
            this.Default = Default;
            this.priority = priority;
            this.permissions = new ArrayList<String>();
        }
    }

    public static class GroupsData {
        public Map<String, GroupData> groups = new HashMap<String, GroupData>();
    }
}

