/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.permissions.persistence;

import com.forgeessentials.api.permissions.AreaZone;
import com.forgeessentials.api.permissions.ServerZone;
import com.forgeessentials.api.permissions.WorldZone;
import com.forgeessentials.api.permissions.Zone;
import com.forgeessentials.commons.selections.AreaBase;
import com.forgeessentials.commons.selections.AreaShape;
import com.forgeessentials.commons.selections.Point;
import com.forgeessentials.permissions.core.ZonePersistenceProvider;
import com.forgeessentials.permissions.persistence.FileFilters;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.UserIdent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.commons.io.FileUtils;

public class FlatfileProvider
extends ZonePersistenceProvider {
    public static final String PERMISSION_FILE_EXT = ".txt";
    private File basePath;
    public static final FileFilter permissionFilter = new FileFilters.Extension(".txt");
    public static final FileFilter directoryFilter = new FileFilters.Directory();
    public static final String COMMENT_INFO = "\nDO NOT MODIFY OR REMOVE fe.internal PERMISSIONS UNLESS YOU KNOW WHAT YOU DO!\nAfter you modified permissions in this file, remember to directly run \"/feperm reload\", or the changes get overwritten next time permissions are saved by the server.";

    public FlatfileProvider(File basePath) {
        this.basePath = basePath;
    }

    public static void deleteDirectory(File dir) {
        try {
            if (dir.exists()) {
                FileUtils.deleteDirectory((File)dir);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void save(ServerZone serverZone) {
        File path = this.basePath;
        FlatfileProvider.deleteDirectory(path);
        FlatfileProvider.writeUserGroupPermissions(serverZone);
        FlatfileProvider.saveServerZone(path, serverZone);
        FlatfileProvider.saveZonePermissions(path, serverZone);
        for (WorldZone worldZone : serverZone.getWorldZones().values()) {
            File worldPath = new File(path, worldZone.getName());
            FlatfileProvider.saveWorldZone(worldPath, worldZone);
            FlatfileProvider.saveZonePermissions(worldPath, worldZone);
            for (AreaZone areaZone : worldZone.getAreaZones()) {
                File areaPath = new File(worldPath, areaZone.getName());
                FlatfileProvider.saveAreaZone(areaPath, areaZone);
                FlatfileProvider.saveZonePermissions(areaPath, areaZone);
            }
        }
    }

    public static void saveServerZone(File path, ServerZone serverZone) {
        try {
            path.mkdirs();
            Properties p = new Properties();
            p.setProperty("id", Integer.toString(serverZone.getId()));
            p.setProperty("maxZoneId", Integer.toString(serverZone.getMaxZoneID()));
            p.storeToXML(new BufferedOutputStream(new FileOutputStream(new File(path, "server.xml"))), "Data of server");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveWorldZone(File path, WorldZone worldZone) {
        try {
            path.mkdirs();
            Properties p = new Properties();
            p.setProperty("id", Integer.toString(worldZone.getId()));
            p.setProperty("dimId", Integer.toString(worldZone.getDimensionID()));
            p.storeToXML(new BufferedOutputStream(new FileOutputStream(new File(path, "world.xml"))), "Data of world " + worldZone.getName());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveAreaZone(File path, AreaZone areaZone) {
        try {
            path.mkdirs();
            Properties p = new Properties();
            p.setProperty("id", Integer.toString(areaZone.getId()));
            p.setProperty("name", areaZone.getName());
            p.setProperty("x1", Integer.toString(areaZone.getArea().getLowPoint().getX()));
            p.setProperty("y1", Integer.toString(areaZone.getArea().getLowPoint().getY()));
            p.setProperty("z1", Integer.toString(areaZone.getArea().getLowPoint().getZ()));
            p.setProperty("x2", Integer.toString(areaZone.getArea().getHighPoint().getX()));
            p.setProperty("y2", Integer.toString(areaZone.getArea().getHighPoint().getY()));
            p.setProperty("z2", Integer.toString(areaZone.getArea().getHighPoint().getZ()));
            p.setProperty("shape", areaZone.getShape().toString());
            p.storeToXML(new BufferedOutputStream(new FileOutputStream(new File(path, "area.xml"))), "Data of area " + areaZone.getName());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveZonePermissions(File path, Zone zone) {
        File playersPath = new File(path, "players");
        File groupsPath = new File(path, "groups");
        for (Map.Entry<UserIdent, Zone.PermissionList> entry : zone.getPlayerPermissions().entrySet()) {
            String username = entry.getKey().getUsername() == null ? entry.getKey().getUuid().toString() : entry.getKey().getUsername();
            UUID uuid = entry.getKey().getUuid();
            String filename = username == null ? uuid.toString() : username;
            String comment = "Permissions for user " + (username != null ? username : "<unknown-username>") + " with UUID " + (uuid != null ? uuid.toString() : "<unknown-uuid>") + COMMENT_INFO;
            filename = filename.replaceAll("[^a-zA-Z0-9\\.\\-]", "_");
            while (new File(playersPath, filename + PERMISSION_FILE_EXT).exists()) {
                filename = filename + "_";
            }
            Properties p = FlatfileProvider.permissionListToProperties(entry.getValue());
            if (entry.getKey().getUsername() != null) {
                p.setProperty("fe.internal.player.name", entry.getKey().getUsername());
            }
            if (entry.getKey().getUuid() != null) {
                p.setProperty("fe.internal.player.uuid", entry.getKey().getUuid().toString());
            }
            FlatfileProvider.saveProperties(p, playersPath, filename + PERMISSION_FILE_EXT, comment);
        }
        for (Map.Entry<Object, Zone.PermissionList> entry : zone.getGroupPermissions().entrySet()) {
            String comment = "Permissions for group " + (String)entry.getKey() + COMMENT_INFO;
            Properties p = FlatfileProvider.permissionListToProperties(entry.getValue());
            FlatfileProvider.saveProperties(p, groupsPath, (String)entry.getKey() + PERMISSION_FILE_EXT, comment);
        }
    }

    public static Properties permissionListToProperties(Zone.PermissionList list) {
        SortedPermisssionProperties p = new SortedPermisssionProperties();
        for (Map.Entry permission : list.entrySet()) {
            p.setProperty((String)permission.getKey(), permission.getValue() != null ? (String)permission.getValue() : "");
        }
        return p;
    }

    public static void saveProperties(Properties properties, File path, String filename, String comment) {
        try {
            path.mkdirs();
            properties.store(new BufferedOutputStream(new FileOutputStream(new File(path, filename))), comment);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public ServerZone load() {
        File path = this.basePath;
        try {
            ServerZone serverZone = new ServerZone();
            FlatfileProvider.loadZonePermissions(path, serverZone);
            FlatfileProvider.readUserGroupPermissions(serverZone);
            int maxId = 2;
            File[] worldDirs = path.listFiles(directoryFilter);
            if (worldDirs == null) {
                OutputHandler.felog.severe("Error loading permissions: invalid path");
                return null;
            }
            for (File worldPath : worldDirs) {
                try {
                    File worldFile = new File(worldPath, "world.xml");
                    if (!worldFile.exists()) continue;
                    Properties worldProperties = new Properties();
                    worldProperties.loadFromXML(new BufferedInputStream(new FileInputStream(worldFile)));
                    int worldId = Integer.parseInt(worldProperties.getProperty("id"));
                    maxId = Math.max(maxId, worldId);
                    int dimensionID = Integer.parseInt(worldProperties.getProperty("dimId"));
                    WorldZone worldZone = new WorldZone(serverZone, dimensionID, worldId);
                    FlatfileProvider.loadZonePermissions(worldPath, worldZone);
                    for (File areaPath : worldPath.listFiles(directoryFilter)) {
                        try {
                            File areaFile = new File(areaPath, "area.xml");
                            if (!areaFile.exists()) continue;
                            Properties areaProperties = new Properties();
                            areaProperties.loadFromXML(new BufferedInputStream(new FileInputStream(areaFile)));
                            int areaId = Integer.parseInt(areaProperties.getProperty("id"));
                            maxId = Math.max(maxId, areaId);
                            String name = areaProperties.getProperty("name");
                            int x1 = Integer.parseInt(areaProperties.getProperty("x1"));
                            int y1 = Integer.parseInt(areaProperties.getProperty("y1"));
                            int z1 = Integer.parseInt(areaProperties.getProperty("z1"));
                            int x2 = Integer.parseInt(areaProperties.getProperty("x2"));
                            int y2 = Integer.parseInt(areaProperties.getProperty("y2"));
                            int z2 = Integer.parseInt(areaProperties.getProperty("z2"));
                            AreaShape shape = AreaShape.getByName(areaProperties.getProperty("shape"));
                            if (name == null) {
                                throw new IllegalArgumentException();
                            }
                            AreaZone areaZone = new AreaZone(worldZone, name, new AreaBase(new Point(x1, y1, z1), new Point(x2, y2, z2)), areaId);
                            if (shape != null) {
                                areaZone.setShape(shape);
                            }
                            FlatfileProvider.loadZonePermissions(areaPath, areaZone);
                        }
                        catch (IOException | IllegalArgumentException e) {
                            OutputHandler.felog.severe("Error reading area " + worldPath.getName() + "/" + areaPath.getName());
                        }
                    }
                }
                catch (IOException | NumberFormatException e) {
                    OutputHandler.felog.severe("Error reading world " + worldPath.getName());
                }
            }
            File serverFile = new File(path, "server.xml");
            if (serverFile.exists()) {
                try {
                    Properties serverProperties = new Properties();
                    serverProperties.loadFromXML(new BufferedInputStream(new FileInputStream(serverFile)));
                    serverZone.setMaxZoneId(Integer.parseInt(serverProperties.getProperty("maxZoneId")));
                }
                catch (IOException | IllegalArgumentException e) {
                    OutputHandler.felog.severe("Error reading server data " + serverFile.getName());
                    serverZone.setMaxZoneId(maxId);
                }
            } else {
                serverZone.setMaxZoneId(maxId);
            }
            return serverZone;
        }
        catch (Exception e) {
            OutputHandler.felog.severe("Error loading permissions");
            e.printStackTrace();
            return null;
        }
    }

    public static void loadZonePermissions(File path, Zone zone) {
        Properties p;
        File playersPath = new File(path, "players");
        File groupsPath = new File(path, "groups");
        if (playersPath.exists()) {
            for (File file : playersPath.listFiles(permissionFilter)) {
                try {
                    p = new Properties();
                    p.load(new BufferedInputStream(new FileInputStream(file)));
                    String username = p.getProperty("fe.internal.player.name");
                    String uuid = p.getProperty("fe.internal.player.uuid");
                    p.remove("fe.internal.player.name");
                    p.remove("fe.internal.player.uuid");
                    if (username == null && uuid == null) {
                        OutputHandler.felog.severe("User identification missing in " + path.getAbsolutePath());
                        continue;
                    }
                    UserIdent ident = new UserIdent(uuid, username);
                    Zone.PermissionList permissions = zone.getOrCreatePlayerPermissions(ident);
                    for (Map.Entry<Object, Object> permission : p.entrySet()) {
                        permissions.put((String)permission.getKey(), (String)permission.getValue());
                    }
                }
                catch (IOException | IllegalArgumentException e) {
                    OutputHandler.felog.severe("Error reading permissions from " + path.getAbsolutePath());
                }
            }
        }
        if (groupsPath.exists()) {
            for (File file : groupsPath.listFiles(permissionFilter)) {
                try {
                    p = new Properties();
                    p.load(new BufferedInputStream(new FileInputStream(file)));
                    String groupName = file.getName().substring(0, file.getName().length() - PERMISSION_FILE_EXT.length());
                    Zone.PermissionList permissions = zone.getOrCreateGroupPermissions(groupName);
                    for (Map.Entry<Object, Object> permission : p.entrySet()) {
                        permissions.put((String)permission.getKey(), (String)permission.getValue());
                    }
                }
                catch (IOException | IllegalArgumentException e) {
                    OutputHandler.felog.severe("Error reading permissions from " + path.getAbsolutePath());
                }
            }
        }
    }

    public static class SortedPermisssionProperties
    extends Properties {
        private static final long serialVersionUID = 1L;

        @Override
        public synchronized Enumeration<Object> keys() {
            TreeSet<Object> keys = new TreeSet<Object>(Zone.permissionComparator);
            keys.addAll(super.keySet());
            return Collections.enumeration(keys);
        }
    }
}

