/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.permissions.core;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.api.permissions.GroupEntry;
import com.forgeessentials.api.permissions.IPermissionsHelper;
import com.forgeessentials.api.permissions.PermissionEvent;
import com.forgeessentials.api.permissions.RootZone;
import com.forgeessentials.api.permissions.ServerZone;
import com.forgeessentials.api.permissions.WorldZone;
import com.forgeessentials.api.permissions.Zone;
import com.forgeessentials.commons.selections.Point;
import com.forgeessentials.commons.selections.WarpPoint;
import com.forgeessentials.commons.selections.WorldArea;
import com.forgeessentials.commons.selections.WorldPoint;
import com.forgeessentials.core.ForgeEssentials;
import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.permissions.core.PermissionsListWriter;
import com.forgeessentials.permissions.core.ZonePersistenceProvider;
import com.forgeessentials.util.FunctionHelper;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.UserIdent;
import com.forgeessentials.util.events.PlayerChangedZone;
import com.forgeessentials.util.events.PlayerMoveEvent;
import com.forgeessentials.util.events.ServerEventHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fe.server.CommandHandlerForge;
import net.minecraftforge.permissions.IContext;
import net.minecraftforge.permissions.PermissionsManager;

public class ZonedPermissionHelper
extends ServerEventHandler
implements IPermissionsHelper,
ServerZone.PermissionDebugger {
    public static final String PERMISSIONS_LIST_FILE = "PermissionsList.txt";
    protected RootZone rootZone;
    protected ZonePersistenceProvider persistenceProvider;
    protected Timer persistenceTimer;
    protected boolean dirty = true;
    protected boolean registeredPermission = true;
    public Set<ICommandSender> permissionDebugUsers = new HashSet<ICommandSender>();
    public List<String> permissionDebugFilters = new ArrayList<String>();

    public ZonedPermissionHelper() {
        this.rootZone = new RootZone(this);
        this.rootZone.setPermissionDebugger(this);
        ServerZone serverZone = new ServerZone(this.rootZone);
        APIRegistry.getFEEventBus().post((Event)new PermissionEvent.AfterLoad(serverZone));
        this.rootZone.setServerZone(serverZone);
        this.permissionDebugFilters.add("fe.protection.mobspawn");
        this.permissionDebugFilters.add("fe.protection.gamemode");
        this.permissionDebugFilters.add("worldedit.limit.unrestricted");
    }

    public void setPersistenceProvider(ZonePersistenceProvider persistenceProvider) {
        this.persistenceProvider = persistenceProvider;
    }

    public void save() {
        if (this.persistenceProvider != null) {
            OutputHandler.felog.info("Saving permissions...");
            APIRegistry.getFEEventBus().post((Event)new PermissionEvent.BeforeSave(this.rootZone.getServerZone()));
            this.persistenceProvider.save(this.rootZone.getServerZone());
        }
        if (this.registeredPermission) {
            PermissionsListWriter.write(this.getRegisteredPermissions(), new File(ForgeEssentials.getFEDirectory(), PERMISSIONS_LIST_FILE));
        }
        this.dirty = false;
        this.registeredPermission = false;
    }

    public boolean load() {
        ServerZone serverZone;
        if (this.persistenceProvider != null && (serverZone = this.persistenceProvider.load()) != null) {
            this.rootZone.setServerZone(serverZone);
            serverZone.rebuildZonesMap();
            serverZone.updatePlayerIdents();
            this.dirty = false;
            APIRegistry.getFEEventBus().post((Event)new PermissionEvent.AfterLoad(serverZone));
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean registeredPermission) {
        this.dirty = true;
        this.registeredPermission |= registeredPermission;
        if (this.persistenceTimer != null) {
            this.persistenceTimer.cancel();
        }
        this.persistenceTimer = new Timer("permission persistence timer", true);
        this.persistenceTimer.schedule((TimerTask)new PersistenceTask(), 2000L);
    }

    public Zone.PermissionList getRegisteredPermissions() {
        Zone.PermissionList perms = (Zone.PermissionList)this.rootZone.getGroupPermissions("_ALL_").clone();
        for (Map.Entry perm : this.rootZone.getGroupPermissions("_OPS_").entrySet()) {
            perms.put(perm.getKey(), perm.getValue());
        }
        return perms;
    }

    public Set<String> enumRegisteredPermissions() {
        TreeSet<String> perms = new TreeSet<String>();
        for (String perm : this.rootZone.getGroupPermissions("_ALL_").keySet()) {
            if (perm.endsWith(".$desc")) continue;
            perms.add(perm);
        }
        return perms;
    }

    public Set<String> enumAllPermissions() {
        TreeSet<String> perms = new TreeSet<String>();
        for (Zone zone : this.getZones()) {
            for (Map map : zone.getGroupPermissions().values()) {
                for (String perm : map.keySet()) {
                    if (perm.endsWith(".$desc")) continue;
                    perms.add(perm);
                }
            }
            for (Map map : zone.getPlayerPermissions().values()) {
                for (String perm : map.keySet()) {
                    if (perm.endsWith(".$desc")) continue;
                    perms.add(perm);
                }
            }
        }
        return perms;
    }

    public Map<Zone, Map<String, String>> enumUserPermissions(UserIdent ident) {
        HashMap<Zone, Map<String, String>> result = new HashMap<Zone, Map<String, String>>();
        for (Zone zone : this.getZones()) {
            if (zone.getPlayerPermissions(ident) == null) continue;
            TreeMap<String, String> zonePerms = new TreeMap<String, String>();
            zonePerms.putAll(zone.getPlayerPermissions(ident));
            result.put(zone, zonePerms);
        }
        return result;
    }

    public Map<Zone, Map<String, String>> enumGroupPermissions(String group, boolean enumRootPermissions) {
        HashMap<Zone, Map<String, String>> result = new HashMap<Zone, Map<String, String>>();
        for (Zone zone : this.getZones()) {
            if (!enumRootPermissions && zone instanceof RootZone || zone.getGroupPermissions(group) == null) continue;
            TreeMap<String, String> zonePerms = new TreeMap<String, String>();
            zonePerms.putAll(zone.getGroupPermissions(group));
            result.put(zone, zonePerms);
        }
        return result;
    }

    @Override
    public void debugPermission(Zone zone, UserIdent ident, String group, String permissionNode, String node, String value) {
        for (String filter : this.permissionDebugFilters) {
            if (!node.startsWith(filter)) continue;
            return;
        }
        String msg1 = String.format("\u00a7b%s\u00a7f = \u00a7%s%s", permissionNode, "false".equals(value) ? "4" : "2", value);
        String msg2 = zone == null ? "\u00a74  permission not set" : (ident == null ? String.format("\u00a7f  zone [\u00a75%s\u00a7f] group [\u00a75%s\u00a7f]", zone.getName(), group) : String.format("\u00a7f  zone [\u00a75%s\u00a7f] user [\u00a75%s\u00a7f]", zone.getName(), ident.getUsernameOrUUID()));
        for (ICommandSender sender : this.permissionDebugUsers) {
            OutputHandler.chatNotification(sender, msg1);
            OutputHandler.chatNotification(sender, msg2);
        }
    }

    @SubscribeEvent
    public void permissionAfterLoadEvent(PermissionEvent.AfterLoad e) {
        if (!e.serverZone.groupExists("_ALL_")) {
            e.serverZone.setGroupPermission("_ALL_", "fe.internal.group", true);
            e.serverZone.setGroupPermissionProperty("_ALL_", "fe.internal.group.priority", "0");
        }
        if (!e.serverZone.groupExists("_GUESTS_")) {
            e.serverZone.setGroupPermission("_GUESTS_", "fe.internal.group", true);
            e.serverZone.setGroupPermissionProperty("_GUESTS_", "fe.internal.group.priority", "10");
            e.serverZone.setGroupPermissionProperty("_GUESTS_", "fe.internal.prefix", "[GUEST]");
        }
        if (!e.serverZone.groupExists("_OPS_")) {
            e.serverZone.setGroupPermission("_OPS_", "fe.internal.group", true);
            e.serverZone.setGroupPermissionProperty("_OPS_", "fe.internal.group.priority", "50");
            e.serverZone.setGroupPermissionProperty("_OPS_", "fe.internal.prefix", "[OPERATOR]");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void playerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        for (Zone zone : this.getZones()) {
            zone.updatePlayerIdents();
        }
        UserIdent ident = new UserIdent(e.player);
        if (this.getServerZone().getPlayerPermissions(ident) == null || this.getServerZone().getPlayerPermissions(ident).size() == 0) {
            this.getServerZone().setPlayerPermission(ident, "fe.internal.player.known", true);
        } else {
            this.getServerZone().clearPlayerPermission(ident, "fe.internal.player.known");
        }
        WarpPoint point = new WarpPoint((Entity)e.player);
        Zone zone = APIRegistry.perms.getServerZone().getZonesAt(point.toWorldPoint()).get(0);
        PlayerChangedZone event = new PlayerChangedZone(e.player, zone, zone, point, point);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    @SubscribeEvent
    public void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent e) {
        this.permissionDebugUsers.remove(e.player);
    }

    @SubscribeEvent
    public void worldLoad(WorldEvent.Load e) {
        this.getServerZone().getWorldZone(e.world.field_73011_w.field_76574_g);
    }

    @SubscribeEvent
    public void playerMoveEvent(PlayerMoveEvent e) {
        Zone after;
        Zone before;
        if (!e.isCanceled() && !(before = APIRegistry.perms.getServerZone().getZonesAt(e.before.toWorldPoint()).get(0)).equals(after = APIRegistry.perms.getServerZone().getZonesAt(e.after.toWorldPoint()).get(0))) {
            PlayerChangedZone event = new PlayerChangedZone(e.entityPlayer, before, after, e.before, e.after);
            e.setCanceled(MinecraftForge.EVENT_BUS.post((Event)event));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void playerChangedZoneEvent(PlayerChangedZone event) {
        String entryMsg;
        UserIdent ident = new UserIdent(event.entityPlayer);
        String exitMsg = APIRegistry.perms.getUserPermissionProperty(ident, event.beforeZone, "fe.internal.zone.exit");
        if (exitMsg != null) {
            OutputHandler.sendMessage((ICommandSender)event.entityPlayer, FunctionHelper.formatColors(exitMsg));
        }
        if ((entryMsg = APIRegistry.perms.getUserPermissionProperty(ident, event.afterZone, "fe.internal.zone.entry")) != null) {
            OutputHandler.sendMessage((ICommandSender)event.entityPlayer, FunctionHelper.formatColors(entryMsg));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void checkCommandPerm(CommandEvent e) {
        if (!(e.command instanceof ForgeEssentialsCommandBase) && e.sender instanceof EntityPlayer && !CommandHandlerForge.canUse(e.command, e.sender)) {
            e.setCanceled(true);
            ZonedPermissionHelper.permissionDeniedMessage(e.sender);
        }
    }

    public static void permissionDeniedMessage(ICommandSender sender) {
        ChatComponentTranslation msg = new ChatComponentTranslation("commands.generic.permission", new Object[0]);
        msg.func_150256_b().func_150238_a(EnumChatFormatting.RED);
        sender.func_145747_a((IChatComponent)msg);
    }

    @Override
    public String getPermission(UserIdent ident, WorldPoint point, WorldArea area, Collection<String> groups, String permissionNode, boolean isProperty) {
        WorldZone worldZone = null;
        if (point != null) {
            worldZone = this.getServerZone().getWorldZone(point.getDimension());
        } else if (area != null) {
            worldZone = this.getServerZone().getWorldZone(area.getDimension());
        }
        ArrayList<Zone> zones = new ArrayList<Zone>();
        if (worldZone != null) {
            for (Zone zone : worldZone.getAreaZones()) {
                if ((point == null || !zone.isInZone(point)) && (area == null || !zone.isInZone(area))) continue;
                zones.add(zone);
            }
            zones.add(worldZone);
        }
        zones.add(this.rootZone.getServerZone());
        zones.add(this.rootZone);
        return this.getServerZone().getPermission(zones, ident, groups, permissionNode, isProperty);
    }

    @Override
    public void registerPermissionProperty(String permissionNode, String defaultValue) {
        this.rootZone.setGroupPermissionProperty("_ALL_", permissionNode, defaultValue);
    }

    @Override
    public void registerPermissionPropertyOp(String permissionNode, String defaultValue) {
        this.rootZone.setGroupPermissionProperty("_OPS_", permissionNode, defaultValue);
    }

    @Override
    public void registerPermission(String permissionNode, PermissionsManager.RegisteredPermValue permLevel) {
        if (permLevel == PermissionsManager.RegisteredPermValue.FALSE) {
            this.rootZone.setGroupPermission("_ALL_", permissionNode, false);
        } else if (permLevel == PermissionsManager.RegisteredPermValue.TRUE) {
            this.rootZone.setGroupPermission("_ALL_", permissionNode, true);
        } else if (permLevel == PermissionsManager.RegisteredPermValue.OP) {
            this.rootZone.setGroupPermission("_ALL_", permissionNode, false);
            this.rootZone.setGroupPermission("_OPS_", permissionNode, true);
        }
    }

    @Override
    public void registerPermissionDescription(String permissionNode, String description) {
        this.registerPermissionProperty(permissionNode + ".$desc", description);
    }

    @Override
    public void registerPermission(String permissionNode, PermissionsManager.RegisteredPermValue level, String description) {
        this.registerPermission(permissionNode, level);
        this.registerPermissionDescription(permissionNode, description);
    }

    @Override
    public void registerPermissionProperty(String permissionNode, String defaultValue, String description) {
        this.registerPermissionProperty(permissionNode, defaultValue);
        this.registerPermissionDescription(permissionNode, description);
    }

    @Override
    public void registerPermissionPropertyOp(String permissionNode, String defaultValue, String description) {
        this.registerPermissionPropertyOp(permissionNode, defaultValue);
        this.registerPermissionDescription(permissionNode, description);
    }

    @Override
    public void setPlayerPermission(UserIdent ident, String permissionNode, boolean value) {
        this.getServerZone().setPlayerPermission(ident, permissionNode, value);
    }

    @Override
    public void setPlayerPermissionProperty(UserIdent ident, String permissionNode, String value) {
        this.getServerZone().setPlayerPermissionProperty(ident, permissionNode, value);
    }

    @Override
    public void setGroupPermission(String group, String permissionNode, boolean value) {
        this.getServerZone().setGroupPermission(group, permissionNode, value);
    }

    @Override
    public void setGroupPermissionProperty(String group, String permissionNode, String value) {
        this.getServerZone().setGroupPermissionProperty(group, permissionNode, value);
    }

    @Override
    public String getPermissionDescription(String permissionNode) {
        return this.rootZone.getGroupPermission("_ALL_", permissionNode + ".$desc");
    }

    protected static EntityPlayer contextGetPlayerOrCommandPlayer(IContext context) {
        return context.getPlayer() != null ? context.getPlayer() : (context.getCommandSender() instanceof EntityPlayer ? (EntityPlayer)context.getCommandSender() : null);
    }

    protected static boolean contextIsConsole(IContext context) {
        return context.getPlayer() == null && context.getCommandSender() != null && !(context.getCommandSender() instanceof EntityPlayer);
    }

    protected static boolean contextIsPlayer(IContext context) {
        return context.getPlayer() != null || context.getCommandSender() instanceof EntityPlayer;
    }

    @Override
    public boolean checkPermission(IContext context, String permissionNode) {
        if (ZonedPermissionHelper.contextIsConsole(context)) {
            return true;
        }
        UserIdent ident = null;
        EntityPlayer player = ZonedPermissionHelper.contextGetPlayerOrCommandPlayer(context);
        WorldPoint loc = null;
        WorldArea area = null;
        int dim = 0;
        if (player != null) {
            ident = new UserIdent(player);
            dim = player.field_71093_bK;
        }
        if (context.getTargetLocationStart() != null) {
            if (context.getTargetLocationEnd() != null) {
                area = new WorldArea(dim, new Point(context.getTargetLocationStart()), new Point(context.getTargetLocationEnd()));
            } else {
                loc = new WorldPoint(dim, context.getTargetLocationStart());
            }
        } else if (context.getSourceLocationStart() != null) {
            if (context.getSourceLocationEnd() != null) {
                area = new WorldArea(dim, new Point(context.getSourceLocationStart()), new Point(context.getSourceLocationEnd()));
            } else {
                loc = new WorldPoint(dim, context.getSourceLocationStart());
            }
        } else if (player != null) {
            loc = new WorldPoint((Entity)player);
        }
        return this.checkBooleanPermission(this.getPermission(ident, loc, area, GroupEntry.toList(this.getPlayerGroups(ident)), permissionNode, false));
    }

    @Override
    public Collection<Zone> getZones() {
        return this.getServerZone().getZones();
    }

    @Override
    public Zone getZoneById(int id) {
        return this.getServerZone().getZoneMap().get(id);
    }

    @Override
    public Zone getZoneById(String id) {
        try {
            return this.getServerZone().getZoneMap().get(Integer.parseInt(id));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public RootZone getRootZone() {
        return this.rootZone;
    }

    @Override
    public ServerZone getServerZone() {
        return this.getRootZone().getServerZone();
    }

    public Collection<Zone> getGlobalZones() {
        ArrayList<Zone> zones = new ArrayList<Zone>();
        zones.add(this.rootZone.getServerZone());
        zones.add(this.rootZone);
        return zones;
    }

    public Collection<Zone> getGlobalZones(Zone firstZone) {
        ArrayList<Zone> zones = new ArrayList<Zone>();
        if (firstZone != null) {
            zones.add(firstZone);
        }
        zones.add(this.rootZone.getServerZone());
        zones.add(this.rootZone);
        return zones;
    }

    @Override
    public boolean isSystemGroup(String group) {
        return group.equals("_ALL_") || group.equals("_OPS_") || group.equals("_GUESTS_");
    }

    @Override
    public boolean groupExists(String name) {
        return this.getServerZone().getGroupPermissions().containsKey(name);
    }

    @Override
    public boolean createGroup(String name) {
        return this.getServerZone().createGroup(name);
    }

    @Override
    public void addPlayerToGroup(UserIdent ident, String group) {
        this.getServerZone().addPlayerToGroup(ident, group);
    }

    @Override
    public void removePlayerFromGroup(UserIdent ident, String group) {
        this.getServerZone().removePlayerFromGroup(ident, group);
    }

    @Override
    public String getPrimaryGroup(UserIdent ident) {
        return this.getServerZone().getPrimaryPlayerGroup(ident);
    }

    @Override
    public SortedSet<GroupEntry> getPlayerGroups(UserIdent ident) {
        return this.getServerZone().getPlayerGroups(ident);
    }

    @Override
    public SortedSet<GroupEntry> getStoredPlayerGroups(UserIdent ident) {
        return this.getServerZone().getStoredPlayerGroups(ident);
    }

    protected boolean checkBooleanPermission(String permissionValue) {
        if (permissionValue == null) {
            return true;
        }
        return !permissionValue.equals("false");
    }

    @Override
    public boolean checkPermission(EntityPlayer player, String permissionNode) {
        UserIdent ident = new UserIdent(player);
        return this.checkBooleanPermission(this.getPermission(ident, new WorldPoint((Entity)player), null, GroupEntry.toList(this.getPlayerGroups(ident)), permissionNode, false));
    }

    @Override
    public String getPermissionProperty(EntityPlayer player, String permissionNode) {
        UserIdent ident = new UserIdent(player);
        return this.getPermission(ident, new WorldPoint((Entity)player), null, GroupEntry.toList(this.getPlayerGroups(ident)), permissionNode, true);
    }

    @Override
    public boolean checkUserPermission(UserIdent ident, String permissionNode) {
        return this.checkBooleanPermission(this.getPermission(ident, ident != null && ident.hasPlayer() ? new WorldPoint((Entity)ident.getPlayer()) : null, null, GroupEntry.toList(this.getPlayerGroups(ident)), permissionNode, false));
    }

    @Override
    public String getUserPermissionProperty(UserIdent ident, String permissionNode) {
        return this.getPermission(ident, ident.hasPlayer() ? new WorldPoint((Entity)ident.getPlayer()) : null, null, GroupEntry.toList(this.getPlayerGroups(ident)), permissionNode, true);
    }

    @Override
    public Integer getUserPermissionPropertyInt(UserIdent ident, String permissionNode) {
        String value = this.getUserPermissionProperty(ident, permissionNode);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public boolean checkUserPermission(UserIdent ident, WorldPoint targetPoint, String permissionNode) {
        return this.checkBooleanPermission(this.getPermission(ident, targetPoint, null, GroupEntry.toList(this.getPlayerGroups(ident)), permissionNode, false));
    }

    @Override
    public String getUserPermissionProperty(UserIdent ident, WorldPoint targetPoint, String permissionNode) {
        return this.getPermission(ident, targetPoint, null, GroupEntry.toList(this.getPlayerGroups(ident)), permissionNode, true);
    }

    @Override
    public boolean checkUserPermission(UserIdent ident, WorldArea targetArea, String permissionNode) {
        return this.checkBooleanPermission(this.getPermission(ident, null, targetArea, GroupEntry.toList(this.getPlayerGroups(ident)), permissionNode, false));
    }

    @Override
    public String getUserPermissionProperty(UserIdent ident, WorldArea targetArea, String permissionNode) {
        return this.getPermission(ident, null, targetArea, GroupEntry.toList(this.getPlayerGroups(ident)), permissionNode, true);
    }

    @Override
    public boolean checkUserPermission(UserIdent ident, Zone zone, String permissionNode) {
        return this.checkBooleanPermission(this.getServerZone().getPermission(this.getGlobalZones(zone), ident, GroupEntry.toList(this.getPlayerGroups(ident)), permissionNode, false));
    }

    @Override
    public String getUserPermissionProperty(UserIdent ident, Zone zone, String permissionNode) {
        return this.getServerZone().getPermission(this.getGlobalZones(zone), ident, GroupEntry.toList(this.getPlayerGroups(ident)), permissionNode, true);
    }

    @Override
    public String getGroupPermissionProperty(String group, String permissionNode) {
        return this.getServerZone().getPermission(this.getGlobalZones(), null, Arrays.asList(group), permissionNode, true);
    }

    @Override
    public String getGroupPermissionProperty(String group, Zone zone, String permissionNode) {
        return this.getServerZone().getPermission(this.getGlobalZones(zone), null, Arrays.asList(group), permissionNode, true);
    }

    @Override
    public boolean checkGroupPermission(String group, String permissionNode) {
        return this.checkBooleanPermission(this.getServerZone().getPermission(this.getGlobalZones(), null, Arrays.asList(group), permissionNode, false));
    }

    @Override
    public boolean checkGroupPermission(String group, Zone zone, String permissionNode) {
        return this.checkBooleanPermission(this.getServerZone().getPermission(this.getGlobalZones(zone), null, Arrays.asList(group), permissionNode, false));
    }

    @Override
    public String getGroupPermissionProperty(String group, WorldPoint point, String permissionNode) {
        return this.getServerZone().getPermission(this.getServerZone().getZonesAt(point), null, Arrays.asList(group), permissionNode, true);
    }

    @Override
    public boolean checkGroupPermission(String group, WorldPoint point, String permissionNode) {
        return this.checkBooleanPermission(this.getServerZone().getPermission(this.getServerZone().getZonesAt(point), null, Arrays.asList(group), permissionNode, false));
    }

    @Override
    public String getGlobalPermissionProperty(String permissionNode) {
        return this.getGroupPermissionProperty("_ALL_", permissionNode);
    }

    @Override
    public String getGlobalPermissionProperty(Zone zone, String permissionNode) {
        return this.getGroupPermissionProperty("_ALL_", zone, permissionNode);
    }

    @Override
    public boolean checkGlobalPermission(String permissionNode) {
        return this.checkGroupPermission("_ALL_", permissionNode);
    }

    @Override
    public boolean checkGlobalPermission(Zone zone, String permissionNode) {
        return this.checkGroupPermission("_ALL_", zone, permissionNode);
    }

    class PersistenceTask
    extends TimerTask {
        PersistenceTask() {
        }

        @Override
        public void run() {
            if (ZonedPermissionHelper.this.persistenceProvider == null) {
                return;
            }
            if (ZonedPermissionHelper.this.dirty) {
                ZonedPermissionHelper.this.save();
            }
        }
    }
}

