/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.permissions.core;

import com.forgeessentials.api.permissions.Zone;
import com.forgeessentials.util.FunctionHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.TreeSet;

public final class PermissionsListWriter {
    private static final String NEW_LINE = System.getProperty("line.separator");

    public static void write(Zone.PermissionList permissions, File output) {
        TreeSet sortedPerms = new TreeSet(permissions.keySet());
        int permCount = 0;
        int permNameLength = 0;
        for (String perm : sortedPerms) {
            if (perm.endsWith(".$desc")) continue;
            ++permCount;
            permNameLength = Math.max(permNameLength, perm.length());
        }
        permNameLength += 2;
        try {
            output.createNewFile();
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(output));){
                writer.write("#// ------------ PERMISSIONS LIST ------------ \\\\#");
                writer.newLine();
                writer.write("#// --------------- " + FunctionHelper.getCurrentDateString() + " --------------- \\\\#");
                writer.newLine();
                writer.write("#// ------------ Total amount: " + permCount + " ------------ \\\\#");
                writer.newLine();
                writer.write("#// ------------------------------------------ \\\\#");
                writer.newLine();
                int lastPermLength = 0;
                for (String perm : sortedPerms) {
                    String value = (String)permissions.get(perm);
                    if (value == null) {
                        value = "";
                    }
                    if (perm.endsWith(".$desc")) {
                        StringBuffer sb = new StringBuffer();
                        String parentPerm = perm.substring(0, perm.length() - ".$desc".length());
                        if (!permissions.containsKey(parentPerm)) {
                            sb.append(NEW_LINE);
                            sb.append(parentPerm);
                            lastPermLength = parentPerm.length();
                        }
                        while (lastPermLength <= permNameLength) {
                            sb.append(' ');
                            ++lastPermLength;
                        }
                        sb.append("# ");
                        sb.append(value);
                        writer.write(sb.toString());
                        continue;
                    }
                    if (perm.endsWith(".*")) {
                        String parentPerm = perm.substring(0, perm.length() - "*".length() - 1);
                        if (permissions.containsKey(parentPerm)) continue;
                        writer.newLine();
                        writer.write(parentPerm);
                        lastPermLength = parentPerm.length();
                        continue;
                    }
                    writer.newLine();
                    writer.write(perm);
                    lastPermLength = perm.length();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

