/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.permissions.commands;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.api.permissions.AreaZone;
import com.forgeessentials.api.permissions.GroupEntry;
import com.forgeessentials.api.permissions.ServerZone;
import com.forgeessentials.api.permissions.WorldZone;
import com.forgeessentials.api.permissions.Zone;
import com.forgeessentials.commons.selections.WorldPoint;
import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.permissions.ModulePermissions;
import com.forgeessentials.util.CommandParserArgs;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.UserIdent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.permissions.PermissionContext;
import net.minecraftforge.permissions.PermissionsManager;
import org.apache.commons.lang3.StringUtils;

public class PermissionCommandParser {
    public static final String PERM = "fe.perm";
    public static final String PERM_ALL = "fe.perm.*";
    public static final String PERM_TEST = "fe.perm.test";
    public static final String PERM_RELOAD = "fe.perm.reload";
    public static final String PERM_SAVE = "fe.perm.save";
    public static final String PERM_DEBUG = "fe.perm.debug";
    public static final String PERM_USER = "fe.perm.user";
    public static final String PERM_USER_PERMS = "fe.perm.user.perms";
    public static final String PERM_USER_SPAWN = "fe.perm.user.spawn";
    public static final String PERM_USER_FIX = "fe.perm.user.fix";
    public static final String PERM_GROUP = "fe.perm.group";
    public static final String PERM_GROUP_PERMS = "fe.perm.group.perms";
    public static final String PERM_GROUP_SPAWN = "fe.perm.group.spawn";
    public static final String PERM_GROUP_FIX = "fe.perm.group.fix";
    private static final String PERM_LIST = "fe.perm.list";
    public static final String PERM_LIST_PERMS = "fe.perm.list.perms";
    public static final String PERM_LIST_ZONES = "fe.perm.list.zones";
    public static final String PERM_LIST_USERS = "fe.perm.list.users";
    public static final String PERM_LIST_GROUPS = "fe.perm.list.groups";
    private static final String[] parseMainArgs = new String[]{"user", "group", "global", "list", "test", "reload", "save", "debug"};
    private static final String[] parseListArgs = new String[]{"zones", "perms", "users", "groups"};
    private static final String[] parseUserArgs = new String[]{"zone", "group", "allow", "deny", "clear", "value", "true", "false", "spawn", "prefix", "suffix", "perms"};
    private static final String[] parseGroupArgs = new String[]{"zone", "allow", "deny", "clear", "value", "true", "false", "spawn", "prefix", "suffix", "perms", "priority", "parent", "include"};
    private static final String[] parseUserGroupArgs = new String[]{"add", "remove", "set"};
    private static final String[] parseGroupIncludeArgs = new String[]{"add", "remove", "clear"};
    private static final String[] parseSpawnArgs = new String[]{"here", "clear", "bed"};

    public static void parseMain(CommandParserArgs arguments) {
        if (arguments.isTabCompletion && arguments.args.size() == 1) {
            arguments.tabCompletion = ForgeEssentialsCommandBase.getListOfStringsMatchingLastWord(arguments.args.peek(), parseMainArgs);
            return;
        }
        if (arguments.args.isEmpty()) {
            arguments.info("/feperm " + StringUtils.join((Object[])parseMainArgs, (String)"|") + ": Displays help for the subcommands");
        } else {
            switch (arguments.args.remove().toLowerCase()) {
                case "save": {
                    ModulePermissions.permissionHelper.save();
                    arguments.info("Permissions saved!");
                    break;
                }
                case "reload": {
                    if (ModulePermissions.permissionHelper.load()) {
                        arguments.info("Successfully reloaded permissions");
                        break;
                    }
                    arguments.error("Error while reloading permissions");
                    break;
                }
                case "test": {
                    PermissionCommandParser.parseTest(arguments);
                    break;
                }
                case "list": {
                    PermissionCommandParser.parseList(arguments);
                    break;
                }
                case "user": {
                    PermissionCommandParser.parseUser(arguments);
                    break;
                }
                case "group": {
                    PermissionCommandParser.parseGroup(arguments);
                    break;
                }
                case "global": {
                    PermissionCommandParser.parseGlobal(arguments);
                    break;
                }
                case "debug": {
                    if (arguments.isTabCompletion) {
                        return;
                    }
                    if (!PermissionsManager.checkPermission(new PermissionContext().setCommandSender(arguments.sender), PERM_DEBUG)) {
                        arguments.error("You don't have permissions to use this command!");
                        return;
                    }
                    if (ModulePermissions.permissionHelper.permissionDebugUsers.contains(arguments.sender)) {
                        ModulePermissions.permissionHelper.permissionDebugUsers.remove(arguments.sender);
                        arguments.info("Permission debug mode off");
                        break;
                    }
                    ModulePermissions.permissionHelper.permissionDebugUsers.add(arguments.sender);
                    arguments.info("Permission debug mode on");
                    break;
                }
                default: {
                    arguments.error("Unknown command argument");
                }
            }
        }
    }

    public static void parseList(CommandParserArgs arguments) {
        if (arguments.isTabCompletion) {
            if (arguments.args.size() == 1) {
                arguments.tabCompletion = ForgeEssentialsCommandBase.getListOfStringsMatchingLastWord(arguments.args.peek(), parseListArgs);
            }
            return;
        }
        if (arguments.args.isEmpty()) {
            arguments.info("/feperm list " + StringUtils.join((Object[])parseListArgs, (String)"|") + " : List the specified objects");
        } else {
            String arg;
            switch (arg = arguments.args.remove().toLowerCase()) {
                case "zones": {
                    if (arguments.senderPlayer == null) {
                        throw new CommandException("This command cannot be used from console", new Object[0]);
                    }
                    PermissionCommandParser.listZones((ICommandSender)arguments.senderPlayer, new WorldPoint((Entity)arguments.senderPlayer));
                    break;
                }
                case "perms": {
                    if (arguments.senderPlayer == null) {
                        throw new CommandException("This command cannot be used from console", new Object[0]);
                    }
                    PermissionCommandParser.listUserPermissions(arguments.sender, new UserIdent(arguments.senderPlayer), true);
                    break;
                }
                case "users": {
                    PermissionCommandParser.listUsers(arguments.sender);
                    break;
                }
                case "groups": {
                    PermissionCommandParser.listGroups(arguments.sender);
                    break;
                }
                default: {
                    arguments.error("Unknown command argument");
                }
            }
        }
    }

    public static void parseTest(CommandParserArgs arguments) {
        if (arguments.args.isEmpty()) {
            throw new CommandException("Missing permission argument!", new Object[0]);
        }
        if (arguments.senderPlayer == null) {
            throw new CommandException("This command cannot be used from console", new Object[0]);
        }
        if (!arguments.isTabCompletion && !PermissionsManager.checkPermission(new PermissionContext().setCommandSender(arguments.sender), PERM_TEST)) {
            throw new CommandException("You don't have permissions to use this command!", new Object[0]);
        }
        if (arguments.isTabCompletion) {
            arguments.tabCompletion = ForgeEssentialsCommandBase.getListOfStringsMatchingLastWord(arguments.args.peek(), parseUserArgs);
            for (Zone zone : APIRegistry.perms.getZones()) {
                if (!CommandBase.func_71523_a((String)arguments.args.peek(), (String)zone.getName())) continue;
                arguments.tabCompletion.add(zone.getName());
            }
            for (String perm : ModulePermissions.permissionHelper.enumRegisteredPermissions()) {
                if (!CommandBase.func_71523_a((String)arguments.args.peek(), (String)perm)) continue;
                arguments.tabCompletion.add(perm);
            }
            return;
        }
        String permissionNode = arguments.args.remove();
        String result = APIRegistry.perms.getPermissionProperty((EntityPlayer)arguments.senderPlayer, permissionNode);
        if (result == null) {
            arguments.info(permissionNode + " = \ufffdetrue (not set)");
        } else if ("false".equalsIgnoreCase(result)) {
            arguments.info(permissionNode + " = \ufffdc" + result);
        } else {
            arguments.info(permissionNode + " = " + result);
        }
    }

    public static void parseUser(CommandParserArgs arguments) {
        if (!arguments.isTabCompletion && !PermissionsManager.checkPermission(new PermissionContext().setCommandSender(arguments.sender), PERM_USER)) {
            throw new CommandException("You don't have permissions to use this command!", new Object[0]);
        }
        if (arguments.args.isEmpty()) {
            arguments.info("Possible usage:");
            arguments.info("/p user <player> : Display user info");
            arguments.info("/p user <player> zone <zone> ... : Work with zones");
            arguments.info("/p user <player> perms : List player's permissions");
            arguments.info("/p user <player> group add|remove <group>: Player's group settings");
            arguments.info("/p user <player> allow|deny|clear <perms> : Set permissions");
            arguments.info("/p user <player> value <perm> <value> : Set permission property");
            arguments.info("/p user <player> spawn : Set player spawn");
            return;
        }
        UserIdent ident = arguments.parsePlayer();
        if (ident == null) {
            return;
        }
        if (!ident.hasUUID()) {
            arguments.error(String.format("Player %s not found. playername will be used, but may be inaccurate.", ident.getUsername()));
        }
        PermissionCommandParser.parseUserInner(arguments, ident, null);
    }

    public static void parseUserInner(CommandParserArgs arguments, UserIdent ident, Zone zone) {
        if (arguments.args.isEmpty()) {
            if (zone == null) {
                arguments.info(String.format("Groups for player %s:", ident.getUsernameOrUUID()));
                for (GroupEntry group : APIRegistry.perms.getPlayerGroups(ident)) {
                    arguments.info("  " + group);
                }
                return;
            }
            arguments.info(ident.getUsernameOrUUID() + "'s permissions in zone " + zone.getName() + ":");
            for (Map.Entry perm : zone.getPlayerPermissions(ident).entrySet()) {
                arguments.info("  " + (String)perm.getKey() + " = " + (String)perm.getValue());
            }
            return;
        }
        if (arguments.isTabCompletion && arguments.args.size() == 1) {
            arguments.tabCompletion = ForgeEssentialsCommandBase.getListOfStringsMatchingLastWord(arguments.args.peek(), parseUserArgs);
            if (zone != null) {
                arguments.tabCompletion.remove("zone");
            }
            return;
        }
        String cmd = arguments.args.remove().toLowerCase();
        if (cmd.equals("zone")) {
            if (zone != null) {
                arguments.error(String.format("Zone already set!", new Object[0]));
                return;
            }
            if (arguments.args.isEmpty()) {
                arguments.error(String.format("Expected zone identifier.", new Object[0]));
                return;
            }
            zone = PermissionCommandParser.getZoneByName(arguments.sender, arguments.args.remove());
            if (zone == null) {
                return;
            }
            PermissionCommandParser.parseUserInner(arguments, ident, zone);
            return;
        }
        if (zone == null) {
            zone = APIRegistry.perms.getServerZone();
        }
        switch (cmd) {
            case "group": {
                PermissionCommandParser.parseUserGroup(arguments, ident, zone);
                break;
            }
            case "perms": {
                PermissionCommandParser.listUserPermissions(arguments.sender, ident, true);
                break;
            }
            case "prefix": {
                PermissionCommandParser.parseUserPrefixSuffix(arguments, ident, zone, false);
                break;
            }
            case "suffix": {
                PermissionCommandParser.parseUserPrefixSuffix(arguments, ident, zone, true);
                break;
            }
            case "spawn": {
                PermissionCommandParser.parseUserSpawn(arguments, ident, zone);
                break;
            }
            case "true": 
            case "allow": {
                PermissionCommandParser.parseUserPermissions(arguments, ident, zone, PermissionAction.ALLOW);
                break;
            }
            case "false": 
            case "deny": {
                PermissionCommandParser.parseUserPermissions(arguments, ident, zone, PermissionAction.DENY);
                break;
            }
            case "clear": {
                PermissionCommandParser.parseUserPermissions(arguments, ident, zone, PermissionAction.CLEAR);
                break;
            }
            case "value": {
                PermissionCommandParser.parseUserPermissions(arguments, ident, zone, PermissionAction.VALUE);
                break;
            }
            default: {
                throw new CommandException("Invalid syntax!", new Object[0]);
            }
        }
    }

    public static void parseUserPrefixSuffix(CommandParserArgs arguments, UserIdent ident, Zone zone, boolean isSuffix) {
        String fixName;
        if (!arguments.isTabCompletion && !PermissionsManager.checkPermission(new PermissionContext().setCommandSender(arguments.sender), PERM_USER_FIX)) {
            throw new CommandException("You don't have permissions to use this command!", new Object[0]);
        }
        if (arguments.isTabCompletion) {
            return;
        }
        String string = fixName = isSuffix ? "suffix" : "prefix";
        if (arguments.args.isEmpty()) {
            String fix = zone.getPlayerPermission(ident, isSuffix ? "fe.internal.suffix" : "fe.internal.prefix");
            if (fix == null || fix.isEmpty()) {
                fix = "empty";
            }
            arguments.info(String.format("%s's %s is %s", ident.getUsernameOrUUID(), fixName, fix));
        } else {
            String fix = StringUtils.join(arguments.args, (String)" ");
            if (fix.equalsIgnoreCase("clear")) {
                arguments.info(String.format("%s's %s cleared", ident.getUsernameOrUUID(), fixName));
                zone.clearPlayerPermission(ident, isSuffix ? "fe.internal.suffix" : "fe.internal.prefix");
            } else {
                arguments.info(String.format("%s's %s set to %s", ident.getUsernameOrUUID(), fixName, fix));
                zone.setPlayerPermissionProperty(ident, isSuffix ? "fe.internal.suffix" : "fe.internal.prefix", fix);
            }
        }
    }

    public static void parseUserPermissions(CommandParserArgs arguments, UserIdent ident, Zone zone, PermissionAction type) {
        if (!arguments.isTabCompletion && !PermissionsManager.checkPermission(new PermissionContext().setCommandSender(arguments.sender), PERM_USER_PERMS)) {
            throw new CommandException("You don't have permissions to use this command!", new Object[0]);
        }
        if (arguments.args.isEmpty()) {
            throw new CommandException("Missing permission argument!", new Object[0]);
        }
        while (!arguments.args.isEmpty()) {
            if (arguments.isTabCompletion && arguments.args.size() == 1) {
                arguments.tabCompletion = type != PermissionAction.CLEAR ? PermissionCommandParser.completePermission(arguments.args.peek()) : ForgeEssentialsCommandBase.getListOfStringsMatchingLastWord(arguments.args.peek(), zone.getPlayerPermissions(ident).keySet());
                return;
            }
            String permissionNode = arguments.args.remove();
            String msg = null;
            String value = null;
            if (type == PermissionAction.VALUE) {
                if (arguments.args.isEmpty()) {
                    arguments.error("Need to specify value");
                    return;
                }
                value = StringUtils.join(arguments.args, (char)' ');
                arguments.args.clear();
            }
            switch (type) {
                case ALLOW: {
                    zone.setPlayerPermission(ident, permissionNode, true);
                    msg = "Allowed %s access to %s in zone %s";
                    break;
                }
                case DENY: {
                    zone.setPlayerPermission(ident, permissionNode, false);
                    msg = "Denied %s access to %s in zone %s";
                    break;
                }
                case CLEAR: {
                    zone.clearPlayerPermission(ident, permissionNode);
                    msg = "Cleared %s's acces to %s in zone %s";
                    break;
                }
                case VALUE: {
                    zone.setPlayerPermissionProperty(ident, permissionNode, value);
                    arguments.info(String.format("Set %s for %s to %s in zone %s", permissionNode, ident.getUsernameOrUUID(), value, zone.getName()));
                }
            }
            if (msg == null) continue;
            arguments.info(String.format(msg, ident.getUsernameOrUUID(), permissionNode, zone.getName()));
        }
    }

    public static void parseUserSpawn(CommandParserArgs arguments, UserIdent ident, Zone zone) {
        if (!arguments.isTabCompletion && !PermissionsManager.checkPermission(new PermissionContext().setCommandSender(arguments.sender), PERM_USER_SPAWN)) {
            throw new CommandException("You don't have permissions to use this command!", new Object[0]);
        }
        if (arguments.args.isEmpty()) {
            arguments.info("/feperm user " + ident.getUsernameOrUUID() + " spawn (here|bed|clear|<x> <y> <z> <dim>) [zone] : Set spawn");
            return;
        }
        if (arguments.isTabCompletion) {
            if (arguments.args.size() == 1) {
                arguments.tabCompletion = ForgeEssentialsCommandBase.getListOfStringsMatchingLastWord(arguments.args.peek(), parseSpawnArgs);
            }
            return;
        }
        String loc = arguments.args.remove().toLowerCase();
        WorldPoint point = null;
        boolean isBed = false;
        switch (loc) {
            case "here": {
                point = new WorldPoint((Entity)arguments.senderPlayer);
                break;
            }
            case "bed": {
                isBed = true;
                break;
            }
            case "clear": {
                break;
            }
            default: {
                if (arguments.args.size() < 3) {
                    throw new CommandException("Too few arguments!", new Object[0]);
                }
                try {
                    int x = CommandBase.func_71526_a((ICommandSender)arguments.sender, (String)loc);
                    int y = CommandBase.func_71526_a((ICommandSender)arguments.sender, (String)arguments.args.remove());
                    int z = CommandBase.func_71526_a((ICommandSender)arguments.sender, (String)arguments.args.remove());
                    int dimension = CommandBase.func_71526_a((ICommandSender)arguments.sender, (String)arguments.args.remove());
                    point = new WorldPoint(dimension, x, y, z);
                    break;
                }
                catch (NumberFormatException e) {
                    arguments.error("Invalid location argument");
                    return;
                }
            }
        }
        if (isBed) {
            zone.setPlayerPermissionProperty(ident, "fe.internal.spawn", "bed");
            arguments.info(String.format("Set spawn for user %s to be bed-location in zone %s", ident.getUsernameOrUUID(), zone.getName()));
        } else if (point == null) {
            zone.clearPlayerPermission(ident, "fe.internal.spawn");
            arguments.info(String.format("Cleared spawn-rule for user %s in zone %s", ident.getUsernameOrUUID(), zone.getName()));
        } else {
            zone.setPlayerPermissionProperty(ident, "fe.internal.spawn", point.toString());
            arguments.info(String.format("Set spawn for user %s to %s in zone %s", ident.getUsernameOrUUID(), point.toString(), zone.getName()));
        }
    }

    public static void parseUserGroup(CommandParserArgs arguments, UserIdent ident, Zone zone) {
        if (arguments.isTabCompletion && arguments.args.size() == 1) {
            arguments.tabCompletion = ForgeEssentialsCommandBase.getListOfStringsMatchingLastWord(arguments.args.peek(), parseUserGroupArgs);
            return;
        }
        if (arguments.args.isEmpty()) {
            if (zone instanceof ServerZone) {
                arguments.info(String.format("Groups for player %s (without includes):", ident.getUsernameOrUUID()));
            } else {
                arguments.info(String.format("Groups for player %s (without includes) in %s:", ident.getUsernameOrUUID(), zone.getName()));
            }
            for (GroupEntry g : zone.getStoredPlayerGroups(ident)) {
                arguments.info("  " + g);
            }
        } else {
            String mode = arguments.args.remove().toLowerCase();
            if (!(mode.equals("add") || mode.equals("remove") || mode.equals("set"))) {
                arguments.error("Syntax error. Please try this instead:");
                arguments.error("/p user <player> group add|set|remove <GROUP>");
                return;
            }
            if (arguments.isTabCompletion) {
                if (arguments.args.size() == 1) {
                    arguments.tabCompletion = new ArrayList<String>();
                    for (String group : APIRegistry.perms.getServerZone().getGroups()) {
                        if (!CommandBase.func_71523_a((String)arguments.args.peek(), (String)group)) continue;
                        arguments.tabCompletion.add(group);
                    }
                }
                return;
            }
            if (arguments.args.isEmpty()) {
                arguments.error("Usage: /p user <player> group " + mode + " <group-name>");
            } else {
                Object[] groups;
                for (String string : groups = arguments.args.remove().split(",")) {
                    if (APIRegistry.perms.groupExists(string)) continue;
                    arguments.error(String.format("Group %s not found.", string));
                    return;
                }
                switch (mode) {
                    case "add": {
                        for (String string : groups) {
                            zone.addPlayerToGroup(ident, string);
                        }
                        arguments.info(String.format("Player %s added to group(s) %s", ident.getUsernameOrUUID(), StringUtils.join((Object[])groups, (String)", ")));
                        break;
                    }
                    case "remove": {
                        for (String string : groups) {
                            zone.removePlayerFromGroup(ident, string);
                        }
                        arguments.info(String.format("Player %s removed from group(s) %s", ident.getUsernameOrUUID(), StringUtils.join((Object[])groups, (String)", ")));
                        break;
                    }
                    case "set": {
                        for (GroupEntry groupEntry : APIRegistry.perms.getStoredPlayerGroups(ident)) {
                            zone.removePlayerFromGroup(ident, groupEntry.getGroup());
                        }
                        for (String string : groups) {
                            zone.addPlayerToGroup(ident, string);
                        }
                        arguments.info(String.format("Set %s's group(s) to %s", ident.getUsernameOrUUID(), StringUtils.join((Object[])groups, (String)", ")));
                    }
                }
            }
        }
    }

    public static void parseGroup(CommandParserArgs arguments) {
        if (!arguments.isTabCompletion && !PermissionsManager.checkPermission(new PermissionContext().setCommandSender(arguments.sender), PERM_GROUP)) {
            throw new CommandException("You don't have permissions to use this command!", new Object[0]);
        }
        if (arguments.args.isEmpty()) {
            arguments.info("Possible usage:");
            arguments.info("/p group <group> : Display group info");
            arguments.info("/p group <group> zone <zone> ... : Work with zones");
            arguments.info("/p group <group> create : Create a new group");
            arguments.info("/p group <group> perms : List group's permissions");
            arguments.info("/p group <group> allow|deny|clear <perms> : Set permissions");
            arguments.info("/p group <group> value <perm> <value> : Set permission property");
            arguments.info("/p group <group> spawn : Set group spawn");
            return;
        }
        if (arguments.isTabCompletion && arguments.args.size() == 1) {
            arguments.tabCompletion = new ArrayList<String>();
            for (String group : APIRegistry.perms.getServerZone().getGroups()) {
                if (!CommandBase.func_71523_a((String)arguments.args.peek(), (String)group)) continue;
                arguments.tabCompletion.add(group);
            }
            return;
        }
        String group = arguments.args.remove();
        if (!APIRegistry.perms.groupExists(group)) {
            if (arguments.isTabCompletion && arguments.args.size() == 1) {
                arguments.tabCompletion = ForgeEssentialsCommandBase.getListOfStringsMatchingLastWord(arguments.args.peek(), "create");
                return;
            }
            if (arguments.args.isEmpty()) {
                arguments.info(String.format("Group %s does not exist", group));
            } else {
                String groupArg = arguments.args.remove();
                if (groupArg.equalsIgnoreCase("create")) {
                    if (APIRegistry.perms.createGroup(group)) {
                        arguments.info(String.format("Created group %s", group));
                    } else {
                        arguments.info(String.format("Could not create group %s. Cancelled.", group));
                    }
                } else {
                    arguments.error(String.format("Group %s does not exist", group));
                }
            }
            return;
        }
        PermissionCommandParser.parseGroupInner(arguments, group, null);
    }

    public static void parseGlobal(CommandParserArgs arguments) {
        if (!arguments.isTabCompletion && !PermissionsManager.checkPermission(new PermissionContext().setCommandSender(arguments.sender), PERM_GROUP)) {
            throw new CommandException("You don't have permissions to use this command!", new Object[0]);
        }
        PermissionCommandParser.parseGroupInner(arguments, "_ALL_", null);
    }

    public static void parseGroupInner(CommandParserArgs arguments, String group, Zone zone) {
        if (arguments.args.isEmpty()) {
            if (zone == null) {
                arguments.info("Group " + group + " permissions:");
                PermissionCommandParser.listGroupPermissions(arguments.sender, group);
                return;
            }
            if (zone.getGroupPermissions(group) == null) {
                arguments.info("Group " + group + " has no permissions in zone " + zone.getName() + ".");
            } else {
                arguments.info("Group " + group + " permissions in zone " + zone.getName() + ":");
                for (Map.Entry perm : zone.getGroupPermissions(group).entrySet()) {
                    arguments.info("  " + (String)perm.getKey() + " = " + (String)perm.getValue());
                }
            }
            return;
        }
        if (arguments.isTabCompletion && arguments.args.size() == 1) {
            arguments.tabCompletion = ForgeEssentialsCommandBase.getListOfStringsMatchingLastWord(arguments.args.peek(), parseGroupArgs);
            if (zone != null) {
                arguments.tabCompletion.remove("zone");
            }
            return;
        }
        String cmd = arguments.args.remove().toLowerCase();
        if (cmd.equals("zone")) {
            if (zone != null) {
                arguments.error(String.format("Zone already set!", new Object[0]));
                return;
            }
            if (arguments.args.isEmpty()) {
                arguments.error(String.format("Expected zone identifier.", new Object[0]));
                return;
            }
            if (arguments.isTabCompletion && arguments.args.size() == 1) {
                arguments.tabCompletion = new ArrayList<String>();
                for (Zone z : APIRegistry.perms.getZones()) {
                    if (!CommandBase.func_71523_a((String)arguments.args.peek(), (String)z.getName())) continue;
                    arguments.tabCompletion.add(z.getName());
                }
                return;
            }
            zone = PermissionCommandParser.getZoneByName(arguments.sender, arguments.args.remove());
            if (zone == null) {
                return;
            }
            PermissionCommandParser.parseGroupInner(arguments, group, zone);
            return;
        }
        if (zone == null) {
            zone = APIRegistry.perms.getServerZone();
        }
        switch (cmd) {
            case "perms": {
                arguments.info("Group " + group + " permissions:");
                PermissionCommandParser.listGroupPermissions(arguments.sender, group);
                break;
            }
            case "prefix": {
                PermissionCommandParser.parseGroupPrefixSuffix(arguments, group, zone, false);
                break;
            }
            case "suffix": {
                PermissionCommandParser.parseGroupPrefixSuffix(arguments, group, zone, true);
                break;
            }
            case "spawn": {
                PermissionCommandParser.parseGroupSpawn(arguments, group, zone);
                break;
            }
            case "priority": {
                PermissionCommandParser.parseGroupPriority(arguments, group);
                break;
            }
            case "parent": {
                PermissionCommandParser.parseGroupInclude(arguments, group, true);
                break;
            }
            case "include": {
                PermissionCommandParser.parseGroupInclude(arguments, group, false);
                break;
            }
            case "true": 
            case "allow": {
                PermissionCommandParser.parseGroupPermissions(arguments, group, zone, PermissionAction.ALLOW);
                break;
            }
            case "false": 
            case "deny": {
                PermissionCommandParser.parseGroupPermissions(arguments, group, zone, PermissionAction.DENY);
                break;
            }
            case "clear": {
                PermissionCommandParser.parseGroupPermissions(arguments, group, zone, PermissionAction.CLEAR);
                break;
            }
            case "value": {
                PermissionCommandParser.parseGroupPermissions(arguments, group, zone, PermissionAction.VALUE);
                break;
            }
            default: {
                throw new CommandException("Invalid syntax!", new Object[0]);
            }
        }
    }

    public static void parseGroupPrefixSuffix(CommandParserArgs arguments, String group, Zone zone, boolean isSuffix) {
        String fixName;
        if (!arguments.isTabCompletion && !PermissionsManager.checkPermission(new PermissionContext().setCommandSender(arguments.sender), PERM_GROUP_FIX)) {
            throw new CommandException("You don't have permissions to use this command!", new Object[0]);
        }
        if (arguments.isTabCompletion) {
            return;
        }
        String string = fixName = isSuffix ? "suffix" : "prefix";
        if (arguments.args.isEmpty()) {
            String fix = APIRegistry.perms.getServerZone().getGroupPermission(group, isSuffix ? "fe.internal.suffix" : "fe.internal.prefix");
            if (fix == null || fix.isEmpty()) {
                fix = "empty";
            }
            arguments.info(String.format("%s's %s is %s", group, fixName, fix));
        } else {
            String fix = StringUtils.join(arguments.args, (String)" ");
            if (fix.equalsIgnoreCase("clear")) {
                arguments.info(String.format("%s's %s cleared", group, fixName));
                APIRegistry.perms.getServerZone().clearGroupPermission(group, isSuffix ? "fe.internal.suffix" : "fe.internal.prefix");
            } else {
                arguments.info(String.format("%s's %s set to %s", group, fixName, fix));
                APIRegistry.perms.getServerZone().setGroupPermissionProperty(group, isSuffix ? "fe.internal.suffix" : "fe.internal.prefix", fix);
            }
        }
    }

    public static void parseGroupPermissions(CommandParserArgs arguments, String group, Zone zone, PermissionAction type) {
        if (!arguments.isTabCompletion && !PermissionsManager.checkPermission(new PermissionContext().setCommandSender(arguments.sender), PERM_GROUP_PERMS)) {
            throw new CommandException("You don't have permissions to use this command!", new Object[0]);
        }
        if (arguments.args.isEmpty()) {
            throw new CommandException("Missing permission argument!", new Object[0]);
        }
        while (!arguments.args.isEmpty()) {
            if (arguments.isTabCompletion && arguments.args.size() == 1) {
                arguments.tabCompletion = type != PermissionAction.CLEAR ? PermissionCommandParser.completePermission(arguments.args.peek()) : ForgeEssentialsCommandBase.getListOfStringsMatchingLastWord(arguments.args.peek(), zone.getGroupPermissions(group).keySet());
                return;
            }
            String permissionNode = arguments.args.remove();
            String msg = null;
            String value = null;
            if (type == PermissionAction.VALUE) {
                if (arguments.args.isEmpty()) {
                    arguments.error("Need to specify value");
                    return;
                }
                value = StringUtils.join(arguments.args, (char)' ');
                arguments.args.clear();
            }
            switch (type) {
                case ALLOW: {
                    zone.setGroupPermission(group, permissionNode, true);
                    msg = "Allowed %s access to %s in zone %s";
                    break;
                }
                case DENY: {
                    zone.setGroupPermission(group, permissionNode, false);
                    msg = "Denied %s access to %s in zone %s";
                    break;
                }
                case CLEAR: {
                    zone.clearGroupPermission(group, permissionNode);
                    msg = "Cleared %s's acces to %s in zone %s";
                    break;
                }
                case VALUE: {
                    zone.setGroupPermissionProperty(group, permissionNode, value);
                    arguments.info(String.format("Set %s for group %s to %s in zone %s", permissionNode, group, value, zone.getName()));
                }
            }
            if (msg == null) continue;
            arguments.info(String.format(msg, group, permissionNode, zone.getName()));
        }
    }

    public static void parseGroupSpawn(CommandParserArgs arguments, String group, Zone zone) {
        if (!arguments.isTabCompletion && !PermissionsManager.checkPermission(new PermissionContext().setCommandSender(arguments.sender), PERM_GROUP_SPAWN)) {
            throw new CommandException("You don't have permissions to use this command!", new Object[0]);
        }
        if (arguments.args.isEmpty()) {
            arguments.info("/feperm group " + group + " spawn (here|bed|clear|<x> <y> <z> <dim>) [zone] : Set spawn");
            return;
        }
        if (arguments.isTabCompletion) {
            if (arguments.args.size() == 1) {
                arguments.tabCompletion = ForgeEssentialsCommandBase.getListOfStringsMatchingLastWord(arguments.args.peek(), parseSpawnArgs);
            }
            return;
        }
        String loc = arguments.args.remove().toLowerCase();
        WorldPoint point = null;
        boolean isBed = false;
        switch (loc) {
            case "here": {
                point = new WorldPoint((Entity)arguments.senderPlayer);
                break;
            }
            case "bed": {
                isBed = true;
                break;
            }
            case "clear": {
                break;
            }
            default: {
                if (arguments.args.size() < 3) {
                    throw new CommandException("Too few arguments!", new Object[0]);
                }
                try {
                    int x = CommandBase.func_71526_a((ICommandSender)arguments.sender, (String)loc);
                    int y = CommandBase.func_71526_a((ICommandSender)arguments.sender, (String)arguments.args.remove());
                    int z = CommandBase.func_71526_a((ICommandSender)arguments.sender, (String)arguments.args.remove());
                    int dimension = CommandBase.func_71526_a((ICommandSender)arguments.sender, (String)arguments.args.remove());
                    point = new WorldPoint(dimension, x, y, z);
                    break;
                }
                catch (NumberFormatException e) {
                    arguments.error("Invalid location argument");
                    return;
                }
            }
        }
        if (isBed) {
            zone.setGroupPermissionProperty(group, "fe.internal.spawn", "bed");
            arguments.info(String.format("Set spawn for group %s to be bed-location in zone %s", group, zone.getName()));
        } else if (point == null) {
            zone.clearGroupPermission(group, "fe.internal.spawn");
            arguments.info(String.format("Cleared spawn-rule for group %s in zone %s", group, zone.getName()));
        } else {
            zone.setGroupPermissionProperty(group, "fe.internal.spawn", point.toString());
            arguments.info(String.format("Set spawn for group %s to %s in zone %s", group, point.toString(), zone.getName()));
        }
    }

    public static void parseGroupPriority(CommandParserArgs arguments, String group) {
        if (!arguments.isTabCompletion && !PermissionsManager.checkPermission(new PermissionContext().setCommandSender(arguments.sender), PERM_GROUP_PERMS)) {
            throw new CommandException("You don't have permissions to use this command!", new Object[0]);
        }
        if (arguments.args.isEmpty()) {
            arguments.info("Priority for group " + group + ": " + APIRegistry.perms.getGroupPermissionProperty(group, "fe.internal.group.priority"));
            return;
        }
        String priorityValue = arguments.args.remove();
        try {
            APIRegistry.perms.setGroupPermissionProperty(group, "fe.internal.group.priority", Integer.toString(Integer.parseInt(priorityValue)));
            arguments.info(String.format("Set priority for group %s to %s", group, priorityValue));
        }
        catch (NumberFormatException e) {
            arguments.error(String.format("The string %s is not a valid integer", priorityValue));
        }
    }

    public static void parseGroupInclude(CommandParserArgs arguments, String group, boolean isParent) {
        Set<String> groups;
        if (!arguments.isTabCompletion && !PermissionsManager.checkPermission(new PermissionContext().setCommandSender(arguments.sender), PERM_GROUP_PERMS)) {
            throw new CommandException("You don't have permissions to use this command!", new Object[0]);
        }
        if (arguments.isTabCompletion && arguments.args.size() == 1) {
            arguments.tabCompletion = ForgeEssentialsCommandBase.getListOfStringsMatchingLastWord(arguments.args.peek(), parseGroupIncludeArgs);
            return;
        }
        String displayName1 = isParent ? " parent" : " include";
        Set<String> set = groups = isParent ? APIRegistry.perms.getServerZone().getParentedGroups(group) : APIRegistry.perms.getServerZone().getIncludedGroups(group);
        if (arguments.args.isEmpty()) {
            arguments.info(String.format((isParent ? "Parented" : "Included") + " groups for %s:", group));
            for (String includedGroup : groups) {
                arguments.info("  " + includedGroup);
            }
            return;
        }
        String cmd = arguments.args.remove().toLowerCase();
        if (cmd.equals("clear")) {
            APIRegistry.perms.getServerZone().clearGroupPermission(group, isParent ? "fe.internal.group.parents" : "fe.internal.group.includes");
            arguments.info(String.format("Cleared group-" + displayName1 + "s for group %s", group));
            return;
        }
        if (arguments.args.isEmpty()) {
            arguments.error("Invalid syntax!");
            return;
        }
        if (arguments.isTabCompletion) {
            if (arguments.args.size() == 1) {
                arguments.tabCompletion = new ArrayList<String>();
                for (String g : APIRegistry.perms.getServerZone().getGroups()) {
                    if (!CommandBase.func_71523_a((String)arguments.args.peek(), (String)g)) continue;
                    arguments.tabCompletion.add(g);
                }
            }
            return;
        }
        String groupsName = arguments.args.remove();
        switch (cmd) {
            case "add": {
                groups.add(groupsName);
                arguments.info(String.format("Added group-" + displayName1 + " of %s to group %s", groupsName, group));
                break;
            }
            case "remove": {
                groups.remove(groupsName);
                arguments.info(String.format("Removed group-" + displayName1 + " of %s to group %s", groupsName, group));
                break;
            }
            default: {
                arguments.error("Invalid syntax!");
                return;
            }
        }
        APIRegistry.perms.setGroupPermissionProperty(group, isParent ? "fe.internal.group.parents" : "fe.internal.group.includes", StringUtils.join(groups, (String)","));
    }

    public static List<String> completePermission(String permission) {
        TreeSet<String> result = new TreeSet<String>();
        for (String perm : ModulePermissions.permissionHelper.enumRegisteredPermissions()) {
            int nodeIndex = perm.indexOf(46, permission.length());
            if (nodeIndex >= 0) {
                perm = perm.substring(0, nodeIndex);
            }
            if (!CommandBase.func_71523_a((String)permission, (String)perm)) continue;
            result.add(perm);
        }
        return new ArrayList<String>(result);
    }

    public static Zone getZoneByName(ICommandSender sender, String zoneId) {
        try {
            int intId = Integer.parseInt(zoneId);
            if (intId < 1) {
                OutputHandler.chatError(sender, String.format("Zone ID must be greater than 0!", new Object[0]));
                return null;
            }
            Zone zone = APIRegistry.perms.getZoneById(intId);
            if (zone != null) {
                return zone;
            }
            OutputHandler.chatError(sender, String.format("No zone by the ID %s exists!", zoneId));
            return null;
        }
        catch (NumberFormatException e) {
            for (WorldZone wz : APIRegistry.perms.getServerZone().getWorldZones().values()) {
                if (!wz.getName().equals(zoneId)) continue;
                return wz;
            }
            if (!(sender instanceof EntityPlayerMP)) {
                OutputHandler.chatError(sender, "Cannot identify zones by name from console!");
                return null;
            }
            AreaZone zone = APIRegistry.perms.getServerZone().getWorldZone(((EntityPlayerMP)sender).field_71093_bK).getAreaZone(zoneId);
            if (zone != null) {
                return zone;
            }
            OutputHandler.chatError(sender, String.format("No zone by the name %s exists!", zoneId));
            return null;
        }
    }

    public static void listUserPermissions(ICommandSender sender, UserIdent ident, boolean showGroupPerms) {
        if (!PermissionsManager.checkPermission(new PermissionContext().setCommandSender(sender), PERM_LIST_PERMS)) {
            throw new CommandException("You don't have permissions to use this command!", new Object[0]);
        }
        OutputHandler.chatNotification(sender, ident.getUsernameOrUUID() + " permissions:");
        Map<Zone, Map<String, String>> userPerms = ModulePermissions.permissionHelper.enumUserPermissions(ident);
        for (Map.Entry<Zone, Map<String, String>> zone : userPerms.entrySet()) {
            boolean printedZone = false;
            for (Map.Entry<String, String> perm : zone.getValue().entrySet()) {
                if (perm.getKey().startsWith("fe.internal.group")) continue;
                if (!printedZone) {
                    OutputHandler.chatWarning(sender, "Zone #" + zone.getKey().getId() + " " + zone.getKey().toString());
                    printedZone = true;
                }
                OutputHandler.chatNotification(sender, "  " + perm.getKey() + " = " + perm.getValue());
            }
        }
        if (showGroupPerms) {
            for (GroupEntry group : APIRegistry.perms.getPlayerGroups(ident)) {
                Map<Zone, Map<String, String>> groupPerms = ModulePermissions.permissionHelper.enumGroupPermissions(group.getGroup(), false);
                if (groupPerms.isEmpty()) continue;
                boolean printedGroup = false;
                for (Map.Entry<Zone, Map<String, String>> zone : groupPerms.entrySet()) {
                    boolean printedZone = false;
                    for (Map.Entry<String, String> perm : zone.getValue().entrySet()) {
                        if (perm.getKey().equals("fe.internal.group") || perm.getKey().equals("fe.internal.group.id") || perm.getKey().equals("fe.internal.group.priority") || perm.getKey().equals("fe.internal.prefix") || perm.getKey().equals("fe.internal.suffix")) continue;
                        if (!printedGroup) {
                            OutputHandler.chatWarning(sender, "Group " + group);
                            printedGroup = true;
                        }
                        if (!printedZone) {
                            OutputHandler.chatWarning(sender, "  Zone #" + zone.getKey().getId() + " " + zone.getKey().toString());
                            printedZone = true;
                        }
                        OutputHandler.chatNotification(sender, "    " + perm.getKey() + " = " + perm.getValue());
                    }
                }
            }
        }
    }

    public static void listGroupPermissions(ICommandSender sender, String group) {
        Map<Zone, Map<String, String>> groupPerms = ModulePermissions.permissionHelper.enumGroupPermissions(group, false);
        if (!groupPerms.isEmpty()) {
            for (Map.Entry<Zone, Map<String, String>> zone : groupPerms.entrySet()) {
                boolean printedZone = false;
                for (Map.Entry<String, String> perm : zone.getValue().entrySet()) {
                    if (perm.getKey().equals("fe.internal.group") || perm.getKey().equals("fe.internal.group.id") || perm.getKey().equals("fe.internal.group.priority") || perm.getKey().equals("fe.internal.prefix") || perm.getKey().equals("fe.internal.suffix")) continue;
                    if (!printedZone) {
                        OutputHandler.chatWarning(sender, "  Zone #" + zone.getKey().getId() + " " + zone.getKey().toString());
                        printedZone = true;
                    }
                    OutputHandler.chatNotification(sender, "    " + perm.getKey() + " = " + perm.getValue());
                }
            }
        }
    }

    public static void listZones(ICommandSender sender, WorldPoint location) {
        OutputHandler.chatNotification(sender, "Zones at position " + location.toString());
        for (Zone zone : APIRegistry.perms.getServerZone().getZonesAt(location)) {
            if (zone.isHidden()) continue;
            OutputHandler.chatNotification(sender, "  #" + zone.getId() + " " + zone.toString());
        }
    }

    public static void listGroups(ICommandSender sender) {
        if (!PermissionsManager.checkPermission(new PermissionContext().setCommandSender(sender), PERM_LIST_GROUPS)) {
            throw new CommandException("You don't have permissions to use this command!", new Object[0]);
        }
        OutputHandler.chatNotification(sender, "Groups:");
        for (String group : APIRegistry.perms.getServerZone().getGroups()) {
            OutputHandler.chatNotification(sender, " - " + group);
        }
    }

    public static void listUsers(ICommandSender sender) {
        if (!PermissionsManager.checkPermission(new PermissionContext().setCommandSender(sender), PERM_LIST_USERS)) {
            throw new CommandException("You don't have permissions to use this command!", new Object[0]);
        }
        OutputHandler.chatNotification(sender, "Known players:");
        for (UserIdent ident : APIRegistry.perms.getServerZone().getKnownPlayers()) {
            OutputHandler.chatNotification(sender, " - " + ident.getUsernameOrUUID());
        }
        OutputHandler.chatNotification(sender, "Online players:");
        for (UserIdent player : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            OutputHandler.chatNotification(sender, " - " + ((EntityPlayerMP)player).func_70005_c_());
        }
    }

    static enum PermissionAction {
        ALLOW,
        DENY,
        CLEAR,
        VALUE;

    }
}

