/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.permissions.commands;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.api.permissions.AreaZone;
import com.forgeessentials.api.permissions.WorldZone;
import com.forgeessentials.api.permissions.Zone;
import com.forgeessentials.commons.selections.AreaShape;
import com.forgeessentials.commons.selections.Selection;
import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.events.EventCancelledException;
import com.forgeessentials.util.selections.SelectionHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.permissions.PermissionContext;
import net.minecraftforge.permissions.PermissionsManager;
import org.apache.commons.lang3.StringUtils;

public class CommandZone
extends ForgeEssentialsCommandBase {
    public static final String PERM_NODE = "fe.perm.zone";
    public static final String PERM_ALL = "fe.perm.zone.*";
    public static final String PERM_LIST = "fe.perm.zone.list";
    public static final String PERM_INFO = "fe.perm.zone.info";
    public static final String PERM_DEFINE = "fe.perm.zone.define";
    public static final String PERM_REDEFINE = "fe.perm.zone.redefine";
    public static final String PERM_DELETE = "fe.perm.zone.delete";
    public static final String PERM_SETTINGS = "fe.perm.zone.settings";
    private static final String[] parseMainArgs = new String[]{"help", "list", "info", "define", "redefine", "delete", "exit", "entry"};
    private boolean tabCompleteMode = false;
    private List<String> tabComplete;

    public String func_71517_b() {
        return "zone";
    }

    public List<String> func_71514_a() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("area");
        return list;
    }

    public void parse(ICommandSender sender, Queue<String> args) {
        if (this.tabCompleteMode && args.size() == 1) {
            this.tabComplete = CommandZone.getListOfStringsMatchingLastWord(args.peek(), parseMainArgs);
            return;
        }
        if (args.isEmpty()) {
            CommandZone.help(sender);
        } else {
            String arg;
            WorldZone worldZone = null;
            if (sender instanceof EntityPlayerMP) {
                worldZone = APIRegistry.perms.getServerZone().getWorldZone(((EntityPlayerMP)sender).field_71093_bK);
            }
            switch (arg = args.remove().toLowerCase()) {
                case "help": {
                    CommandZone.help(sender);
                    break;
                }
                case "info": {
                    throw new CommandException("Not yet implemented!", new Object[0]);
                }
                case "list": {
                    CommandZone.parseList(sender, worldZone, args);
                    break;
                }
                case "define": 
                case "redefine": {
                    this.parseDefine(sender, worldZone, args, arg.equals("redefine"));
                    break;
                }
                case "delete": {
                    this.parseDelete(sender, worldZone, args);
                    break;
                }
                case "exit": 
                case "entry": {
                    this.parseEntryExitMessage(sender, worldZone, args, arg.equals("entry"));
                    break;
                }
                default: {
                    OutputHandler.chatError(sender, "Unknown command argument");
                }
            }
        }
    }

    private static AreaZone getAreaZone(WorldZone worldZone, String arg) {
        try {
            Zone z = APIRegistry.perms.getZoneById(arg);
            if (z != null && z instanceof AreaZone) {
                return (AreaZone)z;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return worldZone.getAreaZone(arg);
    }

    private static void parseList(ICommandSender sender, WorldZone worldZone, Queue<String> args) {
        if (!PermissionsManager.checkPermission(new PermissionContext().setCommandSender(sender), PERM_LIST)) {
            OutputHandler.chatError(sender, "You don't have permissions to use this command!");
            return;
        }
        int PAGE_SIZE = 12;
        int limit = 1;
        if (!args.isEmpty()) {
            try {
                limit = Integer.parseInt(args.remove());
            }
            catch (NumberFormatException e) {
                limit = 1;
            }
        }
        OutputHandler.chatConfirmation(sender, "List of areas (page #" + limit + "):");
        limit *= 12;
        if (worldZone == null) {
            block2: for (WorldZone wz : APIRegistry.perms.getServerZone().getWorldZones().values()) {
                for (AreaZone areaZone : wz.getAreaZones()) {
                    if (areaZone.isHidden()) continue;
                    if (limit < 0) continue block2;
                    if (limit <= 12) {
                        OutputHandler.chatConfirmation(sender, "#" + areaZone.getId() + ": " + areaZone.toString());
                    }
                    --limit;
                }
            }
        } else {
            for (AreaZone areaZone : worldZone.getAreaZones()) {
                if (areaZone.isHidden()) continue;
                if (limit >= 0) {
                    if (limit <= 12) {
                        OutputHandler.chatConfirmation(sender, "#" + areaZone.getId() + ": " + areaZone.toString());
                    }
                    --limit;
                    continue;
                }
                break;
            }
        }
    }

    private void parseDefine(ICommandSender sender, WorldZone worldZone, Queue<String> args, boolean redefine) {
        if (!(PermissionsManager.checkPermission(new PermissionContext().setCommandSender(sender), PERM_DEFINE) || redefine && PermissionsManager.checkPermission(new PermissionContext().setCommandSender(sender), PERM_REDEFINE))) {
            OutputHandler.chatError(sender, "You don't have permissions to use this command!");
            return;
        }
        if (worldZone == null) {
            throw new CommandException("No world found", new Object[0]);
        }
        if (args.isEmpty()) {
            throw new CommandException("Missing arguments!", new Object[0]);
        }
        if (this.tabCompleteMode && args.size() == 1) {
            if (!redefine) {
                return;
            }
            for (Zone z : APIRegistry.perms.getZones()) {
                if (!(z instanceof AreaZone)) continue;
                if (z.getName().startsWith(args.peek())) {
                    this.tabComplete.add(z.getName());
                }
                if (!Integer.toString(z.getId()).startsWith(args.peek())) continue;
                this.tabComplete.add(Integer.toString(z.getId()));
            }
            return;
        }
        String zoneName = args.remove();
        AreaZone zone = CommandZone.getAreaZone(worldZone, zoneName);
        if (!redefine && zone != null) {
            throw new CommandException(String.format("Area \"%s\" already exists!", zoneName), new Object[0]);
        }
        if (redefine && zone == null) {
            throw new CommandException(String.format("Area \"%s\" does not exist!", zoneName), new Object[0]);
        }
        if (this.tabCompleteMode) {
            if (args.size() == 1) {
                this.tabComplete = CommandZone.getListOfStringsMatchingLastWord(args.peek(), AreaShape.valueNames());
            }
            return;
        }
        Selection area = null;
        AreaShape shape = null;
        if (!args.isEmpty() && (shape = AreaShape.getByName(args.remove())) == null) {
            shape = AreaShape.BOX;
        }
        if (!(sender instanceof EntityPlayerMP)) {
            throw new CommandException("Command not usable from console. Try /zone set <name> <coords> instead", new Object[0]);
        }
        area = SelectionHandler.selectionProvider.getSelection((EntityPlayerMP)sender);
        if (area == null) {
            throw new CommandException("No selection available. Please select a region first.", new Object[0]);
        }
        PermissionContext context = new PermissionContext();
        context.setCommandSender(sender);
        context.setTargetLocationStart(area.getLowPoint().toVec3());
        context.setTargetLocationEnd(area.getHighPoint().toVec3());
        if (!PermissionsManager.checkPermission(context, PERM_DEFINE)) {
            throw new CommandException("You don't have the permission to define an area.", new Object[0]);
        }
        if (redefine && zone != null) {
            zone.setArea(area);
            if (shape != null) {
                zone.setShape(shape);
            }
            OutputHandler.chatConfirmation(sender, String.format("Area \"%s\" has been redefined.", zoneName));
        } else {
            try {
                zone = new AreaZone(worldZone, zoneName, area);
                if (shape != null) {
                    zone.setShape(shape);
                }
                OutputHandler.chatConfirmation(sender, String.format("Area \"%s\" has been defined.", zoneName));
            }
            catch (EventCancelledException e) {
                OutputHandler.chatError(sender, String.format("Defining area \"%s\" has been cancelled.", zoneName));
            }
        }
    }

    private void parseDelete(ICommandSender sender, WorldZone worldZone, Queue<String> args) {
        if (!PermissionsManager.checkPermission(new PermissionContext().setCommandSender(sender), PERM_DELETE)) {
            OutputHandler.chatError(sender, "You don't have permissions to use this command!");
            return;
        }
        if (worldZone == null) {
            throw new CommandException("No world found", new Object[0]);
        }
        if (args.isEmpty()) {
            throw new CommandException("Missing arguments!", new Object[0]);
        }
        if (this.tabCompleteMode) {
            for (Zone z : APIRegistry.perms.getZones()) {
                if (!(z instanceof AreaZone)) continue;
                if (z.getName().startsWith(args.peek())) {
                    this.tabComplete.add(z.getName());
                }
                if (!Integer.toString(z.getId()).startsWith(args.peek())) continue;
                this.tabComplete.add(Integer.toString(z.getId()));
            }
            return;
        }
        String zoneName = args.remove();
        AreaZone zone = CommandZone.getAreaZone(worldZone, zoneName);
        if (zone == null) {
            OutputHandler.chatError(sender, String.format("Area \"%s\" has does not exist!", zoneName));
            return;
        }
        zone.getWorldZone().removeAreaZone(zone);
        OutputHandler.chatConfirmation(sender, String.format("Area \"%s\" has been deleted.", zoneName));
    }

    private void parseEntryExitMessage(ICommandSender sender, WorldZone worldZone, Queue<String> args, boolean isEntry) {
        if (this.tabCompleteMode) {
            if (args.size() == 1 && "clear".startsWith(args.peek().toLowerCase())) {
                this.tabComplete.add("clear");
            }
            return;
        }
        if (!PermissionsManager.checkPermission(new PermissionContext().setCommandSender(sender), PERM_SETTINGS)) {
            OutputHandler.chatError(sender, "You don't have permissions to use this command!");
            return;
        }
        if (worldZone == null) {
            throw new CommandException("No world found", new Object[0]);
        }
        if (args.isEmpty()) {
            throw new CommandException("Missing arguments!", new Object[0]);
        }
        String zoneName = args.remove();
        AreaZone zone = CommandZone.getAreaZone(worldZone, zoneName);
        if (zone == null) {
            throw new CommandException(String.format("Area \"%s\" does not exist!", zoneName), new Object[0]);
        }
        if (args.isEmpty()) {
            zone.getGroupPermission("_ALL_", isEntry ? "fe.internal.zone.entry" : "fe.internal.zone.exit");
        } else {
            String msg = StringUtils.join(args, (String)" ");
            if (msg.equalsIgnoreCase("clear")) {
                msg = null;
            }
            zone.setGroupPermissionProperty("_ALL_", isEntry ? "fe.internal.zone.entry" : "fe.internal.zone.exit", msg);
        }
    }

    @Override
    public void processCommandPlayer(EntityPlayerMP sender, String[] args) {
        LinkedList<String> argsList = new LinkedList<String>(Arrays.asList(args));
        this.tabCompleteMode = false;
        this.parse((ICommandSender)sender, argsList);
    }

    private static void help(ICommandSender sender) {
        OutputHandler.chatConfirmation(sender, "/zone list [page]: Lists all zones");
        OutputHandler.chatConfirmation(sender, "/zone info <zone>|here: Zone information");
        OutputHandler.chatConfirmation(sender, "/zone define|redefine <zone-name>: define or redefine a zone.");
        OutputHandler.chatConfirmation(sender, "/zone delete <zone-id>: Delete a zone.");
        OutputHandler.chatConfirmation(sender, "/zone entry|exit <zone-id> <message|clear>: Set the zone entry/exit message.");
    }

    @Override
    public String getPermissionNode() {
        return PERM_NODE;
    }

    @Override
    public boolean canConsoleUseCommand() {
        return false;
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        LinkedList<String> argsList = new LinkedList<String>(Arrays.asList(args));
        this.tabCompleteMode = true;
        this.tabComplete = new ArrayList<String>();
        this.parse(sender, argsList);
        return this.tabComplete;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/zone: Displays command help";
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.OP;
    }
}

