/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.permissions.autoPromote;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.api.permissions.WorldZone;
import com.forgeessentials.api.permissions.Zone;
import com.forgeessentials.commons.selections.WorldPoint;
import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.permissions.autoPromote.AutoPromote;
import com.forgeessentials.permissions.autoPromote.AutoPromoteManager;
import com.forgeessentials.util.FunctionHelper;
import com.forgeessentials.util.OutputHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandAutoPromote
extends ForgeEssentialsCommandBase {
    public String func_71517_b() {
        return "autopromote";
    }

    public List<String> func_71514_a() {
        return Arrays.asList("ap");
    }

    @Override
    public void processCommandPlayer(EntityPlayerMP sender, String[] args) {
        AutoPromote ap;
        Zone zone = APIRegistry.perms.getServerZone().getZoneAt(new WorldPoint((Entity)sender));
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase("world")) {
                zone = APIRegistry.perms.getServerZone().getWorldZone(sender.field_70170_p);
            }
            if (args[0].equalsIgnoreCase("global")) {
                zone = APIRegistry.perms.getServerZone();
            }
        }
        if ((ap = AutoPromoteManager.instance().promoteMap.get(zone.toString())) == null) {
            AutoPromoteManager.instance().promoteMap.put(zone.getId(), new AutoPromote(zone.getId(), false));
            ap = AutoPromoteManager.instance().promoteMap.get(zone.toString());
        }
        if (args.length == 0 || args.length == 1 || args[1].equalsIgnoreCase("get")) {
            String header = "--- AutoPromote for: " + ap.getZone() + " ---";
            OutputHandler.chatNotification((ICommandSender)sender, header);
            OutputHandler.chatNotification((ICommandSender)sender, "Enabled: " + (ap.isEnabled() ? EnumChatFormatting.GREEN : EnumChatFormatting.RED) + ap.isEnabled());
            OutputHandler.chatNotification((ICommandSender)sender, "Promotion times: ");
            for (String i : ap.getPromoteList().keySet()) {
                OutputHandler.chatNotification((ICommandSender)sender, " " + i + " > " + ap.getPromoteList().get(i));
            }
            StringBuilder footer = new StringBuilder();
            for (int i = 3; i < header.length(); ++i) {
                footer.append("-");
            }
            OutputHandler.chatNotification((ICommandSender)sender, footer.toString());
            return;
        }
        if (args[1].equalsIgnoreCase("enable")) {
            if (ap.isEnabled()) {
                OutputHandler.chatWarning((ICommandSender)sender, "AutoPromote for " + ap.getZone() + " was already enabled.");
            } else {
                ap.setEnabled(true);
                OutputHandler.chatConfirmation((ICommandSender)sender, "AutoPromote for " + ap.getZone() + " enabled.");
            }
        }
        if (args[1].equalsIgnoreCase("disable")) {
            if (!ap.isEnabled()) {
                OutputHandler.chatWarning((ICommandSender)sender, "AutoPromote for " + ap.getZone() + " was already disabled.");
            } else {
                ap.setEnabled(false);
                OutputHandler.chatConfirmation((ICommandSender)sender, "AutoPromote for " + ap.getZone() + " disabled.");
            }
        }
        if (args[1].equalsIgnoreCase("edit")) {
            String group;
            int i;
            if (args.length == 2) {
                OutputHandler.chatError((ICommandSender)sender, "Available options: 'del', 'add'");
            } else if (args[2].equalsIgnoreCase("del") || args[2].equalsIgnoreCase("delete")) {
                if (args.length == 4) {
                    i = CommandAutoPromote.func_71526_a((ICommandSender)sender, (String)args[3]);
                    if (ap.getPromoteList().containsKey(i)) {
                        group = ap.getPromoteList().remove(i);
                        OutputHandler.chatConfirmation((ICommandSender)sender, "You have removed " + i + ":" + group + " from the list.");
                    } else {
                        OutputHandler.chatError((ICommandSender)sender, args[3] + " is not a number in the list.");
                    }
                } else {
                    OutputHandler.chatError((ICommandSender)sender, "You have to specify a number to remvove from the list.");
                }
            } else if (args[2].equalsIgnoreCase("add")) {
                if (args.length == 5) {
                    i = CommandAutoPromote.func_71526_a((ICommandSender)sender, (String)args[3]);
                    if (!ap.getPromoteList().containsKey(i)) {
                        group = args[4];
                        if (!APIRegistry.perms.groupExists(group)) {
                            ap.getPromoteList().put(i + "", group);
                            OutputHandler.chatConfirmation((ICommandSender)sender, "You have added " + i + ":" + group + " to the list.");
                        } else {
                            OutputHandler.chatError((ICommandSender)sender, args[4] + " is not a valid group in " + zone.toString() + ".");
                        }
                    } else {
                        OutputHandler.chatError((ICommandSender)sender, args[3] + " is already on the list.");
                    }
                } else {
                    OutputHandler.chatError((ICommandSender)sender, "You have to specify a number and group to add to the list. (... add <time> <group>)");
                }
            }
        }
        if (args[1].equalsIgnoreCase("message")) {
            if (args.length == 2 || args[2].equalsIgnoreCase("get")) {
                OutputHandler.chatConfirmation((ICommandSender)sender, "Current message:");
                OutputHandler.sendMessage((ICommandSender)sender, FunctionHelper.formatColors(ap.getMsg()));
            } else if (args[2].equalsIgnoreCase("set")) {
                String newMsg = "";
                for (int i = 3; i < args.length; ++i) {
                    newMsg = newMsg + args[i] + " ";
                }
                ap.setMsg(newMsg.trim());
                OutputHandler.chatConfirmation((ICommandSender)sender, "New message:");
                OutputHandler.sendMessage((ICommandSender)sender, FunctionHelper.formatColors(ap.getMsg()));
            } else if (args[2].equalsIgnoreCase("enable")) {
                ap.setSendMsg(true);
                OutputHandler.chatConfirmation((ICommandSender)sender, "You enabled the promote message.");
            } else if (args[2].equalsIgnoreCase("disable")) {
                ap.setSendMsg(false);
                OutputHandler.chatConfirmation((ICommandSender)sender, "You disabled the promote message.");
            }
        }
        AutoPromoteManager.save(ap);
    }

    @Override
    public void processCommandConsole(ICommandSender sender, String[] args) {
    }

    @Override
    public boolean canConsoleUseCommand() {
        return true;
    }

    @Override
    public String getPermissionNode() {
        return "fe.perm.autoPromote";
    }

    private List<String> getZoneNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("here");
        list.add("global");
        list.add("world");
        for (WorldZone world : APIRegistry.perms.getServerZone().getWorldZones().values()) {
            for (Zone zone : world.getAreaZones()) {
                list.add(zone.toString());
            }
        }
        return list;
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CommandAutoPromote.func_71531_a((String[])args, this.getZoneNames());
        }
        if (args.length == 2) {
            return CommandAutoPromote.func_71530_a((String[])args, (String[])new String[]{"get", "enable", "disable", "edit", "message"});
        }
        if (args.length == 3 && args[1].equalsIgnoreCase("edit")) {
            return CommandAutoPromote.func_71530_a((String[])args, (String[])new String[]{"add", "del"});
        }
        if (args.length == 4 && args[1].equalsIgnoreCase("edit") && args[2].equalsIgnoreCase("del")) {
            try {
                AutoPromote ap;
                Zone zone = APIRegistry.perms.getServerZone().getZoneAt(new WorldPoint((Entity)sender));
                if (args[0].equalsIgnoreCase("world")) {
                    zone = APIRegistry.perms.getServerZone().getWorldZone(((Entity)sender).field_70170_p);
                }
                if (args[0].equalsIgnoreCase("global")) {
                    zone = APIRegistry.perms.getServerZone();
                }
                if ((ap = AutoPromoteManager.instance().promoteMap.get(zone.toString())) == null) {
                    AutoPromoteManager.instance().promoteMap.put(zone.getId(), new AutoPromote(zone.getId(), false));
                    ap = AutoPromoteManager.instance().promoteMap.get(zone.toString());
                }
                return CommandAutoPromote.func_71531_a((String[])args, ap.getList());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (args.length == 5 && args[1].equalsIgnoreCase("edit") && args[2].equalsIgnoreCase("add")) {
            try {
                Zone zone = APIRegistry.perms.getServerZone().getZoneAt(new WorldPoint((Entity)sender));
                if (args[0].equalsIgnoreCase("world")) {
                    zone = APIRegistry.perms.getServerZone().getWorldZone(((Entity)sender).field_70170_p);
                }
                if (args[0].equalsIgnoreCase("global")) {
                    zone = APIRegistry.perms.getServerZone();
                }
                return CommandAutoPromote.func_71531_a((String[])args, APIRegistry.perms.getServerZone().getGroups());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (args.length == 3 && args[1].equalsIgnoreCase("message")) {
            return CommandAutoPromote.func_71530_a((String[])args, (String[])new String[]{"get", "set", "enable", "disable"});
        }
        return null;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/autopromote <zone> [get|enable|disable|edit|add|message] [other options] Configure auto promotion.";
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.OP;
    }
}

