/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.permissions.autoPromote;

import com.forgeessentials.commons.IReconstructData;
import com.forgeessentials.commons.SaveableObject;
import com.forgeessentials.util.PlayerInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayerMP;

@SaveableObject
public class AutoPromote {
    @SaveableObject.UniqueLoadingKey
    @SaveableObject.SaveableField
    private int zone;
    @SaveableObject.SaveableField
    private boolean enabled;
    @SaveableObject.SaveableField
    private HashMap<String, String> promoteList;
    @SaveableObject.SaveableField
    private boolean sendMsg;
    @SaveableObject.SaveableField
    private String msg;

    public AutoPromote(int zone, boolean enable) {
        this.zone = zone;
        this.enabled = enable;
        this.promoteList = new HashMap();
        this.msg = "&5You have been promoted to %group for playing for %time.";
        this.sendMsg = true;
    }

    public int getZone() {
        return this.zone;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public HashMap<String, String> getPromoteList() {
        return this.promoteList;
    }

    public boolean isSendMsg() {
        return this.sendMsg;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setSendMsg(boolean sendMsg) {
        this.sendMsg = sendMsg;
    }

    @SaveableObject.Reconstructor
    private static AutoPromote reconstruct(IReconstructData tag) {
        AutoPromote data = new AutoPromote((Integer)tag.getFieldValue("zone"), (Boolean)tag.getFieldValue("enable"));
        try {
            data.promoteList = (HashMap)tag.getFieldValue("promoteList");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (data.promoteList == null) {
            data.promoteList = new HashMap();
        }
        return data;
    }

    public void tick(EntityPlayerMP player) {
        try {
            if (this.promoteList.containsKey(PlayerInfo.getPlayerInfo(player.getPersistentID()).getTimePlayed() + "")) {
                String groupName = this.promoteList.get(PlayerInfo.getPlayerInfo(player.getPersistentID()).getTimePlayed() + "");
                throw new RuntimeException("Not yet implemented!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList<String> getList() {
        ArrayList<String> result = new ArrayList<String>();
        for (String i : this.promoteList.keySet()) {
            result.add(i);
        }
        Collections.sort(result);
        return result;
    }
}

