/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.permissions;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.core.ForgeEssentials;
import com.forgeessentials.core.moduleLauncher.FEModule;
import com.forgeessentials.core.moduleLauncher.config.IConfigLoader;
import com.forgeessentials.permissions.autoPromote.AutoPromoteManager;
import com.forgeessentials.permissions.autoPromote.CommandAutoPromote;
import com.forgeessentials.permissions.commands.CommandPermissions;
import com.forgeessentials.permissions.commands.CommandZone;
import com.forgeessentials.permissions.core.ZonedPermissionHelper;
import com.forgeessentials.permissions.persistence.FlatfileProvider;
import com.forgeessentials.permissions.persistence.JsonProvider;
import com.forgeessentials.permissions.persistence.SQLProvider;
import com.forgeessentials.util.DBConnector;
import com.forgeessentials.util.EnumDBType;
import com.forgeessentials.util.FunctionHelper;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.events.FEModuleEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.io.IOException;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.permissions.PermissionsManager;
import org.apache.commons.io.FileUtils;

@FEModule(name="Permissions", parentMod=ForgeEssentials.class, canDisable=false)
public class ModulePermissions
extends IConfigLoader.ConfigLoaderBase {
    private static final String CONFIG_CAT = "Permissions";
    public static AutoPromoteManager autoPromoteManager;
    public static ZonedPermissionHelper permissionHelper;
    private String persistenceBackend = "flatfile";
    private DBConnector dbConnector = new DBConnector("Permissions", null, EnumDBType.H2_FILE, "ForgeEssentials", ForgeEssentials.getFEDirectory().getPath() + "/permissions", false);

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void preLoad(FEModuleEvent.FEModulePreInitEvent e) {
        permissionHelper = new ZonedPermissionHelper();
        APIRegistry.perms = permissionHelper;
        PermissionsManager.setPermProvider(permissionHelper);
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void serverStarting(FEModuleEvent.FEModuleServerInitEvent e) {
        try {
            File path = new File(FunctionHelper.getWorldPath(), "FEData");
            File backupPath = new File(FunctionHelper.getWorldPath(), "FEData_backup");
            if (backupPath.exists()) {
                FileUtils.deleteDirectory((File)backupPath);
            }
            FileUtils.copyDirectory((File)path, (File)backupPath);
        }
        catch (IOException ex) {
            OutputHandler.felog.warning("Unable to create FEData backup");
        }
        switch (this.persistenceBackend.toLowerCase()) {
            case "sql": {
                permissionHelper.setPersistenceProvider(new SQLProvider(this.dbConnector.getChosenConnection(), this.dbConnector.getActiveType()));
                break;
            }
            case "json": {
                permissionHelper.setPersistenceProvider(new JsonProvider(new File(FunctionHelper.getWorldPath(), "FEData/json")));
                break;
            }
            default: {
                permissionHelper.setPersistenceProvider(new FlatfileProvider(new File(FunctionHelper.getWorldPath(), "FEData/permissions")));
            }
        }
        permissionHelper.load();
        new CommandZone().register();
        new CommandPermissions().register();
        new CommandAutoPromote().register();
        ModulePermissions.registerPermissions();
        autoPromoteManager = new AutoPromoteManager();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void serverStarted(FEModuleEvent.FEModuleServerPostInitEvent e) {
        permissionHelper.save();
    }

    @SubscribeEvent
    public void serverStopping(FEModuleEvent.FEModuleServerStopEvent e) {
        autoPromoteManager.stop();
        permissionHelper.save();
    }

    private static void registerPermissions() {
        APIRegistry.perms.registerPermissionDescription("fe.internal", "Internal permissions - DO NOT TOUCH THESE UNLESS YOU KNOW WHAT YOU DO (WHICH YOU DON'T!)");
        APIRegistry.perms.registerPermissionDescription("fe.internal.group", "(optional) Permission to keep groups saved, even if they have no permissions set.");
        APIRegistry.perms.registerPermissionDescription("fe.internal.group.id", "Group ID");
        APIRegistry.perms.registerPermissionDescription("fe.internal.group.priority", "Group priority");
        APIRegistry.perms.registerPermissionDescription("fe.internal.group.includes", "Groups that are included using the included group's priority");
        APIRegistry.perms.registerPermissionDescription("fe.internal.group.parents", "Groups that are included using the including group's priority");
        APIRegistry.perms.registerPermissionDescription("fe.internal.player", "Player information");
        APIRegistry.perms.registerPermissionDescription("fe.internal.player.groups", "Comma separated list of player groups");
        APIRegistry.perms.registerPermissionDescription("fe.internal.player.name", "Player name");
        APIRegistry.perms.registerPermissionDescription("fe.internal.player.uuid", "Player UUID");
        APIRegistry.perms.registerPermissionDescription("fe.internal.prefix", "Prefix property node");
        APIRegistry.perms.registerPermissionDescription("fe.internal.suffix", "Suffix property node");
        APIRegistry.perms.registerPermissionDescription("fe.internal.zone.entry", "Zone entry message");
        APIRegistry.perms.registerPermissionDescription("fe.internal.zone.exit", "Zone exit message");
        APIRegistry.perms.registerPermissionProperty("fe.internal.spawn", "bed", "Player spawn property");
        APIRegistry.perms.registerPermissionDescription("fe.perm.zone", "Permission nodes for area-management command");
        APIRegistry.perms.registerPermission("fe.perm.zone.*", PermissionsManager.RegisteredPermValue.OP);
        APIRegistry.perms.registerPermission("fe.perm.zone.list", PermissionsManager.RegisteredPermValue.TRUE);
        APIRegistry.perms.registerPermission("fe.perm.zone.info", PermissionsManager.RegisteredPermValue.TRUE);
        APIRegistry.perms.registerPermission("fe.perm", PermissionsManager.RegisteredPermValue.TRUE, "Basic usage of permission-management command");
        APIRegistry.perms.registerPermission("fe.perm.*", PermissionsManager.RegisteredPermValue.OP);
        APIRegistry.perms.registerPermission("fe.perm.user", PermissionsManager.RegisteredPermValue.OP, "Allow basic access to users (displays infos)");
        APIRegistry.perms.registerPermission("fe.perm.user.perms", PermissionsManager.RegisteredPermValue.OP, "Allow modifying user permissions");
        APIRegistry.perms.registerPermission("fe.perm.user.spawn", PermissionsManager.RegisteredPermValue.OP, "Allow setting user spawn");
        APIRegistry.perms.registerPermission("fe.perm.user.fix", PermissionsManager.RegisteredPermValue.OP, "Allow setting user prefix / suffix");
        APIRegistry.perms.registerPermission("fe.perm.group", PermissionsManager.RegisteredPermValue.OP, "Allow basic access to groups (displays infos)");
        APIRegistry.perms.registerPermission("fe.perm.group.perms", PermissionsManager.RegisteredPermValue.OP, "Allow modifying group permissions");
        APIRegistry.perms.registerPermission("fe.perm.group.spawn", PermissionsManager.RegisteredPermValue.OP, "Allow setting group spawn");
        APIRegistry.perms.registerPermission("fe.perm.group.fix", PermissionsManager.RegisteredPermValue.OP, "Allow setting group prefix / suffix");
        APIRegistry.perms.registerPermission("fe.perm.list.users", PermissionsManager.RegisteredPermValue.OP, "Allow listing users");
        APIRegistry.perms.registerPermission("fe.perm.list.groups", PermissionsManager.RegisteredPermValue.OP, "Allow listing groups");
        APIRegistry.perms.registerPermission("fe.perm.list.zones", PermissionsManager.RegisteredPermValue.OP, "Allow listing zones");
        APIRegistry.perms.registerPermission("fe.perm.list.perms", PermissionsManager.RegisteredPermValue.TRUE, "Allow listing all permissions affecting current user");
        APIRegistry.perms.registerPermission("fe.perm.test", PermissionsManager.RegisteredPermValue.TRUE, "Allow testing permission nodes");
        APIRegistry.perms.registerPermission("fe.perm.reload", PermissionsManager.RegisteredPermValue.TRUE, "Allow reloading changed permission files");
        APIRegistry.perms.registerPermission("fe.perm.save", PermissionsManager.RegisteredPermValue.TRUE, "Allow force-saving permission files");
        APIRegistry.perms.registerPermission("fe.perm.debug", PermissionsManager.RegisteredPermValue.OP, "Allow using permission-debug command");
        APIRegistry.perms.registerPermission("fe.perm.autoPromote", PermissionsManager.RegisteredPermValue.OP);
        APIRegistry.perms.registerPermission("fe.core.info", PermissionsManager.RegisteredPermValue.OP);
    }

    @Override
    public void load(Configuration config, boolean isReload) {
        this.persistenceBackend = config.get(CONFIG_CAT, "persistenceBackend", "flatfile", "Choose a permission persistence backend (flatfile, sql, json)").getString();
        this.dbConnector.loadOrGenerate(config, "Permissions.SQL");
    }

    public DBConnector getDbConnector() {
        return this.dbConnector;
    }
}

