/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.perftools;

import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.util.OutputHandler;
import com.google.common.collect.HashMultimap;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandChunkLoaderList
extends ForgeEssentialsCommandBase {
    @Override
    public String getPermissionNode() {
        return "fe.perftools.chunkloaderlist";
    }

    public String func_71517_b() {
        return "chunkloaderlist";
    }

    @Override
    public void processCommandPlayer(EntityPlayerMP sender, String[] args) {
        String key = "*";
        if (args.length != 0) {
            String target = "";
            for (String s : args) {
                target = target + " " + s;
            }
            target = target.substring(1).trim();
            List<String> allUsernames = Arrays.asList(MinecraftServer.func_71276_C().func_71203_ab().func_72373_m());
            for (String username : allUsernames) {
                if (!username.equalsIgnoreCase(target)) continue;
                key = "p:" + username;
                break;
            }
            for (ModContainer mod : Loader.instance().getActiveModList()) {
                if (mod.getName().equalsIgnoreCase(target)) {
                    key = "m:" + mod.getModId();
                    continue;
                }
                if (!mod.getModId().equalsIgnoreCase(target)) continue;
                key = "m:" + mod.getModId();
            }
        }
        this.list((ICommandSender)sender, key);
    }

    @Override
    public void processCommandConsole(ICommandSender sender, String[] args) {
        this.list(sender, "*");
    }

    private void list(ICommandSender sender, String key) {
        Integer[] arr$ = DimensionManager.getIDs();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int i = arr$[i$];
            this.list(sender, i, key);
        }
    }

    private void list(ICommandSender sender, int dim, String key) {
        HashSet<ChunkCoordIntPair> chunks;
        WorldServer world = DimensionManager.getWorld((int)dim);
        HashMultimap modTickets = HashMultimap.create();
        HashMultimap playerTickets = HashMultimap.create();
        for (ForgeChunkManager.Ticket ticket : ForgeChunkManager.getPersistentChunksFor((World)world).values()) {
            if (ticket.isPlayerTicket()) {
                playerTickets.put((Object)ticket.getPlayerName(), (Object)ticket);
                continue;
            }
            modTickets.put((Object)ticket.getModId(), (Object)ticket);
        }
        if (modTickets.isEmpty() && playerTickets.isEmpty()) {
            return;
        }
        if (!key.equals("*")) {
            OutputHandler.chatNotification(sender, EnumChatFormatting.UNDERLINE + "ChunkLoaders for " + key.split(":", 2)[1] + ":");
        }
        OutputHandler.chatNotification(sender, "Dim " + world.field_73011_w.func_80007_l() + ":");
        if (key.startsWith("p:") || key.equals("*")) {
            for (String username : playerTickets.keySet()) {
                if (!key.replace("p:", "").equalsIgnoreCase(username) && !key.equals("*")) continue;
                if (key.equals("*")) {
                    OutputHandler.chatNotification(sender, username);
                }
                chunks = new HashSet<ChunkCoordIntPair>();
                for (ForgeChunkManager.Ticket ticket : playerTickets.get((Object)username)) {
                    for (Object obj : ticket.getChunkList()) {
                        chunks.add((ChunkCoordIntPair)obj);
                    }
                }
                for (ChunkCoordIntPair coords : chunks) {
                    OutputHandler.chatNotification(sender, coords.func_77273_a() + " : " + coords.func_77274_b());
                }
            }
        }
        if (key.startsWith("m:") || key.equals("*")) {
            for (String modID : modTickets.keySet()) {
                if (key.equals("*")) {
                    OutputHandler.chatNotification(sender, modID);
                }
                chunks = new HashSet();
                for (ForgeChunkManager.Ticket ticket : playerTickets.get((Object)modID)) {
                    for (Object obj : ticket.getChunkList()) {
                        chunks.add((ChunkCoordIntPair)obj);
                    }
                }
                for (ChunkCoordIntPair coords : chunks) {
                    OutputHandler.chatNotification(sender, coords.func_77273_a() + " : " + coords.func_77274_b());
                }
            }
        }
    }

    @Override
    public boolean canConsoleUseCommand() {
        return false;
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            ArrayList<String> options = new ArrayList<String>();
            for (String s : MinecraftServer.func_71276_C().func_71203_ab().func_72373_m()) {
                options.add(s);
            }
            for (ModContainer mod : Loader.instance().getActiveModList()) {
                options.add(mod.getName());
            }
            return CommandChunkLoaderList.func_71531_a((String[])args, options);
        }
        return null;
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.OP;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/chunkloaderlist Lists all active chunk loaders.";
    }
}

