/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.multiworld.gen;

import com.forgeessentials.multiworld.WorldServerMultiworld;
import com.forgeessentials.multiworld.gen.GenLayerMultiworldBiome;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.biome.WorldChunkManagerHell;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderFlat;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraft.world.gen.FlatGeneratorInfo;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerBiome;
import net.minecraft.world.gen.layer.GenLayerBiomeEdge;
import net.minecraft.world.gen.layer.GenLayerZoom;

public class WorldTypeMultiworld
extends WorldType {
    private WorldServerMultiworld currentMultiworld;

    public WorldTypeMultiworld() {
        super("multiworld");
    }

    public WorldChunkManager getChunkManager(World world) {
        this.currentMultiworld = world instanceof WorldServerMultiworld ? (WorldServerMultiworld)world : null;
        if (this == field_77138_c) {
            FlatGeneratorInfo flatgeneratorinfo = FlatGeneratorInfo.func_82651_a((String)world.func_72912_H().func_82571_y());
            return new WorldChunkManagerHell(BiomeGenBase.func_150568_d((int)flatgeneratorinfo.func_82648_a()), 0.5f);
        }
        return new WorldChunkManager(world);
    }

    public IChunkProvider getChunkGenerator(World world, String generatorOptions) {
        if (this == field_77138_c) {
            return new ChunkProviderFlat(world, world.func_72905_C(), world.func_72912_H().func_76089_r(), generatorOptions);
        }
        return new ChunkProviderGenerate(world, world.func_72905_C(), world.func_72912_H().func_76089_r());
    }

    public GenLayer getBiomeLayer(long worldSeed, GenLayer parentLayer) {
        if (this.currentMultiworld == null) {
            GenLayerBiome ret = new GenLayerBiome(200L, parentLayer, (WorldType)this);
            ret = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)ret, (int)2);
            ret = new GenLayerBiomeEdge(1000L, (GenLayer)ret);
            return ret;
        }
        GenLayerMultiworldBiome ret = new GenLayerMultiworldBiome(200L, parentLayer, this.currentMultiworld);
        ret = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)ret, (int)2);
        ret = new GenLayerBiomeEdge(1000L, (GenLayer)ret);
        return ret;
    }

    public int getMinimumSpawnHeight(World world) {
        return this == field_77138_c ? 4 : 64;
    }

    public double getHorizon(World world) {
        return this == field_77138_c ? 0.0 : 63.0;
    }

    public boolean hasVoidParticles(boolean flag) {
        return this != field_77138_c && !flag;
    }

    public double voidFadeMagnitude() {
        return this == field_77138_c ? 1.0 : 0.03125;
    }

    public boolean handleSlimeSpawnReduction(Random random, World world) {
        return this == field_77138_c ? random.nextInt(4) != 1 : false;
    }

    public float getCloudHeight() {
        return 128.0f;
    }
}

