/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.multiworld.command;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.multiworld.ModuleMultiworld;
import com.forgeessentials.multiworld.Multiworld;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.UserIdent;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.WorldServer;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandMultiworldTeleport
extends ForgeEssentialsCommandBase {
    public String func_71517_b() {
        return "mwtp";
    }

    public String func_71518_a(ICommandSender commandSender) {
        return "/mwtp <world> [player] [x y z]";
    }

    public List<String> func_71516_a(ICommandSender sender, String[] argsArray) {
        switch (argsArray.length) {
            case 1: {
                return ForgeEssentialsCommandBase.getListOfStringsMatchingLastWord(argsArray[0], (Collection<String>)ModuleMultiworld.getMultiworldManager().getWorldMap().keySet());
            }
            case 2: {
                return ForgeEssentialsCommandBase.completePlayername(argsArray[1]);
            }
        }
        return null;
    }

    @Override
    public void func_71515_b(ICommandSender sender, String[] argsArray) {
        Multiworld multiworld;
        WorldServer world;
        EntityPlayerMP player = sender instanceof EntityPlayerMP ? (EntityPlayerMP)sender : null;
        LinkedList<String> args = new LinkedList<String>(Arrays.asList(argsArray));
        if (args.isEmpty()) {
            throw new CommandException("Missing world argument.", new Object[0]);
        }
        String worldName = (String)args.remove();
        if (args.isEmpty()) {
            if (player == null) {
                throw new CommandException("Missing player-name argument.", new Object[0]);
            }
        } else {
            String playerName = (String)args.remove();
            player = UserIdent.getPlayerByMatchOrUsername(sender, playerName);
            if (player == null) {
                throw new CommandException("Could not find player " + playerName, new Object[0]);
            }
        }
        double x = Math.floor(player.field_70165_t) + 0.5;
        double y = Math.floor(player.field_70163_u);
        double z = Math.floor(player.field_70161_v) + 0.5;
        if (!args.isEmpty()) {
            if (args.size() < 3) {
                throw new CommandException("Too few arguments for location.", new Object[0]);
            }
            x = CommandMultiworldTeleport.func_82363_b((ICommandSender)sender, (String)((String)args.remove()));
            y = CommandMultiworldTeleport.func_82363_b((ICommandSender)sender, (String)((String)args.remove()));
            z = CommandMultiworldTeleport.func_82363_b((ICommandSender)sender, (String)((String)args.remove()));
        }
        WorldServer worldServer = world = (multiworld = ModuleMultiworld.getMultiworldManager().getMultiworld(worldName)) != null ? multiworld.getWorldServer() : APIRegistry.namedWorldHandler.getWorld(worldName);
        if (world == null) {
            throw new CommandException("Could not find world " + worldName, new Object[0]);
        }
        int dimId = world.field_73011_w.field_76574_g;
        String msg = "Teleporting to ";
        if (multiworld == null) {
            switch (dimId) {
                case 0: {
                    msg = msg + "the overworld";
                    break;
                }
                case 1: {
                    msg = msg + "the nether";
                    break;
                }
                case -1: {
                    msg = msg + "the end";
                    break;
                }
                default: {
                    msg = msg + "dimension #" + dimId;
                    break;
                }
            }
        } else {
            msg = msg + multiworld.getName();
        }
        msg = msg + String.format(" at [%.0f, %.0f, %.0f]", x, y, z);
        OutputHandler.chatConfirmation((ICommandSender)player, msg);
        Multiworld.teleport(player, world, x, y, z, true);
    }

    @Override
    public boolean canConsoleUseCommand() {
        return true;
    }

    @Override
    public String getPermissionNode() {
        return "fe.multiworld.teleport";
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.OP;
    }
}

