/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.multiworld.command;

import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.multiworld.ModuleMultiworld;
import com.forgeessentials.multiworld.Multiworld;
import com.forgeessentials.multiworld.MultiworldException;
import com.forgeessentials.util.OutputHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.WorldType;
import net.minecraftforge.permissions.PermissionContext;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandMultiworld
extends ForgeEssentialsCommandBase {
    private ICommandSender sender;
    private EntityPlayerMP senderPlayer;
    private Queue<String> args;
    private PermissionContext permissionContext;
    private boolean tabCompleteMode;
    private List<String> tabComplete;
    private static String[] parseMainArgs = new String[]{"create", "delete", "list"};
    private static String[] parseListArgs = new String[]{"worlds", "providers", "worldtypes"};

    public String func_71517_b() {
        return "mw";
    }

    public String func_71518_a(ICommandSender commandSender) {
        return "/mw Multiworld management command";
    }

    @Override
    public boolean canConsoleUseCommand() {
        return true;
    }

    @Override
    public String getPermissionNode() {
        return "fe.multiworld";
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.OP;
    }

    private void info(String message2) {
        if (!this.tabCompleteMode) {
            OutputHandler.chatConfirmation(this.sender, message2);
        }
    }

    @Override
    public void func_71515_b(ICommandSender sender, String[] args) {
        this.args = new LinkedList<String>(Arrays.asList(args));
        this.sender = sender;
        this.senderPlayer = sender instanceof EntityPlayerMP ? (EntityPlayerMP)sender : null;
        this.tabCompleteMode = false;
        this.permissionContext = new PermissionContext().setCommandSender(sender).setCommand((ICommand)this);
        this.parseMain();
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        this.args = new LinkedList<String>(Arrays.asList(args));
        this.sender = sender;
        this.senderPlayer = sender instanceof EntityPlayerMP ? (EntityPlayerMP)sender : null;
        this.tabCompleteMode = true;
        this.tabComplete = null;
        this.permissionContext = new PermissionContext().setCommandSender(sender).setCommand((ICommand)this);
        this.parseMain();
        return this.tabComplete;
    }

    private void parseMain() {
        String mainArg;
        if (this.args.isEmpty()) {
            this.info("Multiworld Usage:");
            this.info("/mw create (world) : Create a new world (? for usage)");
            this.info("/mw delete (world) : Delete a world");
            this.info("/mw list [worlds|providers|worldtypes]");
            return;
        }
        if (this.tabCompleteMode && this.args.size() == 1) {
            this.tabComplete = ForgeEssentialsCommandBase.getListOfStringsMatchingLastWord(this.args.peek(), parseMainArgs);
            return;
        }
        switch (mainArg = this.args.remove().toLowerCase()) {
            case "create": {
                this.parseCreate();
                break;
            }
            case "delete": {
                this.parseDelete();
                break;
            }
            case "list": {
                this.parseList();
                break;
            }
            default: {
                throw new CommandException("Unknown subcommand: " + mainArg, new Object[0]);
            }
        }
    }

    private void parseCreate() {
        if (this.senderPlayer != null && !PermissionsManager.checkPermission(this.permissionContext, "fe.multiworld.create")) {
            return;
        }
        if (this.args.isEmpty()) {
            throw new CommandException("Missing name argument", new Object[0]);
        }
        String name = this.args.remove().toLowerCase();
        if (name.equals("?")) {
            this.info("Usage: /mw create (name) [provider] [worldType] [seed]");
            return;
        }
        String provider = "normal";
        if (this.tabCompleteMode && this.args.size() == 1) {
            this.tabComplete = ForgeEssentialsCommandBase.getListOfStringsMatchingLastWord(this.args.peek(), ModuleMultiworld.getMultiworldManager().getWorldProviders().keySet());
            return;
        }
        if (!this.args.isEmpty()) {
            provider = this.args.remove();
        }
        String worldType = WorldType.field_77137_b.func_77127_a();
        if (this.tabCompleteMode && this.args.size() == 1) {
            this.tabComplete = ForgeEssentialsCommandBase.getListOfStringsMatchingLastWord(this.args.peek(), ModuleMultiworld.getMultiworldManager().getWorldTypes().keySet());
            return;
        }
        if (!this.args.isEmpty()) {
            worldType = this.args.remove();
        }
        long seed = new Random().nextLong();
        if (!this.args.isEmpty()) {
            String arg = this.args.remove();
            try {
                seed = Long.parseLong(arg, 10);
            }
            catch (NumberFormatException e) {
                seed = arg.hashCode();
            }
        }
        if (!this.args.isEmpty()) {
            throw new CommandException("Too many arguments", new Object[0]);
        }
        if (this.tabCompleteMode) {
            return;
        }
        Multiworld world = new Multiworld(name, provider, worldType, seed);
        try {
            ModuleMultiworld.getMultiworldManager().addWorld(world);
            if (this.senderPlayer != null) {
                world.teleport(this.senderPlayer, true);
            }
        }
        catch (MultiworldException e) {
            throw new CommandException(e.type.error, new Object[0]);
        }
    }

    private void parseDelete() {
        if (this.tabCompleteMode) {
            if (this.args.size() > 1) {
                return;
            }
            this.tabComplete = ForgeEssentialsCommandBase.getListOfStringsMatchingLastWord(this.args.peek(), (Collection<String>)ModuleMultiworld.getMultiworldManager().getWorldMap().keySet());
            return;
        }
        if (this.args.isEmpty()) {
            throw new CommandException("Too few arguments!", new Object[0]);
        }
        if (!this.tabCompleteMode && !PermissionsManager.checkPermission(this.permissionContext, "fe.multiworld.delete")) {
            OutputHandler.chatError(this.sender, "You don't have permissions to use this command!");
            return;
        }
        Multiworld world = ModuleMultiworld.getMultiworldManager().getMultiworld(this.args.peek());
        if (world == null) {
            throw new CommandException("Multiworld " + this.args.peek() + " does not exist!", new Object[0]);
        }
        ModuleMultiworld.getMultiworldManager().deleteWorld(world);
        this.info("Deleted Multiworld #" + this.args.peek());
    }

    private void parseList() {
        String subArg;
        if (this.tabCompleteMode) {
            if (this.args.size() > 1) {
                return;
            }
            this.tabComplete = ForgeEssentialsCommandBase.getListOfStringsMatchingLastWord(this.args.peek(), parseListArgs);
            return;
        }
        if (!this.tabCompleteMode && !PermissionsManager.checkPermission(this.permissionContext, "fe.multiworld.list")) {
            OutputHandler.chatError(this.sender, "You don't have permissions to use this command!");
            return;
        }
        switch (subArg = this.args.isEmpty() ? "worlds" : this.args.remove().toLowerCase()) {
            case "providers": {
                this.info("Available world providers:");
                for (String provider : ModuleMultiworld.getMultiworldManager().getWorldProviders().keySet()) {
                    this.info("  " + provider);
                }
                break;
            }
            case "worldtypes": {
                this.info("Available world types:");
                for (String worldType : ModuleMultiworld.getMultiworldManager().getWorldTypes().keySet()) {
                    this.info("  " + worldType);
                }
                break;
            }
            default: {
                this.info("Available worlds:");
                for (Multiworld world : ModuleMultiworld.getMultiworldManager().getWorlds()) {
                    this.info("#" + world.getDimensionId() + " " + world.getName() + ": " + world.getProvider());
                }
            }
        }
    }
}

