/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.multiworld;

import com.forgeessentials.multiworld.Multiworld;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.StartupQuery;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.storage.IPlayerFileData;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;

public class MultiworldSaveHandler
implements ISaveHandler {
    private SaveHandler parent;
    private Multiworld world;

    public MultiworldSaveHandler(ISaveHandler parent, Multiworld world) {
        if (!(parent instanceof SaveHandler)) {
            throw new RuntimeException();
        }
        this.parent = (SaveHandler)parent;
        this.world = world;
    }

    public File getDimensionDirectory() {
        return new File(this.func_75765_b(), "FEMultiworld/" + this.world.getName());
    }

    public IChunkLoader func_75763_a(WorldProvider provider) {
        return new AnvilChunkLoader(this.getDimensionDirectory());
    }

    public WorldInfo func_75757_d() {
        File file1 = new File(this.getDimensionDirectory(), "level.dat");
        if (file1.exists()) {
            try {
                NBTTagCompound nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file1));
                NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("Data");
                WorldInfo worldInfo = new WorldInfo(nbttagcompound1);
                return worldInfo;
            }
            catch (StartupQuery.AbortedException e) {
                throw e;
            }
            catch (Exception exception1) {
                exception1.printStackTrace();
            }
        }
        if ((file1 = new File(this.getDimensionDirectory(), "level.dat_old")).exists()) {
            try {
                NBTTagCompound nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file1));
                NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("Data");
                WorldInfo worldInfo = new WorldInfo(nbttagcompound1);
                return worldInfo;
            }
            catch (StartupQuery.AbortedException e) {
                throw e;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public void func_75762_c() throws MinecraftException {
        this.parent.func_75762_c();
    }

    public void saveWorldInfoData(WorldInfo p_75755_1_, NBTTagCompound data) {
        NBTTagCompound dataTag = new NBTTagCompound();
        dataTag.func_74782_a("Data", (NBTBase)data);
        FMLCommonHandler.instance().handleWorldDataSave(this.parent, p_75755_1_, dataTag);
        try {
            File file1 = new File(this.getDimensionDirectory(), "level.dat_new");
            File file2 = new File(this.getDimensionDirectory(), "level.dat_old");
            File file3 = new File(this.getDimensionDirectory(), "level.dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)dataTag, (OutputStream)new FileOutputStream(file1));
            if (file2.exists()) {
                file2.delete();
            }
            file3.renameTo(file2);
            if (file3.exists()) {
                file3.delete();
            }
            file1.renameTo(file3);
            if (file1.exists()) {
                file1.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void func_75755_a(WorldInfo worldInfo, NBTTagCompound playerInfo) {
        this.saveWorldInfoData(worldInfo, worldInfo.func_76082_a(playerInfo));
    }

    public void func_75761_a(WorldInfo worldInfo) {
        this.saveWorldInfoData(worldInfo, worldInfo.func_76066_a());
    }

    public IPlayerFileData func_75756_e() {
        return this.parent.func_75756_e();
    }

    public void func_75759_a() {
        this.parent.func_75759_a();
    }

    public File func_75765_b() {
        return this.parent.func_75765_b();
    }

    public File func_75758_b(String name) {
        return this.parent.func_75758_b(name);
    }

    public String func_75760_g() {
        return this.parent.func_75760_g();
    }
}

