/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.multiworld;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.api.NamedWorldHandler;
import com.forgeessentials.api.permissions.WorldZone;
import com.forgeessentials.data.v2.DataManager;
import com.forgeessentials.multiworld.Multiworld;
import com.forgeessentials.multiworld.MultiworldEventHandler;
import com.forgeessentials.multiworld.MultiworldException;
import com.forgeessentials.multiworld.MultiworldSaveHandler;
import com.forgeessentials.multiworld.WorldServerMultiworld;
import com.forgeessentials.multiworld.gen.WorldTypeMultiworld;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.events.ServerEventHandler;
import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.IWorldAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldManager;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.network.ForgeMessage;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.commons.io.FileUtils;

public class MultiworldManager
extends ServerEventHandler
implements NamedWorldHandler {
    public static final String PERM_PROP_MULTIWORLD = "fe.internal.multiworld";
    public static final String PROVIDER_NORMAL = "normal";
    public static final String PROVIDER_HELL = "nether";
    public static final String PROVIDER_END = "end";
    public static final WorldTypeMultiworld WORLD_TYPE_MULTIWORLD = new WorldTypeMultiworld();
    protected Map<String, Multiworld> worlds = new HashMap<String, Multiworld>();
    protected Map<Integer, Multiworld> worldsByDim = new HashMap<Integer, Multiworld>();
    protected Map<String, Integer> worldProviderClasses = new HashMap<String, Integer>();
    protected Map<String, WorldType> worldTypes = new HashMap<String, WorldType>();
    protected ArrayList<WorldServer> worldsToDelete = new ArrayList();
    protected ArrayList<WorldServer> worldsToRemove = new ArrayList();
    protected MultiworldEventHandler eventHandler = new MultiworldEventHandler(this);
    private NamedWorldHandler parentNamedWorldHandler = APIRegistry.namedWorldHandler;

    public MultiworldManager() {
        APIRegistry.namedWorldHandler = this;
    }

    public void saveAll() {
        for (Multiworld world : this.getWorlds()) {
            world.save();
        }
    }

    public void load() {
        DimensionManager.loadDimensionDataMap(null);
        Map<String, Multiworld> loadedWorlds = DataManager.getInstance().loadAll(Multiworld.class);
        block6: for (Multiworld world : loadedWorlds.values()) {
            this.worlds.put(world.getName(), world);
            try {
                this.loadWorld(world);
            }
            catch (MultiworldException e) {
                switch (e.type) {
                    case NO_PROVIDER: {
                        OutputHandler.felog.severe(String.format(e.type.error, world.provider));
                        continue block6;
                    }
                    case NO_WORLDTYPE: {
                        OutputHandler.felog.severe(String.format(e.type.error, world.worldType));
                        continue block6;
                    }
                }
                OutputHandler.felog.severe(e.type.error);
            }
        }
    }

    public Collection<Multiworld> getWorlds() {
        return this.worlds.values();
    }

    public ImmutableMap<String, Multiworld> getWorldMap() {
        return ImmutableMap.copyOf(this.worlds);
    }

    public Set<Integer> getDimensions() {
        return this.worldsByDim.keySet();
    }

    public Multiworld getMultiworld(int dimensionId) {
        return this.worldsByDim.get(dimensionId);
    }

    public Multiworld getMultiworld(String name) {
        return this.worlds.get(name);
    }

    @Override
    public WorldServer getWorld(String name) {
        WorldServer world = this.parentNamedWorldHandler.getWorld(name);
        if (world != null) {
            return world;
        }
        Multiworld mw = this.getMultiworld(name);
        if (mw != null) {
            return mw.getWorldServer();
        }
        return null;
    }

    @Override
    public String getWorldName(int dimId) {
        Multiworld mw = this.getMultiworld(dimId);
        if (mw != null) {
            return mw.getName();
        }
        return this.parentNamedWorldHandler.getWorldName(dimId);
    }

    public void addWorld(Multiworld world) throws MultiworldException {
        if (this.worlds.containsKey(world.getName())) {
            throw new MultiworldException(MultiworldException.Type.ALREADY_EXISTS);
        }
        this.loadWorld(world);
        this.worlds.put(world.getName(), world);
        world.save();
    }

    public static int getFreeDimensionId() {
        int id = 10;
        while (DimensionManager.isDimensionRegistered((int)id)) {
            ++id;
        }
        return id;
    }

    protected void loadWorld(Multiworld world) throws MultiworldException {
        if (world.worldLoaded) {
            return;
        }
        try {
            world.providerId = this.getWorldProviderId(world.provider);
            world.worldTypeObj = this.getWorldTypeByName(world.worldType);
            if (DimensionManager.isDimensionRegistered((int)world.dimensionId)) {
                world.dimensionId = MultiworldManager.getFreeDimensionId();
            }
            MultiworldManager.checkMultiworldPermissions(world);
            APIRegistry.perms.getServerZone().getWorldZone(world.dimensionId).setGroupPermissionProperty("_ALL_", PERM_PROP_MULTIWORLD, world.getName());
            DimensionManager.registerDimension((int)world.dimensionId, (int)world.providerId);
            this.worldsByDim.put(world.dimensionId, world);
            MinecraftServer mcServer = MinecraftServer.func_71276_C();
            WorldServer overworld = DimensionManager.getWorld((int)0);
            if (overworld == null) {
                throw new RuntimeException("Cannot hotload dim: Overworld is not Loaded!");
            }
            MultiworldSaveHandler savehandler = new MultiworldSaveHandler(overworld.func_72860_G(), world);
            WorldSettings worldSettings = new WorldSettings(world.seed, WorldSettings.GameType.SURVIVAL, world.mapFeaturesEnabled, false, world.worldTypeObj);
            WorldServerMultiworld worldServer = new WorldServerMultiworld(mcServer, savehandler, overworld.func_72912_H().func_76065_j(), world.dimensionId, worldSettings, overworld, mcServer.field_71304_b, world);
            worldServer.func_72954_a((IWorldAccess)new WorldManager(mcServer, (WorldServer)worldServer));
            if (!mcServer.func_71264_H()) {
                worldServer.func_72912_H().func_76060_a(mcServer.func_71265_f());
            }
            mcServer.func_147139_a(mcServer.func_147135_j());
            world.updateWorldSettings();
            world.worldLoaded = true;
            world.error = false;
            MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Load((World)worldServer));
            FMLEmbeddedChannel channel = NetworkRegistry.INSTANCE.getChannel("FORGE", Side.SERVER);
            ForgeMessage.DimensionRegisterMessage msg = new ForgeMessage.DimensionRegisterMessage(world.dimensionId, world.providerId);
            channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
            channel.writeOutbound(new Object[]{msg});
        }
        catch (Exception e) {
            world.error = true;
            throw e;
        }
    }

    public int getWorldProviderId(String providerName) throws MultiworldException {
        switch (providerName.toLowerCase()) {
            case "normal": {
                return 0;
            }
            case "nether": {
                return -1;
            }
            case "end": {
                return 1;
            }
        }
        Integer providerId = this.worldProviderClasses.get(providerName);
        if (providerId == null) {
            throw new MultiworldException(MultiworldException.Type.NO_PROVIDER);
        }
        return providerId;
    }

    private static void checkMultiworldPermissions(Multiworld world) {
        for (WorldZone zone : APIRegistry.perms.getServerZone().getWorldZones().values()) {
            String wn = zone.getGroupPermission("_ALL_", PERM_PROP_MULTIWORLD);
            if (wn == null || !wn.equals(world.getName())) continue;
            if (zone.getDimensionID() != world.dimensionId) {
                WorldZone newZone = APIRegistry.perms.getServerZone().getWorldZone(world.dimensionId);
                zone.swapPermissions(newZone);
            }
            return;
        }
    }

    public void unloadWorld(Multiworld world) {
        world.worldLoaded = false;
        world.removeAllPlayersFromWorld();
        DimensionManager.unloadWorld((int)world.getDimensionId());
        this.worldsToRemove.add(DimensionManager.getWorld((int)world.getDimensionId()));
        this.worldsByDim.remove(world.getDimensionId());
        this.worlds.remove(world.getName());
    }

    public void deleteWorld(Multiworld world) {
        this.unloadWorld(world);
        world.delete();
        this.worldsToDelete.add(DimensionManager.getWorld((int)world.getDimensionId()));
    }

    public void serverStopped() {
        this.saveAll();
        for (Multiworld world : this.worlds.values()) {
            world.worldLoaded = false;
            DimensionManager.unregisterDimension((int)world.getDimensionId());
        }
        this.worldsByDim.clear();
        this.worlds.clear();
    }

    public void clearDimensionMap() {
        DimensionManager.loadDimensionDataMap(null);
    }

    @SubscribeEvent
    public void serverTickEvent(TickEvent.ServerTickEvent event) {
        this.unregisterDimensions();
        this.deleteDimensions();
    }

    @SubscribeEvent
    public void worldUnloadEvent(WorldEvent.Unload event) {
        this.unregisterDimensions();
        this.deleteDimensions();
    }

    protected void unregisterDimensions() {
        Iterator<WorldServer> it = this.worldsToRemove.iterator();
        while (it.hasNext()) {
            WorldServer world = it.next();
            if (DimensionManager.getWorld((int)world.field_73011_w.field_76574_g) != null) continue;
            if (DimensionManager.isDimensionRegistered((int)world.field_73011_w.field_76574_g)) {
                DimensionManager.unregisterDimension((int)world.field_73011_w.field_76574_g);
            }
            it.remove();
        }
    }

    protected void deleteDimensions() {
        Iterator<WorldServer> it = this.worldsToDelete.iterator();
        while (it.hasNext()) {
            WorldServer world = it.next();
            if (DimensionManager.getWorld((int)world.field_73011_w.field_76574_g) != null) continue;
            try {
                if (DimensionManager.isDimensionRegistered((int)world.field_73011_w.field_76574_g)) {
                    DimensionManager.unregisterDimension((int)world.field_73011_w.field_76574_g);
                }
                File path = world.getChunkSaveLocation();
                FileUtils.deleteDirectory((File)path);
                it.remove();
            }
            catch (IOException e) {
                OutputHandler.felog.warning("Error deleting dimension files");
            }
        }
    }

    public void loadWorldProviders() {
        try {
            Field f_providers = DimensionManager.class.getDeclaredField("providers");
            f_providers.setAccessible(true);
            Hashtable loadedProviders = (Hashtable)f_providers.get(null);
            for (Map.Entry provider : loadedProviders.entrySet()) {
                if ((Integer)provider.getKey() >= -1 && (Integer)provider.getKey() <= 1) continue;
                this.worldProviderClasses.put(((Class)provider.getValue()).getName(), (Integer)provider.getKey());
            }
            this.worldProviderClasses.put(PROVIDER_NORMAL, 0);
            this.worldProviderClasses.put(PROVIDER_HELL, 1);
            this.worldProviderClasses.put(PROVIDER_END, -1);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        OutputHandler.felog.info("[Multiworld] Available world providers:");
        for (Map.Entry<String, Integer> provider : this.worldProviderClasses.entrySet()) {
            OutputHandler.felog.info("# " + provider.getValue() + ":" + provider.getKey());
        }
    }

    public Map<String, Integer> getWorldProviders() {
        return this.worldProviderClasses;
    }

    public WorldType getWorldTypeByName(String worldType) throws MultiworldException {
        WorldType type = this.worldTypes.get(worldType.toUpperCase());
        if (type == null) {
            throw new MultiworldException(MultiworldException.Type.NO_WORLDTYPE);
        }
        return type;
    }

    public void loadWorldTypes() {
        for (int i = 0; i < WorldType.field_77139_a.length; ++i) {
            String name;
            WorldType type = WorldType.field_77139_a[i];
            if (type == null || (name = type.func_77127_a().toUpperCase()).equals("DEFAULT_1_1")) continue;
            this.worldTypes.put(name, type);
        }
        OutputHandler.felog.info("[Multiworld] Available world types:");
        for (String worldType : this.worldTypes.keySet()) {
            OutputHandler.felog.info("# " + worldType);
        }
    }

    public Map<String, WorldType> getWorldTypes() {
        return this.worldTypes;
    }
}

