/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.multiworld;

import com.forgeessentials.multiworld.Multiworld;
import com.forgeessentials.multiworld.MultiworldManager;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkHandshakeEstablished;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import net.minecraftforge.common.network.ForgeMessage;

public class MultiworldEventHandler
extends ChannelInboundHandlerAdapter {
    private MultiworldManager manager;

    public MultiworldEventHandler(MultiworldManager manager) {
        this.manager = manager;
        NetworkRegistry.INSTANCE.getChannel("FORGE", Side.SERVER).pipeline().addFirst("MultiworldEventHandler", (ChannelHandler)this);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof NetworkHandshakeEstablished) {
            NetworkHandshakeEstablished event = (NetworkHandshakeEstablished)evt;
            FMLEmbeddedChannel channel = NetworkRegistry.INSTANCE.getChannel("FORGE", Side.SERVER);
            channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DISPATCHER);
            channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)event.dispatcher);
            for (Multiworld world : this.manager.getWorlds()) {
                channel.writeOutbound(new Object[]{new ForgeMessage.DimensionRegisterMessage(world.dimensionId, world.providerId)});
            }
        }
        ctx.fireUserEventTriggered(evt);
    }
}

