/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.multiworld;

import com.forgeessentials.commons.selections.WarpPoint;
import com.forgeessentials.core.misc.TeleportHelper;
import com.forgeessentials.data.v2.DataManager;
import com.forgeessentials.util.FunctionHelper;
import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraftforge.common.DimensionManager;

public class Multiworld {
    protected String name;
    protected int dimensionId;
    protected String provider;
    protected String worldType;
    protected List<String> biomes = new ArrayList<String>();
    protected long seed;
    protected boolean mapFeaturesEnabled = true;
    @Expose(serialize=false)
    protected boolean worldLoaded;
    @Expose(serialize=false)
    protected boolean error;
    @Expose(serialize=false)
    protected int providerId;
    @Expose(serialize=false)
    protected WorldType worldTypeObj;

    public Multiworld(String name, String provider, String worldType, long seed) {
        this.name = name;
        this.provider = provider;
        this.worldType = worldType;
        this.seed = seed;
    }

    public Multiworld(String name, String provider, String worldType) {
        this(name, provider, worldType, new Random().nextLong());
    }

    public void removeAllPlayersFromWorld() {
        WorldServer overworld = MinecraftServer.func_71276_C().func_71218_a(0);
        List players = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        for (EntityPlayerMP player : players) {
            if (player.field_71093_bK != this.dimensionId) continue;
            Multiworld.teleport(player, overworld, true);
        }
    }

    public void updateWorldSettings() {
        if (!this.worldLoaded) {
            return;
        }
    }

    public String getName() {
        return this.name;
    }

    public WorldServer getWorldServer() {
        if (!this.worldLoaded) {
            return null;
        }
        return DimensionManager.getWorld((int)this.dimensionId);
    }

    public int getDimensionId() {
        return this.dimensionId;
    }

    public int getProviderId() {
        return this.providerId;
    }

    public String getProvider() {
        return this.provider;
    }

    public List<String> getBiomes() {
        return this.biomes;
    }

    public boolean isError() {
        return this.error;
    }

    public boolean isLoaded() {
        return this.worldLoaded;
    }

    public long getSeed() {
        return this.seed;
    }

    protected void save() {
        DataManager.getInstance().save(this, this.name);
    }

    protected void delete() {
        DataManager.getInstance().delete(this.getClass(), this.name);
    }

    public void teleport(EntityPlayerMP player, boolean instant) {
        Multiworld.teleport(player, this.getWorldServer(), instant);
    }

    public static void teleport(EntityPlayerMP player, WorldServer world, boolean instant) {
        Multiworld.teleport(player, world, player.field_70165_t, player.field_70163_u, player.field_70161_v, instant);
    }

    public static void teleport(EntityPlayerMP player, WorldServer world, double x, double y, double z, boolean instant) {
        boolean worldChange;
        boolean bl = worldChange = player.field_70170_p.field_73011_w.field_76574_g != world.field_73011_w.field_76574_g;
        if (worldChange) {
            Multiworld.displayDepartMessage(player);
        }
        y = FunctionHelper.placeInWorld((World)world, (int)x, (int)y, (int)z);
        WarpPoint target = new WarpPoint(world.field_73011_w.field_76574_g, x, y, z, player.field_70125_A, player.field_70177_z);
        if (instant) {
            TeleportHelper.doTeleport(player, target);
        } else {
            TeleportHelper.teleport(player, target);
        }
        if (worldChange) {
            Multiworld.displayWelcomeMessage(player);
        }
    }

    public static void displayDepartMessage(EntityPlayerMP player) {
    }

    public static void displayWelcomeMessage(EntityPlayerMP player) {
    }
}

