/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.economy.plots;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.api.permissions.AreaZone;
import com.forgeessentials.economy.Offer;
import com.forgeessentials.economy.plots.PlotManager;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.events.PlotEvent;
import com.forgeessentials.util.questioner.Questioner;
import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.command.ICommandSender;

public class TransactionHandler
implements Questioner.IReplyHandler {
    private Offer<AreaZone> offer;

    public TransactionHandler(Offer<AreaZone> offer) {
        this.offer = offer;
    }

    @Override
    public void replyReceived(boolean status) {
        if (!status) {
            OutputHandler.chatNotification((ICommandSender)this.offer.buyer, "The seller declined to sell plot " + ((AreaZone)this.offer.item).getName() + " to you. Transaction cancelled.");
            OutputHandler.chatNotification((ICommandSender)this.offer.seller, "Transaction cancelled.");
            PlotManager.pendingOffers.remove(((AreaZone)this.offer.item).getName());
        } else {
            OutputHandler.chatNotification((ICommandSender)this.offer.buyer, "The seller agreed to sell plot " + ((AreaZone)this.offer.item).getName() + " to you. " + this.offer.price + " will be deducted from your wallet.");
            AreaZone plot = (AreaZone)this.offer.item;
            APIRegistry.getFEEventBus().post((Event)new PlotEvent.OwnerUnset(plot, this.offer.seller));
            APIRegistry.wallet.removeFromWallet(this.offer.price, this.offer.buyer.getPersistentID());
            APIRegistry.wallet.addToWallet(this.offer.price, this.offer.seller.getPersistentID());
            plot.setGroupPermissionProperty("_ALL_", "fe.economy.plots.data.owner", this.offer.buyer.getPersistentID().toString());
            OutputHandler.chatNotification((ICommandSender)this.offer.seller, "Transaction complete. " + this.offer.price + "added to your wallet.");
            OutputHandler.chatNotification((ICommandSender)this.offer.buyer, "Transaction complete. You are now owner of " + plot.getName());
            PlotManager.pendingOffers.remove(((AreaZone)this.offer.item).getName());
        }
    }
}

