/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.economy.commands.plots;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.api.permissions.AreaZone;
import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.economy.Offer;
import com.forgeessentials.economy.plots.PlotManager;
import com.forgeessentials.util.OutputHandler;
import java.util.Map;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandListPlot
extends ForgeEssentialsCommandBase {
    @Override
    public void processCommandConsole(ICommandSender sender, String[] args) {
        OutputHandler.chatNotification(sender, "Listing ALL plots:");
        for (AreaZone plot : PlotManager.getPlotList()) {
            PlotManager.printPlotDetails(sender, plot);
        }
    }

    @Override
    public void processCommandPlayer(EntityPlayerMP player, String[] args) {
        if (args[0].equals("sale")) {
            if (args[1].equals("add")) {
                AreaZone zone = (AreaZone)APIRegistry.perms.getZoneById("[PLOT]" + args[2]);
                PlotManager.pendingOffers.put(args[2], new Offer<AreaZone>(null, (EntityPlayer)player, zone, Integer.parseInt(args[3])));
            } else if (args[1].equals("remove")) {
                PlotManager.pendingOffers.remove(args[2]);
            } else {
                OutputHandler.chatNotification((ICommandSender)player, "Listing all plots for sale:");
                for (Map.Entry<String, Offer<AreaZone>> offer : PlotManager.pendingOffers.entrySet()) {
                    if (offer.getValue().buyer != null) continue;
                    PlotManager.printPlotDetails((ICommandSender)player, (AreaZone)offer.getValue().item);
                }
            }
        } else {
            OutputHandler.chatNotification((ICommandSender)player, "Listing ALL plots:");
            for (AreaZone plot : PlotManager.getPlotList()) {
                PlotManager.printPlotDetails((ICommandSender)player, plot);
            }
        }
    }

    @Override
    public boolean canConsoleUseCommand() {
        return true;
    }

    @Override
    public String getPermissionNode() {
        return "fe.commands.plot.list";
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.TRUE;
    }

    public String func_71517_b() {
        return "plotlist";
    }

    public String func_71518_a(ICommandSender p_71518_1_) {
        return "/plotlist [sale] [add|remove] [plotName]";
    }
}

